/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import java.util.UUID;
import org.eclipse.core.runtime.Platform;
import org.eclipse.linuxtools.internal.docker.ui.databinding.BaseDatabindingModel;
import org.eclipse.linuxtools.internal.docker.ui.launch.LaunchConfigurationUtils;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageRunResourceVolumesVariablesModel;

public class DataVolumeModel
extends BaseDatabindingModel
implements Comparable<DataVolumeModel> {
    private static final String SEPARATOR = ":";
    public static final String CONTAINER_PATH = "containerPath";
    public static final String MOUNT_TYPE = "mountType";
    public static final String MOUNT = "mount";
    public static final String HOST_PATH_MOUNT = "hostPathMount";
    public static final String READ_ONLY_VOLUME = "readOnly";
    public static final String CONTAINER_MOUNT = "containerMount";
    public static final String SELECTED = "selected";
    private final String id = UUID.randomUUID().toString();
    private String containerPath;
    private ImageRunResourceVolumesVariablesModel.MountType mountType;
    private String mount;
    private String hostPathMount;
    private String containerMount;
    private boolean readOnly = false;
    private boolean selected;

    public DataVolumeModel() {
    }

    public DataVolumeModel(String containerPath) {
        this.containerPath = containerPath;
        this.mountType = ImageRunResourceVolumesVariablesModel.MountType.NONE;
    }

    public DataVolumeModel(String containerPath, String hostPath, boolean readOnly) {
        this.containerPath = containerPath;
        this.mountType = ImageRunResourceVolumesVariablesModel.MountType.HOST_FILE_SYSTEM;
        this.mount = this.hostPathMount = hostPath;
        this.readOnly = readOnly;
    }

    public DataVolumeModel(DataVolumeModel selectedDataVolume) {
        this.containerPath = selectedDataVolume.getContainerPath();
        this.mountType = selectedDataVolume.getMountType();
        if (this.mountType != null) {
            switch (this.mountType) {
                case CONTAINER: {
                    this.containerMount = selectedDataVolume.getMount();
                    break;
                }
                case HOST_FILE_SYSTEM: {
                    this.hostPathMount = selectedDataVolume.getMount();
                    this.readOnly = selectedDataVolume.isReadOnly();
                    break;
                }
            }
        } else {
            this.mountType = ImageRunResourceVolumesVariablesModel.MountType.NONE;
        }
    }

    public static DataVolumeModel parseString(String fromString) {
        DataVolumeModel model = new DataVolumeModel();
        String[] items = fromString.split(SEPARATOR);
        model.containerPath = items[0];
        model.mountType = ImageRunResourceVolumesVariablesModel.MountType.valueOf(items[1]);
        switch (model.mountType) {
            case CONTAINER: {
                model.setContainerMount(items[2]);
                model.setSelected(Boolean.valueOf(items[3]));
                break;
            }
            case HOST_FILE_SYSTEM: {
                if ("win32".equals(Platform.getOS()) && items.length > 5) {
                    model.setHostPathMount(items[2] + SEPARATOR + items[3]);
                    model.setReadOnly(Boolean.valueOf(items[4]));
                    model.setSelected(Boolean.valueOf(items[5]));
                    break;
                }
                model.setHostPathMount(items[2]);
                model.setReadOnly(Boolean.valueOf(items[3]));
                model.setSelected(Boolean.valueOf(items[4]));
                break;
            }
            case NONE: {
                model.setSelected(Boolean.valueOf(items[2]));
            }
        }
        return model;
    }

    public static DataVolumeModel parseVolumeFrom(String volumeFrom) {
        DataVolumeModel model = new DataVolumeModel();
        model.mountType = ImageRunResourceVolumesVariablesModel.MountType.CONTAINER;
        model.containerMount = volumeFrom;
        model.selected = true;
        return model;
    }

    public static DataVolumeModel parseHostBinding(String volumeFrom) {
        DataVolumeModel model = new DataVolumeModel();
        String[] items = volumeFrom.split(SEPARATOR);
        model.setHostPathMount(LaunchConfigurationUtils.convertToWin32Path(items[0]));
        model.containerPath = items[1];
        model.mountType = ImageRunResourceVolumesVariablesModel.MountType.HOST_FILE_SYSTEM;
        if (items[2].equals("ro")) {
            model.setReadOnly(true);
        } else {
            model.setReadOnly(false);
        }
        model.selected = true;
        return model;
    }

    public String getContainerPath() {
        return this.containerPath;
    }

    public void setContainerPath(String containerPath) {
        this.containerPath = containerPath;
        this.firePropertyChange(CONTAINER_PATH, this.containerPath, this.containerPath);
    }

    public String getMount() {
        return this.mount;
    }

    public void setMount(String mount) {
        this.mount = mount;
        this.firePropertyChange(MOUNT, this.mount, this.mount);
    }

    public ImageRunResourceVolumesVariablesModel.MountType getMountType() {
        return this.mountType;
    }

    public void setMountType(ImageRunResourceVolumesVariablesModel.MountType mountType) {
        if (mountType == null) {
            return;
        }
        this.mountType = mountType;
        this.firePropertyChange(MOUNT_TYPE, (Object)this.mountType, (Object)this.mountType);
        if (this.mountType == ImageRunResourceVolumesVariablesModel.MountType.NONE) {
            this.setMount("");
        }
    }

    public String getHostPathMount() {
        return this.hostPathMount;
    }

    public void setHostPathMount(String hostPathMount) {
        this.hostPathMount = hostPathMount;
        this.firePropertyChange(HOST_PATH_MOUNT, this.hostPathMount, this.hostPathMount);
        if (this.mountType == ImageRunResourceVolumesVariablesModel.MountType.HOST_FILE_SYSTEM) {
            this.setMount(this.hostPathMount);
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.firePropertyChange(READ_ONLY_VOLUME, this.readOnly, this.readOnly);
    }

    public String getContainerMount() {
        return this.containerMount;
    }

    public void setContainerMount(String containerMount) {
        this.containerMount = containerMount;
        this.firePropertyChange(CONTAINER_MOUNT, this.containerMount, this.containerMount);
        if (this.mountType == ImageRunResourceVolumesVariablesModel.MountType.CONTAINER) {
            this.setMount(this.containerMount);
        }
    }

    public boolean getSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.firePropertyChange(SELECTED, this.selected, this.selected);
    }

    @Override
    public int compareTo(DataVolumeModel other) {
        return this.getContainerPath().compareTo(other.getContainerPath());
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.containerPath + SEPARATOR + String.valueOf((Object)this.getMountType()) + SEPARATOR);
        switch (this.getMountType()) {
            case CONTAINER: {
                buffer.append(this.getContainerMount());
                break;
            }
            case HOST_FILE_SYSTEM: {
                buffer.append(this.getHostPathMount() + SEPARATOR);
                buffer.append(this.isReadOnly());
                break;
            }
        }
        buffer.append(SEPARATOR).append(this.selected);
        return buffer.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataVolumeModel other = (DataVolumeModel)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

