/*
 * Copyright (c) 2012, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package org.glassfish.hk2.api;

/**
 * Every proxy generated by HK2 will implement this interface, which can be used to have finer
 * control on the behavior of the proxy
 * <p>
 * Compare this to the {@link AOPProxyCtl} interface, which is
 * implemented by proxies used for the AOPAlliance method
 * or constructor interceptor feature
 * 
 * @author jwells
 */
public interface ProxyCtl {
    /**
     * This method causes the proxy instance to get created at the current time, without
     * calling any of the methods on the underlying class itself.  This is useful if you
     * need to have the underlying object get created and go through its initialization
     * cycle at a specific time, but do not wish to invoke any specific method on
     * the object.
     * 
     * @return The underlying instance of the service (not wrapped by the proxy)
     * @throws MultiException If there was an error creating the proxy a MultiException will
     * be thrown containing the underlying cause or causes
     */
    public Object __make() throws MultiException;

}
