/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.util.osgi.manifest.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.virgo.util.common.CaseInsensitiveMap;
import org.eclipse.virgo.util.osgi.manifest.BundleActivationPolicy;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.BundleSymbolicName;
import org.eclipse.virgo.util.osgi.manifest.DynamicImportPackage;
import org.eclipse.virgo.util.osgi.manifest.ExportPackage;
import org.eclipse.virgo.util.osgi.manifest.FragmentHost;
import org.eclipse.virgo.util.osgi.manifest.ImportBundle;
import org.eclipse.virgo.util.osgi.manifest.ImportLibrary;
import org.eclipse.virgo.util.osgi.manifest.ImportPackage;
import org.eclipse.virgo.util.osgi.manifest.Parseable;
import org.eclipse.virgo.util.osgi.manifest.RequireBundle;
import org.eclipse.virgo.util.osgi.manifest.internal.HeaderUtils;
import org.eclipse.virgo.util.osgi.manifest.internal.StandardBundleActivationPolicy;
import org.eclipse.virgo.util.osgi.manifest.internal.StandardBundleSymbolicName;
import org.eclipse.virgo.util.osgi.manifest.internal.StandardDynamicImportPackage;
import org.eclipse.virgo.util.osgi.manifest.internal.StandardExportPackage;
import org.eclipse.virgo.util.osgi.manifest.internal.StandardFragmentHost;
import org.eclipse.virgo.util.osgi.manifest.internal.StandardImportBundle;
import org.eclipse.virgo.util.osgi.manifest.internal.StandardImportLibrary;
import org.eclipse.virgo.util.osgi.manifest.internal.StandardImportPackage;
import org.eclipse.virgo.util.osgi.manifest.internal.StandardRequireBundle;
import org.eclipse.virgo.util.osgi.manifest.parse.HeaderParser;
import org.eclipse.virgo.util.osgi.manifest.parse.ParserLogger;
import org.eclipse.virgo.util.osgi.manifest.parse.standard.StandardHeaderParser;
import org.eclipse.virgo.util.parser.manifest.ManifestContents;
import org.eclipse.virgo.util.parser.manifest.ManifestProblem;
import org.eclipse.virgo.util.parser.manifest.ManifestProblemKind;
import org.eclipse.virgo.util.parser.manifest.RecoveringManifestParser;
import org.osgi.framework.Version;

public class StandardBundleManifest
implements BundleManifest {
    private static final String MANIFEST_VERSION = "Manifest-Version";
    static final String MANIFEST_VERSION_VALUE = "1.0";
    private final CaseInsensitiveMap<String> contents = new CaseInsensitiveMap();
    private final CaseInsensitiveMap<Parseable> headers;

    public StandardBundleManifest(ParserLogger logger) {
        this(logger, (Map<String, String>)new Hashtable<String, String>());
    }

    public StandardBundleManifest(ParserLogger logger, Map<String, String> contents) {
        this.contents.putAll(contents);
        if (!this.contents.containsKey((Object)MANIFEST_VERSION)) {
            this.contents.put(MANIFEST_VERSION, (Object)MANIFEST_VERSION_VALUE);
        }
        this.headers = StandardBundleManifest.initializeHeaders(this.contents, new StandardHeaderParser(logger));
    }

    public StandardBundleManifest(ParserLogger logger, Dictionary<String, String> contents) {
        this(logger, StandardBundleManifest.dictionaryToMap(contents));
    }

    private static Map<String, String> dictionaryToMap(Dictionary<String, String> contents) {
        HashMap<String, String> map = new HashMap<String, String>(contents.size());
        Enumeration<String> keys = contents.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            map.put(key, contents.get(key));
        }
        return map;
    }

    public StandardBundleManifest(ParserLogger logger, Reader reader) throws IOException {
        this(logger, StandardBundleManifest.parseContents(reader));
    }

    public StandardBundleManifest(ParserLogger logger, ManifestContents manifestContents) {
        this(logger, manifestContents.getMainAttributes());
    }

    private static ManifestContents parseContents(Reader reader) throws IOException {
        RecoveringManifestParser parser = new RecoveringManifestParser();
        parser.setTerminateAfterMainSection(true);
        ManifestContents contents = parser.parse(reader);
        if (parser.foundProblems()) {
            List problems = parser.getProblems();
            for (ManifestProblem problem : problems) {
                if (problem.getKind().equals((Object)ManifestProblemKind.ILLEGAL_NAME_CHAR) || problem.getKind().equals((Object)ManifestProblemKind.VALUE_TOO_LONG)) continue;
                throw new IOException(problems.toString());
            }
        }
        return contents;
    }

    private static CaseInsensitiveMap<Parseable> initializeHeaders(Map<String, String> contents, HeaderParser parser) {
        CaseInsensitiveMap<Parseable> headers = StandardBundleManifest.createHeadersMap(parser);
        for (Map.Entry entry : headers.entrySet()) {
            String value = contents.get(entry.getKey());
            if (value == null) continue;
            ((Parseable)entry.getValue()).resetFromParseString(value);
        }
        return headers;
    }

    private static CaseInsensitiveMap<Parseable> createHeadersMap(HeaderParser parser) {
        CaseInsensitiveMap headers = new CaseInsensitiveMap();
        headers.put("Bundle-ActivationPolicy", (Object)new StandardBundleActivationPolicy(parser));
        headers.put("Bundle-SymbolicName", (Object)new StandardBundleSymbolicName(parser));
        headers.put("DynamicImport-Package", (Object)new StandardDynamicImportPackage(parser));
        headers.put("Export-Package", (Object)new StandardExportPackage(parser));
        headers.put("Fragment-Host", (Object)new StandardFragmentHost(parser));
        headers.put("Import-Bundle", (Object)new StandardImportBundle(parser));
        headers.put("Import-Library", (Object)new StandardImportLibrary(parser));
        headers.put("Import-Package", (Object)new StandardImportPackage(parser));
        headers.put("Require-Bundle", (Object)new StandardRequireBundle(parser));
        return headers;
    }

    @Override
    public BundleActivationPolicy getBundleActivationPolicy() {
        return (BundleActivationPolicy)this.headers.get((Object)"Bundle-ActivationPolicy");
    }

    @Override
    public List<String> getBundleClasspath() {
        return HeaderUtils.toList("Bundle-ClassPath", this.contents);
    }

    @Override
    public String getBundleDescription() {
        return (String)this.contents.get((Object)"Bundle-Description");
    }

    @Override
    public int getBundleManifestVersion() {
        int bundleManifestVersion = 1;
        String value = (String)this.contents.get((Object)"Bundle-ManifestVersion");
        if (value != null) {
            bundleManifestVersion = Integer.parseInt(value);
        }
        return bundleManifestVersion;
    }

    @Override
    public String getBundleName() {
        return (String)this.contents.get((Object)"Bundle-Name");
    }

    @Override
    public BundleSymbolicName getBundleSymbolicName() {
        return (BundleSymbolicName)this.headers.get((Object)"Bundle-SymbolicName");
    }

    @Override
    public URL getBundleUpdateLocation() {
        URL updateLocation = null;
        String value = (String)this.contents.get((Object)"Bundle-UpdateLocation");
        if (value != null) {
            try {
                updateLocation = new URL(value);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return updateLocation;
    }

    @Override
    public DynamicImportPackage getDynamicImportPackage() {
        return (DynamicImportPackage)this.headers.get((Object)"DynamicImport-Package");
    }

    @Override
    public ExportPackage getExportPackage() {
        return (ExportPackage)this.headers.get((Object)"Export-Package");
    }

    @Override
    public FragmentHost getFragmentHost() {
        return (FragmentHost)this.headers.get((Object)"Fragment-Host");
    }

    @Override
    public ImportBundle getImportBundle() {
        return (ImportBundle)this.headers.get((Object)"Import-Bundle");
    }

    @Override
    public ImportLibrary getImportLibrary() {
        return (ImportLibrary)this.headers.get((Object)"Import-Library");
    }

    @Override
    public ImportPackage getImportPackage() {
        return (ImportPackage)this.headers.get((Object)"Import-Package");
    }

    @Override
    public String getModuleScope() {
        return (String)this.contents.get((Object)"Module-Scope");
    }

    @Override
    public String getModuleType() {
        return (String)this.contents.get((Object)"Module-Type");
    }

    @Override
    public RequireBundle getRequireBundle() {
        return (RequireBundle)this.headers.get((Object)"Require-Bundle");
    }

    @Override
    public void setBundleDescription(String bundleDescription) {
        if (bundleDescription == null) {
            this.contents.remove((Object)"Bundle-Description");
        } else {
            this.contents.put("Bundle-Description", (Object)bundleDescription);
        }
    }

    @Override
    public void setBundleManifestVersion(int bundleManifestVersion) {
        this.contents.put("Bundle-ManifestVersion", (Object)Integer.toString(bundleManifestVersion));
    }

    @Override
    public void setBundleName(String bundleName) {
        if (bundleName == null) {
            this.contents.remove((Object)"Bundle-Name");
        } else {
            this.contents.put("Bundle-Name", (Object)bundleName);
        }
    }

    @Override
    public void setBundleUpdateLocation(URL bundleUpdateLocation) {
        if (bundleUpdateLocation == null) {
            this.contents.remove((Object)"Bundle-UpdateLocation");
        } else {
            this.contents.put("Bundle-UpdateLocation", (Object)bundleUpdateLocation.toExternalForm());
        }
    }

    @Override
    public void setModuleScope(String moduleScope) {
        if (moduleScope == null) {
            this.contents.remove((Object)"Module-Scope");
        } else {
            this.contents.put("Module-Scope", (Object)moduleScope);
        }
    }

    @Override
    public void setModuleType(String moduleType) {
        if (moduleType == null) {
            this.contents.remove((Object)"Module-Type");
        } else {
            this.contents.put("Module-Type", (Object)moduleType);
        }
    }

    @Override
    public Dictionary<String, String> toDictionary() {
        this.synchroniseContentsWithHeaders();
        Hashtable<String, String> output = new Hashtable<String, String>();
        output.putAll((Map<String, String>)this.contents);
        return output;
    }

    @Override
    public Version getBundleVersion() {
        String value = (String)this.contents.get((Object)"Bundle-Version");
        if (value != null) {
            return new Version(value);
        }
        return Version.emptyVersion;
    }

    @Override
    public void setBundleVersion(Version bundleVersion) {
        if (bundleVersion != null) {
            this.contents.put("Bundle-Version", (Object)bundleVersion.toString());
        } else {
            this.contents.remove((Object)"Bundle-Version");
        }
    }

    @Override
    public String getHeader(String name) {
        this.synchroniseContentsWithHeaders();
        return (String)this.contents.get((Object)name);
    }

    private void synchroniseContentsWithHeaders() {
        for (Map.Entry content : this.contents.entrySet()) {
            Parseable header = (Parseable)this.headers.get(content.getKey());
            if (header == null) continue;
            String headerValue = header.toParseString();
            if (headerValue != null) {
                this.contents.put((String)content.getKey(), (Object)headerValue);
                continue;
            }
            this.contents.remove(content.getKey());
        }
        for (Map.Entry header : this.headers.entrySet()) {
            String headerValue;
            if (this.contents.get(header.getKey()) != null || (headerValue = ((Parseable)header.getValue()).toParseString()) == null) continue;
            this.contents.put((String)header.getKey(), (Object)headerValue);
        }
    }

    @Override
    public void setHeader(String name, String value) {
        if (value == null) {
            this.contents.remove((Object)name);
        } else {
            this.contents.put(name, (Object)value);
        }
        Parseable header = (Parseable)this.headers.get((Object)name);
        if (header != null) {
            header.resetFromParseString(value);
        }
    }

    @Override
    public void write(Writer writer) throws IOException {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        Dictionary<String, String> dictionary = this.toDictionary();
        Enumeration<String> keys = dictionary.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            attributes.putValue(key, dictionary.get(key));
        }
        WriterOutputStream writerOutputStream = new WriterOutputStream(writer);
        try {
            manifest.write(writerOutputStream);
        }
        finally {
            ((OutputStream)writerOutputStream).close();
        }
    }

    public String toString() {
        StringWriter outputManifest = new StringWriter();
        try {
            this.write(outputManifest);
        }
        catch (Exception exception) {}
        return outputManifest.toString();
    }

    public static class WriterOutputStream
    extends OutputStream {
        private final Writer writer;

        public WriterOutputStream(Writer writer) {
            this.writer = writer;
        }

        @Override
        public void write(int b) throws IOException {
            this.writer.write(b);
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }
    }
}

