/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.session;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.catalina.DistributedManager;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Session;
import org.apache.catalina.ha.CatalinaCluster;
import org.apache.catalina.ha.ClusterManager;
import org.apache.catalina.ha.ClusterMessage;
import org.apache.catalina.ha.session.ClusterManagerBase;
import org.apache.catalina.ha.session.DeltaSession;
import org.apache.catalina.tribes.tipis.AbstractReplicatedMap;
import org.apache.catalina.tribes.tipis.LazyReplicatedMap;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class BackupManager
extends ClusterManagerBase
implements AbstractReplicatedMap.MapOwner,
DistributedManager {
    private static final Log log = LogFactory.getLog(BackupManager.class);
    protected static long DEFAULT_REPL_TIMEOUT = 15000L;
    protected boolean mExpireSessionsOnShutdown = true;
    protected String name;
    protected CatalinaCluster cluster;
    private boolean notifyListenersOnReplication;
    private int mapSendOptions = 6;

    @Override
    public void messageDataReceived(ClusterMessage msg) {
    }

    public void setExpireSessionsOnShutdown(boolean expireSessionsOnShutdown) {
        this.mExpireSessionsOnShutdown = expireSessionsOnShutdown;
    }

    @Override
    public void setCluster(CatalinaCluster cluster) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Cluster associated with BackupManager");
        }
        this.cluster = cluster;
    }

    public boolean getExpireSessionsOnShutdown() {
        return this.mExpireSessionsOnShutdown;
    }

    @Override
    public ClusterMessage requestCompleted(String sessionId) {
        if (!this.getState().isAvailable()) {
            return null;
        }
        LazyReplicatedMap map = (LazyReplicatedMap)this.sessions;
        map.replicate((Object)sessionId, false);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void objectMadePrimay(Object key, Object value) {
        if (value != null && value instanceof DeltaSession) {
            DeltaSession session;
            DeltaSession deltaSession = session = (DeltaSession)value;
            synchronized (deltaSession) {
                session.access();
                session.setPrimarySession(true);
                session.endAccess();
            }
        }
    }

    public Session createEmptySession() {
        return new DeltaSession(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected synchronized void startInternal() throws LifecycleException {
        super.startInternal();
        try {
            this.cluster.registerManager(this);
            CatalinaCluster catclust = this.cluster;
            LazyReplicatedMap map = new LazyReplicatedMap((AbstractReplicatedMap.MapOwner)this, catclust.getChannel(), DEFAULT_REPL_TIMEOUT, this.getMapName(), this.getClassLoaders());
            map.setChannelSendOptions(this.mapSendOptions);
            this.sessions = map;
        }
        catch (Exception x) {
            log.error((Object)"Unable to start BackupManager", (Throwable)x);
            throw new LifecycleException("Failed to start BackupManager", (Throwable)x);
        }
        this.setState(LifecycleState.STARTING);
    }

    public String getMapName() {
        CatalinaCluster catclust = this.cluster;
        String name = catclust.getManagerName(this.getName(), this) + "-" + "map";
        if (log.isDebugEnabled()) {
            log.debug((Object)("Backup manager, Setting map name to:" + name));
        }
        return name;
    }

    protected synchronized void stopInternal() throws LifecycleException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Stopping");
        }
        this.setState(LifecycleState.STOPPING);
        if (this.sessions instanceof LazyReplicatedMap) {
            LazyReplicatedMap map = (LazyReplicatedMap)this.sessions;
            map.breakdown();
        }
        this.cluster.removeManager(this);
        super.stopInternal();
    }

    public void setDistributable(boolean dist) {
        this.distributable = dist;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isNotifyListenersOnReplication() {
        return this.notifyListenersOnReplication;
    }

    public void setNotifyListenersOnReplication(boolean notifyListenersOnReplication) {
        this.notifyListenersOnReplication = notifyListenersOnReplication;
    }

    public void setMapSendOptions(int mapSendOptions) {
        this.mapSendOptions = mapSendOptions;
    }

    @Override
    public CatalinaCluster getCluster() {
        return this.cluster;
    }

    public int getMapSendOptions() {
        return this.mapSendOptions;
    }

    @Override
    public String[] getInvalidatedSessions() {
        return new String[0];
    }

    @Override
    public ClusterManager cloneFromTemplate() {
        BackupManager result = new BackupManager();
        result.mExpireSessionsOnShutdown = this.mExpireSessionsOnShutdown;
        result.name = "Clone-from-" + this.name;
        result.cluster = this.cluster;
        result.notifyListenersOnReplication = this.notifyListenersOnReplication;
        result.mapSendOptions = this.mapSendOptions;
        result.maxActiveSessions = this.maxActiveSessions;
        return result;
    }

    public int getActiveSessionsFull() {
        LazyReplicatedMap map = (LazyReplicatedMap)this.sessions;
        return map.sizeFull();
    }

    public Set<String> getSessionIdsFull() {
        HashSet<String> sessionIds = new HashSet<String>();
        LazyReplicatedMap map = (LazyReplicatedMap)this.sessions;
        Iterator keys = map.keySetFull().iterator();
        while (keys.hasNext()) {
            sessionIds.add((String)keys.next());
        }
        return sessionIds;
    }
}

