/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.ide;

import com.google.gson.JsonElement;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.ide.server.ILanguageServerAccess;
import org.eclipse.xtext.ide.server.commands.IExecutableCommandService;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;

public class CommandService
implements IExecutableCommandService {
    private static final Logger LOG = Logger.getLogger(CommandService.class);
    private EObjectAtOffsetHelper offsetHelper;
    private RoomHelpers roomHelper;

    @Inject
    public CommandService(EObjectAtOffsetHelper offsetHelper, RoomHelpers roomHelper) {
        this.offsetHelper = offsetHelper;
        this.roomHelper = roomHelper;
    }

    public List<String> initialize() {
        return Collections.singletonList("room.requestActorAtPosition");
    }

    public Object execute(ExecuteCommandParams params, ILanguageServerAccess access, CancelIndicator cancelIndicator) {
        if (params.getCommand().equals("room.requestActorAtPosition")) {
            String uri = ((JsonElement)params.getArguments().get(0)).getAsString();
            String cursorOffset = ((JsonElement)params.getArguments().get(1)).getAsString();
            try {
                return access.doRead(uri, context -> {
                    ActorClass ac;
                    EObject eObject = this.offsetHelper.resolveContainedElementAt((XtextResource)context.getResource(), Integer.parseInt(cursorOffset));
                    if (eObject == null) {
                        return new ErrorResponse("Error: No ActorClass found. Please specify an ActorClass by moving the cursor inside the ActorClass definition.");
                    }
                    ActorClass actorClass = ac = eObject instanceof ActorClass ? (ActorClass)eObject : this.roomHelper.getActorClass(eObject);
                    if (ac == null) {
                        return new ErrorResponse("Error: No ActorClass found. Please specify an ActorClass by moving the cursor inside the ActorClass definition.");
                    }
                    return new Response(EcoreUtil2.getNormalizedURI((EObject)ac).toString());
                }).get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error((Object)e);
                return new ErrorResponse("Unexpected Error in the language server while reading the requested document.");
            }
        }
        throw new IllegalArgumentException("The Command: " + params.getCommand() + " is not implemented by the CommandService");
    }

    private record ErrorResponse(String errorCode) {
    }

    private record Response(String linkedObjectUri) {
    }
}

