/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.ui.wizard;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.ui.CommonUIPlugin;
import org.eclipse.emf.common.util.URI;

public class WizardHelpers {
    public static ZipFile getCRuntimeZip() {
        return WizardHelpers.getExampleZip("org.eclipse.etrice.runtime.c");
    }

    public static ZipFile getCModellibZip() {
        return WizardHelpers.getExampleZip("org.eclipse.etrice.modellib.c");
    }

    private static ZipFile getExampleZip(String name) {
        ZipFile zipFile = null;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(CommonUIPlugin.INSTANCE.getSymbolicName(), "examples");
        IConfigurationElement[] exampleElements = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < exampleElements.length) {
            IConfigurationElement exampleElement = exampleElements[i];
            IConfigurationElement[] projectDescriptorElements = exampleElement.getChildren("projectDescriptor");
            int j = 0;
            while (j < projectDescriptorElements.length) {
                String contentURI;
                IConfigurationElement projectDescriptorElement = projectDescriptorElements[j];
                String projectName = projectDescriptorElement.getAttribute("name");
                if (projectName != null && projectName.equals(name) && (contentURI = projectDescriptorElement.getAttribute("contentURI")) != null) {
                    File file;
                    String location;
                    URI uri = URI.createURI((String)contentURI);
                    if (uri.isRelative()) {
                        uri = URI.createPlatformPluginURI((String)(projectDescriptorElement.getContributor().getName() + "/" + contentURI), (boolean)true);
                    }
                    if (uri.isPlatform()) {
                        uri = CommonPlugin.asLocalURI((URI)uri);
                    }
                    if ((location = uri.toFileString()) != null && (file = new File(location)).isFile() && file.canRead()) {
                        zipFile = WizardHelpers.createZipFile(file);
                    }
                }
                if (zipFile != null) break;
                ++j;
            }
            if (zipFile != null) break;
            ++i;
        }
        return zipFile;
    }

    private static ZipFile createZipFile(File file) {
        try {
            return new ZipFile(file);
        }
        catch (ZipException zipException) {
        }
        catch (IOException iOException) {}
        return null;
    }
}

