/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.postchk;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.annotations.AnnotatedObject;
import org.eclipse.escet.cif.metamodel.cif.annotations.Annotation;
import org.eclipse.escet.cif.metamodel.java.CifWalker;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.annotations.AnnotationProblemReporter;
import org.eclipse.escet.cif.typechecker.annotations.AnnotationProvider;
import org.eclipse.escet.cif.typechecker.annotations.DoNothingAnnotationProvider;
import org.eclipse.escet.cif.typechecker.postchk.CifPostCheckEnv;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.typechecker.SemanticProblemSeverity;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

public class CifAnnotationsPostChecker
extends CifWalker {
    private final CifPostCheckEnv env;
    private final ProblemReporter reporter = new ProblemReporter();
    private final Map<String, AnnotationProvider> createdProviders = Maps.map();
    private final Map<String, AnnotationProvider> annotationProviders = Maps.map();

    public CifAnnotationsPostChecker(CifPostCheckEnv env) {
        this.env = env;
    }

    public void check(Specification spec) {
        Assert.check((!CifScopeUtils.hasCompDefInst((Group)spec) ? 1 : 0) != 0, (Object)"Can't post check annotations on spec with comp def/inst.");
        this.walkSpecification(spec);
        for (AnnotationProvider provider : this.createdProviders.values()) {
            provider.checkGlobal(spec, this.reporter);
        }
    }

    protected void preprocessAnnotatedObject(AnnotatedObject annotatedObj) {
        for (Annotation annotation : annotatedObj.getAnnotations()) {
            AnnotationProvider provider = this.ensureProvider(annotation);
            provider.checkAnnotation(annotatedObj, annotation, this.reporter);
        }
    }

    private AnnotationProvider ensureProvider(Annotation annotation) {
        String annotationName = annotation.getName();
        AnnotationProvider provider = this.annotationProviders.get(annotationName);
        if (provider != null) {
            return provider;
        }
        IConfigurationElement extension = this.getExtensionPoint(annotationName, annotation.getPosition());
        if (extension == null) {
            provider = new DoNothingAnnotationProvider();
            this.annotationProviders.put(annotationName, provider);
            return provider;
        }
        String extensionKey = this.getExtensionPluginName(extension) + "/" + this.getExtensionClassName(extension);
        provider = this.createdProviders.get(extensionKey);
        if (provider != null) {
            this.annotationProviders.put(annotationName, provider);
            return provider;
        }
        provider = this.tryCreateAnnotationProvider(extension, annotation.getPosition());
        if (provider != null) {
            this.createdProviders.put(extensionKey, provider);
            this.annotationProviders.put(annotationName, provider);
            return provider;
        }
        provider = new DoNothingAnnotationProvider();
        this.annotationProviders.put(annotationName, provider);
        return provider;
    }

    private IConfigurationElement getExtensionPoint(String annotationName, Position position) {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        String extensionPointId = "org.eclipse.escet.cif.annotations";
        IConfigurationElement[] extensions = registry.getConfigurationElementsFor(extensionPointId);
        List goodExtensions = Lists.listc((int)1);
        boolean anyIssue = false;
        IConfigurationElement[] iConfigurationElementArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement extension = iConfigurationElementArray[n2];
            if ("provider".equals(extension.getName()) && annotationName.equals(this.getExtensionAnnotationName(extension))) {
                if (!this.checkAnnotationProviderExtension(extension, position)) {
                    anyIssue = true;
                } else {
                    goodExtensions.add(extension);
                }
            }
            ++n2;
        }
        if (anyIssue) {
            return null;
        }
        if (goodExtensions.size() == 1) {
            return (IConfigurationElement)goodExtensions.get(0);
        }
        if (goodExtensions.isEmpty()) {
            this.env.addProblem(ErrMsg.ANNO_UNREGISTERED_NAME, position, annotationName);
        } else if (goodExtensions.size() > 1) {
            String names = goodExtensions.stream().map(ext -> Strings.fmt((String)"\"%s\"", (Object[])new Object[]{this.getExtensionClassName((IConfigurationElement)ext)})).sorted(Strings.SORTER).collect(Collectors.joining(", "));
            this.env.addProblem(ErrMsg.ANNO_PROVIDER_ERROR, position, annotationName, Strings.fmt((String)"multiple annotation providers are registered for the annotation in the current environment: %s.", (Object[])new Object[]{names}));
        }
        return null;
    }

    private boolean checkAnnotationProviderExtension(IConfigurationElement extension, Position position) {
        String annotationName = this.getExtensionAnnotationName(extension);
        String contributorName = this.getExtensionContributorName(extension);
        String pluginName = this.getExtensionPluginName(extension);
        if (pluginName == null) {
            this.env.addProblem(ErrMsg.ANNO_PROVIDER_ERROR, position, annotationName, Strings.fmt((String)"annotation provider does not specify a plugin (contributed by \"%s\").", (Object[])new Object[]{contributorName}));
            return false;
        }
        String className = this.getExtensionClassName(extension);
        if (className == null) {
            this.env.addProblem(ErrMsg.ANNO_PROVIDER_ERROR, position, annotationName, Strings.fmt((String)"annotation provider does not specify a class (contributed by \"%s\").", (Object[])new Object[]{contributorName}));
            return false;
        }
        return true;
    }

    private AnnotationProvider tryCreateAnnotationProvider(IConfigurationElement extension, Position position) {
        Class<?> cls;
        boolean stateOk;
        String contributorName = this.getExtensionContributorName(extension);
        String annotationName = this.getExtensionAnnotationName(extension);
        String pluginName = this.getExtensionPluginName(extension);
        String className = this.getExtensionClassName(extension);
        Assert.notNull((Object)annotationName);
        Assert.notNull((Object)pluginName);
        Assert.notNull((Object)className);
        Bundle bundle = Platform.getBundle((String)pluginName);
        if (bundle == null) {
            this.env.addProblem(ErrMsg.ANNO_PROVIDER_ERROR, position, annotationName, Strings.fmt((String)"annotation provider plugin \"%s\" not found (contributed by \"%s\").", (Object[])new Object[]{pluginName, contributorName}));
            return null;
        }
        int state = bundle.getState();
        boolean bl = stateOk = state == 4 || state == 8 || state == 32;
        if (!stateOk) {
            this.env.addProblem(ErrMsg.ANNO_PROVIDER_ERROR, position, annotationName, Strings.fmt((String)"annotation provider plugin \"%s\" is in a wrong state (state %d, contributed by \"%s\").", (Object[])new Object[]{pluginName, state, contributorName}));
            return null;
        }
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (bundleWiring == null) {
            this.env.addProblem(ErrMsg.ANNO_PROVIDER_ERROR, position, annotationName, Strings.fmt((String)"annotation provider plugin \"%s\" has no bundle wiring (contributed by \"%s\").", (Object[])new Object[]{pluginName, contributorName}));
            return null;
        }
        ClassLoader classLoader = bundleWiring.getClassLoader();
        if (classLoader == null) {
            this.env.addProblem(ErrMsg.ANNO_PROVIDER_ERROR, position, annotationName, Strings.fmt((String)"annotation provider plugin \"%s\" has no class loader (contributed by \"%s\").", (Object[])new Object[]{pluginName, contributorName}));
            return null;
        }
        try {
            cls = classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            this.env.addProblem(ErrMsg.ANNO_PROVIDER_ERROR, position, annotationName, Strings.fmt((String)"annotation provider plugin \"%s\" is missing annotation provider class \"%s\" (contributed by \"%s\").", (Object[])new Object[]{pluginName, className, contributorName}));
            return null;
        }
        AnnotationProvider provider = null;
        try {
            provider = (AnnotationProvider)cls.getDeclaredConstructor(String.class).newInstance(annotationName);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        if (provider != null) {
            return provider;
        }
        try {
            provider = (AnnotationProvider)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            this.env.addProblem(ErrMsg.ANNO_PROVIDER_ERROR, position, annotationName, Strings.fmt((String)"annotation provider plugin \"%s\" has an annotation provider class \"%s\" that could not be instantiated with or without annotation name parameter (contributed by \"%s\").", (Object[])new Object[]{pluginName, className, contributorName}));
        }
        return provider;
    }

    private String getExtensionContributorName(IConfigurationElement extension) {
        return extension.getContributor().getName();
    }

    private String getExtensionAnnotationName(IConfigurationElement extension) {
        return extension.getAttribute("annotationName");
    }

    private String getExtensionPluginName(IConfigurationElement extension) {
        return extension.getAttribute("plugin");
    }

    private String getExtensionClassName(IConfigurationElement extension) {
        return extension.getAttribute("class");
    }

    private class ProblemReporter
    implements AnnotationProblemReporter {
        private ProblemReporter() {
        }

        @Override
        public void reportProblem(String annotationName, String message, Position position, SemanticProblemSeverity severity) {
            ErrMsg msg = switch (severity) {
                case SemanticProblemSeverity.ERROR -> ErrMsg.ANNO_SPECIFIC_ERR;
                case SemanticProblemSeverity.WARNING -> ErrMsg.ANNO_SPECIFIC_WARN;
                default -> throw new AssertionError((Object)("Unknown severity: " + String.valueOf(severity)));
            };
            CifAnnotationsPostChecker.this.env.addProblem(msg, position, annotationName, message);
        }
    }
}

