/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.options;

import java.util.Locale;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.options.StringOption;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InvalidOptionException;

public class PlcMaxIterOption
extends StringOption {
    private static final String USE_BOUNDED_RESP_TEXT = "ctrl-props-anno";
    private static final String USE_INF_LOOPING_TEXT = "inf";
    private static final String DEFAULT_VALUE_TEXT = "ctrl-props-anno,ctrl-props-anno";
    private static final int DEFAULT_FALLBACK_CONTR_LIMIT = 0;
    private static final int DEFAULT_FALLBACK_UNCONTR_LIMIT = 0;
    private static final String VALUE_DESCRIPTION_TEXT = "The worst case maximum number of iterations to try each uncontrollable event once and the worst case maximum\nnumber of iterations to try each controllable event once, for a single execution of the main program body.\nA maximum number of iterations limit is a positive integer number, the word \"$resp\" or the word \"$inf\".\nAn integer number states the largest number of iterations that can occur to decide that all events have\nbeen performed.\nThe word \"$inf\" means \"infinite\", there is no upper bound on the maximum number of iterations.\nThe word \"$resp\" means that the maximum number of iterations is derived from the bounded response property\nin the controller properties annotation of the input specification. If the value of the bounded response\nproperty is not available or not valid, the maximum number \"$inf\" is used instead.\nThis option takes two maximum numbers, one for uncontrollable events and one for controllable\nevents respectively.\nFor example \"20,$resp\" means that in a single execution of the main program body,\neach uncontrollable event is tried at most 20 times, and each controllable event is tried as often as the\nvalid bounded response property in the specification indicates.\nNote that in any case, an iteration loop is considered to be finished as soon as none of the tried events\nin one iteration was possible.\nIf only one value is given to this option, it is used as maximum number of iterations for both\nuncontrollable and controllable events.".replace("$resp", "ctrl-props-anno").replace("$inf", "inf").replace("\n", " ");

    public PlcMaxIterOption() {
        super("PLC maximum iterations", VALUE_DESCRIPTION_TEXT + " [DEFAULT=\"ctrl-props-anno,ctrl-props-anno\"]", Character.valueOf('x'), "max-iter", "LIMITS", DEFAULT_VALUE_TEXT, false, true, VALUE_DESCRIPTION_TEXT, "Maximum iterations:");
    }

    public static MaxIterLimits getMaxIterLimits() {
        String conText;
        String unconText;
        String value = (String)Options.get(PlcMaxIterOption.class);
        int sepIndex = value.indexOf(44);
        if (sepIndex < 0) {
            unconText = value.strip();
            conText = value.strip();
        } else {
            unconText = value.substring(0, sepIndex).strip();
            conText = value.substring(sepIndex + 1).strip();
        }
        return new MaxIterLimits(PlcMaxIterOption.convertLimit("uncontrollable", unconText), PlcMaxIterOption.convertLimit("controllable", conText), 0, 0);
    }

    private static int convertLimit(String eventKind, String numberText) {
        int value;
        if (numberText.toLowerCase(Locale.US).equals(USE_INF_LOOPING_TEXT)) {
            return 0;
        }
        if (numberText.toLowerCase(Locale.US).equals(USE_BOUNDED_RESP_TEXT)) {
            return -1;
        }
        try {
            value = Integer.parseInt(numberText);
        }
        catch (NumberFormatException ex) {
            throw new InvalidOptionException(Strings.fmt((String)"PLC maximum iterations option value \"%s\" for %s events is not recognized as deriving it from the bounded response property (\"ctrl-props-anno\" without quotes), is not recognized as infinite (\"inf\" without quotes) and is not recognized as a positive integer number.", (Object[])new Object[]{numberText, eventKind}), (Throwable)ex);
        }
        if (value <= 0) {
            throw new InvalidOptionException(Strings.fmt((String)"PLC maximum iterations option value \"%d\" for %s events is not a positive number.", (Object[])new Object[]{value, eventKind}));
        }
        return value;
    }

    public static enum IterLimitKind {
        INTEGER,
        INFINITE,
        BOUNDED_RESPONSE;

    }

    public static class MaxIterLimits {
        private static final int INFINITE_VALUE = 0;
        private static final int BOUNDED_RESPONSE_VALUE = -1;
        private final int uncontrollableLimit;
        private final int controllableLimit;
        private final int fallbackUncontrollableLimit;
        private final int fallbackControllableLimit;

        public MaxIterLimits(int uncontrollableLimit, int controllableLimit, int fallbackUncontrollableLimit, int fallbackControllableLimit) {
            this.uncontrollableLimit = uncontrollableLimit;
            this.controllableLimit = controllableLimit;
            this.fallbackUncontrollableLimit = fallbackUncontrollableLimit;
            this.fallbackControllableLimit = fallbackControllableLimit;
            Assert.check((MaxIterLimits.convertToKind(fallbackUncontrollableLimit) != IterLimitKind.BOUNDED_RESPONSE ? 1 : 0) != 0);
            Assert.check((MaxIterLimits.convertToKind(fallbackControllableLimit) != IterLimitKind.BOUNDED_RESPONSE ? 1 : 0) != 0);
            Assert.check((MaxIterLimits.convertToKind(0) == IterLimitKind.INFINITE ? 1 : 0) != 0);
            Assert.check((MaxIterLimits.convertToKind(-1) == IterLimitKind.BOUNDED_RESPONSE ? 1 : 0) != 0);
        }

        public IterLimitKind getUncontrollableLimitKind(boolean fallback) {
            Assert.implies((boolean)fallback, (MaxIterLimits.convertToKind(this.uncontrollableLimit) == IterLimitKind.BOUNDED_RESPONSE ? 1 : 0) != 0);
            int v = fallback ? this.fallbackUncontrollableLimit : this.uncontrollableLimit;
            return MaxIterLimits.convertToKind(v);
        }

        public IterLimitKind getControllableLimitKind(boolean fallback) {
            Assert.implies((boolean)fallback, (MaxIterLimits.convertToKind(this.controllableLimit) == IterLimitKind.BOUNDED_RESPONSE ? 1 : 0) != 0);
            int v = fallback ? this.fallbackControllableLimit : this.controllableLimit;
            return MaxIterLimits.convertToKind(v);
        }

        public int getUncontrollableLimitNumber(boolean fallback) {
            Assert.implies((boolean)fallback, (MaxIterLimits.convertToKind(this.uncontrollableLimit) == IterLimitKind.BOUNDED_RESPONSE ? 1 : 0) != 0);
            int v = fallback ? this.fallbackUncontrollableLimit : this.uncontrollableLimit;
            Assert.areEqual((Object)((Object)MaxIterLimits.convertToKind(v)), (Object)((Object)IterLimitKind.INTEGER));
            return v;
        }

        public int getControllableLimitNumber(boolean fallback) {
            Assert.implies((boolean)fallback, (MaxIterLimits.convertToKind(this.controllableLimit) == IterLimitKind.BOUNDED_RESPONSE ? 1 : 0) != 0);
            int v = fallback ? this.fallbackControllableLimit : this.controllableLimit;
            Assert.areEqual((Object)((Object)MaxIterLimits.convertToKind(v)), (Object)((Object)IterLimitKind.INTEGER));
            return v;
        }

        private static IterLimitKind convertToKind(int value) {
            if (value > 0) {
                return IterLimitKind.INTEGER;
            }
            if (value < 0) {
                return IterLimitKind.BOUNDED_RESPONSE;
            }
            return IterLimitKind.INFINITE;
        }
    }
}

