/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.setext.texteditorbase.highlight;

import java.util.Iterator;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.setext.texteditorbase.ColorManager;
import org.eclipse.escet.setext.texteditorbase.highlight.ReadOnlyDocument;
import org.eclipse.escet.setext.texteditorbase.scanners.GenericPartitionScanner;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;

public abstract class CodeHighlighter
implements AutoCloseable {
    private static final boolean DEBUG = false;
    protected ColorManager colorManager = new ColorManager();
    private IPresentationReconciler presentationReconciler;
    private GenericPartitionScanner partitionScanner;

    protected abstract IPresentationReconciler obtainPresentationReconciler();

    protected abstract GenericPartitionScanner obtainPartitionScanner();

    protected CodeHighlighter() {
    }

    public String toHtml(String code) {
        ReadOnlyDocument doc = new ReadOnlyDocument(code);
        if (this.presentationReconciler == null) {
            this.presentationReconciler = this.obtainPresentationReconciler();
        }
        if (this.partitionScanner == null) {
            this.partitionScanner = this.obtainPartitionScanner();
        }
        this.partitionScanner.setRange(doc, 0, code.length());
        TextPresentation presentation = new TextPresentation();
        StringBuilder html = new StringBuilder();
        html.append("<html>");
        String curContentType = null;
        int curOffset = 0;
        int curLength = 0;
        while (true) {
            IToken token = this.partitionScanner.nextToken();
            int offset = this.partitionScanner.getTokenOffset();
            int length = this.partitionScanner.getTokenLength();
            if (token.isEOF()) break;
            Assert.check((!token.isUndefined() ? 1 : 0) != 0);
            Assert.check((!token.isWhitespace() ? 1 : 0) != 0);
            Assert.check((boolean)token.isOther());
            Object data = token.getData();
            String contentType = (String)data;
            if (contentType == null) {
                contentType = "__dftl_partition_content_type";
            }
            if (contentType.equals(curContentType)) {
                curLength += length;
                continue;
            }
            if (curContentType != null) {
                IPresentationRepairer repairer = this.presentationReconciler.getRepairer(curContentType);
                repairer.setDocument((IDocument)doc);
                TypedRegion region = new TypedRegion(curOffset, curLength, curContentType);
                repairer.createPresentation(presentation, (ITypedRegion)region);
            }
            curContentType = contentType;
            curOffset = offset;
            curLength = length;
        }
        if (curContentType != null) {
            IPresentationRepairer repairer = this.presentationReconciler.getRepairer(curContentType);
            repairer.setDocument((IDocument)doc);
            TypedRegion region = new TypedRegion(curOffset, curLength, curContentType);
            repairer.createPresentation(presentation, (ITypedRegion)region);
        }
        presentation = CodeHighlighter.mergeRanges(presentation);
        Iterator iter = presentation.getAllStyleRangeIterator();
        while (iter.hasNext()) {
            boolean styled;
            StyleRange range = (StyleRange)iter.next();
            boolean italic = (range.fontStyle & 2) > 0;
            boolean bold = (range.fontStyle & 1) > 0;
            Color color = range.foreground;
            boolean bl = styled = italic || bold || color != null;
            if (styled) {
                html.append("<span style=\"");
                if (italic) {
                    html.append("text-style:italic;");
                }
                if (bold) {
                    html.append("text-weight:bold;");
                }
                if (color != null) {
                    int red = color.getRed();
                    int green = color.getGreen();
                    int blue = color.getBlue();
                    String hex = Strings.fmt((String)"%02x%02x%02x", (Object[])new Object[]{red, green, blue});
                    html.append(Strings.fmt((String)"color:#%s;", (Object[])new Object[]{hex}));
                }
                html.append("\">");
            }
            int start = range.start;
            int end = range.start + range.length;
            String rangeCode = code.substring(start, end);
            rangeCode = StringEscapeUtils.escapeHtml4((String)rangeCode);
            rangeCode = rangeCode.replace(" ", "&nbsp;");
            rangeCode = rangeCode.replace("\t", "&nbsp;");
            rangeCode = rangeCode.replace("\r", "");
            rangeCode = rangeCode.replace("\n", "<br>");
            html.append(rangeCode);
            if (!styled) continue;
            html.append("</span>");
        }
        html.append("</html>");
        return html.toString();
    }

    private static TextPresentation mergeRanges(TextPresentation presentation) {
        TextPresentation result = new TextPresentation();
        Iterator iter = presentation.getAllStyleRangeIterator();
        StyleRange current = null;
        while (iter.hasNext()) {
            StyleRange range = (StyleRange)iter.next();
            if (current != null && range.similarTo(current)) {
                int afterPrevIdx = current.start + current.length;
                int startRangeIdx = range.start;
                Assert.check((afterPrevIdx == startRangeIdx ? 1 : 0) != 0);
                current.length += range.length;
                continue;
            }
            result.addStyleRange(range);
            current = range;
        }
        return result;
    }

    @Override
    public void close() {
        if (this.colorManager != null) {
            this.colorManager = null;
        }
    }
}

