/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnumcueclipse.debug.gdbjtag.pyocd;

import ilg.gnumcueclipse.core.StringUtils;
import ilg.gnumcueclipse.debug.gdbjtag.pyocd.Activator;
import ilg.gnumcueclipse.debug.gdbjtag.pyocd.Configuration;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class PyOCD {
    public static final long FORMAT_MAJOR_VERSION = 1L;
    public static final String VERSION_KEY = "version";
    public static final String VERSION_MAJOR_KEY = "major";
    public static final String VERSION_MINOR_KEY = "minor";
    public static final String STATUS_KEY = "status";
    public static final String ERROR_KEY = "error";
    public static final String BOARDS_KEY = "boards";
    public static final String TARGETS_KEY = "targets";
    public static final String BOARD_INFO_KEY = "info";
    public static final String BOARD_NAME_KEY = "board_name";
    public static final String BOARD_VENDOR_NAME_KEY = "vendor_name";
    public static final String BOARD_PRODUCT_NAME_KEY = "product_name";
    public static final String BOARD_TARGET_KEY = "target";
    public static final String BOARD_UNIQUE_ID_KEY = "unique_id";
    public static final String TARGET_NAME_KEY = "name";
    public static final String TARGET_PART_NUMBER_KEY = "part_number";
    public static final String TARGET_SVD_PATH_KEY = "svd_path";

    public static List<Board> getBoards(ILaunchConfiguration configuration) {
        String pyOCDPath = Configuration.getGdbServerCommand(configuration, null);
        if (pyOCDPath == null) {
            return null;
        }
        return PyOCD.getBoards(pyOCDPath);
    }

    public static List<Target> getTargets(ILaunchConfiguration configuration) {
        String pyOCDPath = Configuration.getGdbServerCommand(configuration, null);
        if (pyOCDPath == null) {
            return null;
        }
        return PyOCD.getTargets(pyOCDPath);
    }

    private static boolean checkOutput(JSONObject output) {
        if (output == null) {
            return false;
        }
        if (!output.containsKey((Object)VERSION_KEY)) {
            if (Activator.getInstance().isDebugging()) {
                System.out.printf("No data format version from pyOCD\n", new Object[0]);
            }
            return false;
        }
        JSONObject version = (JSONObject)output.get((Object)VERSION_KEY);
        if (!version.containsKey((Object)VERSION_MAJOR_KEY)) {
            if (Activator.getInstance().isDebugging()) {
                System.out.printf("No data format major version from pyOCD\n", new Object[0]);
            }
            return false;
        }
        if (!version.get((Object)VERSION_MAJOR_KEY).equals(1L)) {
            if (Activator.getInstance().isDebugging()) {
                System.out.printf("Unsupported version %d of data from pyOCD\n", version.get((Object)VERSION_MAJOR_KEY));
            }
            return false;
        }
        if (!output.containsKey((Object)STATUS_KEY) || !output.get((Object)STATUS_KEY).equals(0L)) {
            if (Activator.getInstance().isDebugging()) {
                String msg = "unknown error";
                if (output.containsKey((Object)ERROR_KEY)) {
                    msg = (String)output.get((Object)ERROR_KEY);
                }
                System.out.printf("Error %d reading from pyOCD: %s\n", output.get((Object)STATUS_KEY), msg);
            }
            return false;
        }
        return true;
    }

    public static List<Board> getBoards(String pyOCDPath) {
        JSONObject output = PyOCD.getJsonOutput(pyOCDPath, "--list");
        if (!PyOCD.checkOutput(output)) {
            return null;
        }
        if (!output.containsKey((Object)BOARDS_KEY)) {
            return null;
        }
        Object boardsObj = output.get((Object)BOARDS_KEY);
        if (!(boardsObj instanceof JSONArray)) {
            return null;
        }
        JSONArray boards = (JSONArray)boardsObj;
        ArrayList<Board> result = new ArrayList<Board>();
        for (Object b : boards) {
            try {
                JSONObject bobj = (JSONObject)b;
                Board boardInfo = new Board();
                boardInfo.fDescription = (String)bobj.get((Object)BOARD_INFO_KEY);
                boardInfo.fName = (String)bobj.get((Object)BOARD_NAME_KEY);
                boardInfo.fVendorName = (String)bobj.get((Object)BOARD_VENDOR_NAME_KEY);
                boardInfo.fProductName = (String)bobj.get((Object)BOARD_PRODUCT_NAME_KEY);
                boardInfo.fTargetName = (String)bobj.get((Object)BOARD_TARGET_KEY);
                boardInfo.fUniqueId = (String)bobj.get((Object)BOARD_UNIQUE_ID_KEY);
                result.add(boardInfo);
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public static List<Target> getTargets(String pyOCDPath) {
        JSONObject output = PyOCD.getJsonOutput(pyOCDPath, "--list-targets");
        if (!PyOCD.checkOutput(output)) {
            return null;
        }
        if (!output.containsKey((Object)TARGETS_KEY)) {
            return null;
        }
        Object targetsObj = output.get((Object)TARGETS_KEY);
        if (!(targetsObj instanceof JSONArray)) {
            return null;
        }
        JSONArray targets = (JSONArray)targetsObj;
        ArrayList<Target> result = new ArrayList<Target>();
        for (Object t : targets) {
            try {
                JSONObject tobj = (JSONObject)t;
                Target targetInfo = new Target();
                targetInfo.fName = (String)tobj.get((Object)TARGET_NAME_KEY);
                targetInfo.fPartNumber = (String)tobj.get((Object)TARGET_PART_NUMBER_KEY);
                targetInfo.fSvdPath = (String)tobj.get((Object)TARGET_SVD_PATH_KEY);
                result.add(targetInfo);
            }
            catch (Exception exception) {}
        }
        return result;
    }

    private static JSONObject getJsonOutput(String pyOCDPath, String listArg) {
        try {
            String result = PyOCD.getOutput(pyOCDPath, listArg);
            JSONParser parser = new JSONParser();
            Object obj = parser.parse(result);
            return (JSONObject)obj;
        }
        catch (ParseException e) {
            if (Activator.getInstance().isDebugging()) {
                System.out.printf("Parse exception: %s\n", new Object[]{e});
            }
            return null;
        }
        catch (CoreException e) {
            if (Activator.getInstance().isDebugging()) {
                System.out.printf("Core exception: %s\n", new Object[]{e});
            }
            return null;
        }
    }

    private static String getOutput(String pyOCDPath, String listArg) throws CoreException {
        Process process;
        String[] cmdArray = new String[]{pyOCDPath, "--json", listArg};
        try {
            process = ProcessFactory.getFactory().exec(cmdArray);
        }
        catch (IOException e) {
            throw new DebugException((IStatus)new Status(4, "ilg.gnumcueclipse.debug.gdbjtag.pyocd", 5012, "Error while launching command: " + StringUtils.join((String[])cmdArray, (String)" "), e.getCause()));
        }
        Job timeoutJob = new Job("pyOCD output timeout job"){
            {
                super($anonymous0);
                this.setSystem(true);
            }

            protected IStatus run(IProgressMonitor arg) {
                process.destroy();
                return Status.OK_STATUS;
            }
        };
        timeoutJob.schedule(10000L);
        InputStream stream = null;
        StringBuilder cmdOutput = new StringBuilder(200);
        try {
            try {
                String line;
                stream = process.getInputStream();
                InputStreamReader r = new InputStreamReader(stream);
                BufferedReader reader = new BufferedReader(r);
                while ((line = reader.readLine()) != null) {
                    cmdOutput.append(line);
                    cmdOutput.append('\n');
                }
            }
            catch (IOException e) {
                throw new DebugException((IStatus)new Status(4, "ilg.gnumcueclipse.debug.gdbjtag.pyocd", 5012, "Error reading pyOCD stdout after sending: " + StringUtils.join((String[])cmdArray, (String)" ") + ", response: " + cmdOutput, e.getCause()));
            }
        }
        catch (Throwable throwable) {
            timeoutJob.cancel();
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
            process.destroy();
            throw throwable;
        }
        timeoutJob.cancel();
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        process.destroy();
        return cmdOutput.toString();
    }

    public static class Board {
        public String fName;
        public String fVendorName;
        public String fProductName;
        public String fTargetName;
        public String fDescription;
        public String fUniqueId;
        public static final Comparator COMPARATOR = new Comparator();

        public String toString() {
            return String.format("<Board: %s [%s] %s>", this.fName, this.fTargetName, this.fUniqueId);
        }

        private static class Comparator
        implements java.util.Comparator<Board> {
            private Comparator() {
            }

            @Override
            public int compare(Board o1, Board o2) {
                return o1.fName.compareTo(o2.fName);
            }
        }
    }

    public static class Target {
        public String fName;
        public String fPartNumber;
        public String fSvdPath;
        public static final Comparator COMPARATOR = new Comparator();

        public String toString() {
            return String.format("<Target: %s [%s]>", this.fName, this.fPartNumber);
        }

        public static class Comparator
        implements java.util.Comparator<Target> {
            @Override
            public int compare(Target o1, Target o2) {
                return o1.fName.compareTo(o2.fName);
            }
        }
    }
}

