/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.core.preferences;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.embedcdt.core.Activator;
import org.eclipse.embedcdt.core.EclipseUtils;
import org.eclipse.embedcdt.core.XpackUtils;

public class DefaultPreferences {
    protected String fPluginId;
    protected IEclipsePreferences fPreferences;

    public DefaultPreferences(String pluginId) {
        this.fPluginId = pluginId;
        this.fPreferences = DefaultScope.INSTANCE.getNode(this.fPluginId);
    }

    public String getString(String key, String defaultValue) {
        String value = this.fPreferences.get(key, defaultValue);
        if (value != null) {
            value = value.trim();
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DefaultPreferences.getString(\"" + key + "\", \"" + defaultValue + "\") " + this.fPreferences.name() + " = \"" + value + "\"");
        }
        return value;
    }

    public String[] getStringArray(String key, String defaultValue) {
        String value = this.fPreferences.get(key, defaultValue);
        value = value != null ? value.trim() : "";
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DefaultPreferences.getStringArray(\"" + key + "\", \"" + defaultValue + "\") " + this.fPreferences.name() + " = \"" + value + "\"");
        }
        String[] values = value.split(";");
        int i = 0;
        while (i < values.length) {
            values[i] = values[i].trim();
            ++i;
        }
        return values;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        boolean value = this.fPreferences.getBoolean(key, defaultValue);
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DefaultPreferences.getString(\"" + key + "\", \"" + defaultValue + "\") " + this.fPreferences.name() + " = " + value);
        }
        return value;
    }

    public int getInt(String key, int defaultValue) {
        int value = this.fPreferences.getInt(key, defaultValue);
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DefaultPreferences.getBoolean(\"" + key + "\", " + defaultValue + ") = " + value);
        }
        return value;
    }

    public void putString(String key, String value) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DefaultPreferences.putString(\"" + key + "\", \"" + value + "\") " + this.fPreferences.name());
        }
        this.fPreferences.put(key, value);
    }

    public void putInt(String key, int value) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DefaultPreferences.putInt(\"" + key + "\", " + value + ")");
        }
        this.fPreferences.putInt(key, value);
    }

    public void putBoolean(String key, boolean value) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DefaultPreferences.putBoolean(\"" + key + "\", " + value + ")");
        }
        this.fPreferences.putBoolean(key, value);
    }

    public String addExeExtension(String executableName) {
        if (!executableName.endsWith(".exe")) {
            return String.valueOf(executableName) + ".exe";
        }
        return executableName;
    }

    public boolean checkFolderExecutable(String folder, String executableName) {
        IPath path;
        if ((folder = EclipseUtils.performStringSubstitution(folder)) == null || folder.isEmpty()) {
            return false;
        }
        if ((executableName = EclipseUtils.performStringSubstitution(executableName)) == null || executableName.isEmpty()) {
            return false;
        }
        if (EclipseUtils.isWindows()) {
            executableName = this.addExeExtension(executableName);
        }
        return (path = new Path(folder).append(executableName)).toFile().isFile();
    }

    public String searchLatestExecutable(String[] xpackNames, String searchPath, String subFolder, String executableName) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DefaultPreferences.searchLatestExecutable(" + String.join((CharSequence)";", xpackNames) + ", \"" + searchPath + "\", " + subFolder + "\", " + executableName + ") ");
        }
        String newSearchPath = searchPath;
        LinkedHashSet<String> uniqueNames = new LinkedHashSet<String>();
        int i = xpackNames.length - 1;
        while (i >= 0) {
            int ix;
            String name;
            if (!xpackNames[i].isEmpty() && !(name = (ix = xpackNames[i].indexOf(47)) == -1 ? xpackNames[i] : xpackNames[i].substring(ix + 1)).isEmpty()) {
                uniqueNames.add(name);
            }
            --i;
        }
        IPath repoPath = XpackUtils.getRepoPath();
        File repoFolder = repoPath.toFile();
        if (repoFolder.isDirectory()) {
            for (String uniqueName : uniqueNames) {
                IPath path = repoPath.append(uniqueName);
                File p2Folder = path.toFile();
                if (!p2Folder.isDirectory()) continue;
                newSearchPath = String.valueOf(path.toPortableString()) + EclipseUtils.getPathSeparator() + newSearchPath;
                if (!Activator.getInstance().isDebugging()) continue;
                System.out.println("DefaultPreferences.searchLatestExecutable() prepend \"" + path.toPortableString() + "\" to path ");
            }
        }
        int i2 = xpackNames.length - 1;
        while (i2 >= 0) {
            if (!xpackNames[i2].isEmpty()) {
                String xpackPath = XpackUtils.getSysPackPath(xpackNames[i2]).toPortableString();
                newSearchPath = String.valueOf(xpackPath) + EclipseUtils.getPathSeparator() + newSearchPath;
                if (Activator.getInstance().isDebugging()) {
                    System.out.println("DefaultPreferences.searchLatestExecutable() prepend \"" + xpackPath + "\" to path ");
                }
                xpackPath = XpackUtils.getPackPath(xpackNames[i2]).toPortableString();
                newSearchPath = String.valueOf(xpackPath) + EclipseUtils.getPathSeparator() + newSearchPath;
                if (Activator.getInstance().isDebugging()) {
                    System.out.println("DefaultPreferences.searchLatestExecutable() prepend \"" + xpackPath + "\" to path ");
                }
            }
            --i2;
        }
        String resolvedPath = EclipseUtils.performStringSubstitution(newSearchPath);
        if (resolvedPath == null || resolvedPath.isEmpty()) {
            return null;
        }
        String[] paths = resolvedPath.split(EclipseUtils.getPathSeparator());
        if (paths.length == 0) {
            return null;
        }
        if (EclipseUtils.isWindows()) {
            executableName = this.addExeExtension(executableName);
        }
        HashMap<Long, String> map = new HashMap<Long, String>();
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            this.searchExecutable(path, subFolder, executableName, map);
            ++n2;
        }
        if (map.isEmpty()) {
            return null;
        }
        Set keys = map.keySet();
        Long latestKey = new Long(0L);
        for (Long key : keys) {
            if (key <= latestKey) continue;
            latestKey = key;
        }
        return (String)map.get(latestKey);
    }

    private void searchExecutable(final String folder, final String subFolder, final String executableName, final Map<Long, String> map) {
        File local;
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DefaultPreferences.searchExecutable(\"" + folder + "\", \"" + subFolder + "\", \"" + executableName + "\") ");
        }
        if (!(local = new File(folder)).isDirectory()) {
            return;
        }
        local.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                IPath path;
                File file;
                IPath basePath;
                IPath versionPath = new Path(dir.getAbsolutePath()).append(name);
                if (subFolder != null) {
                    basePath = versionPath.append(".content").append(subFolder);
                    if (!basePath.toFile().isDirectory()) {
                        basePath = versionPath.append(subFolder);
                    }
                } else {
                    basePath = versionPath;
                }
                if ((file = (path = basePath.append(executableName)).toFile()).isFile()) {
                    File versioFolder = versionPath.toFile();
                    Long key = new Long(versioFolder.lastModified());
                    map.put(key, basePath.toPortableString());
                    if (Activator.getInstance().isDebugging()) {
                        System.out.println("DefaultPreferences.searchExecutable(\"" + folder + "\", \"" + subFolder + "\", \"" + executableName + "\") = add \"" + basePath.toPortableString() + "\" " + new Date(key));
                    }
                    return true;
                }
                return false;
            }
        });
    }
}

