/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverendpoint;

import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.common.util.StringUtil;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpoint;
import java.io.IOException;
import java.lang.annotation.Annotation;

public class WSAbstractServer {
    private static final System.Logger logger = System.getLogger(WSAbstractServer.class.getName());

    public String op(String op) {
        if (op.equals("configurator")) {
            return this.getConfigurator();
        }
        if (op.equals("encoders")) {
            return this.getEncoders();
        }
        if (op.equals("decoders")) {
            return this.getDecoders();
        }
        if (op.equals("subprotocols")) {
            return this.getSubprotocols();
        }
        if (op.equals("value")) {
            return this.getValue();
        }
        return null;
    }

    protected String getConfigurator() {
        Annotation ann = this.getClass().getAnnotations()[0];
        ServerEndpoint endpoint = (ServerEndpoint)ann;
        Class config = endpoint.configurator();
        return config.getName();
    }

    protected String getEncoders() {
        Annotation ann = this.getClass().getAnnotations()[0];
        ServerEndpoint endpoint = (ServerEndpoint)ann;
        Class[] encoders = endpoint.encoders();
        String encs = StringUtil.objectsToString((Object[])encoders);
        return encs;
    }

    protected String getDecoders() {
        Annotation ann = this.getClass().getAnnotations()[0];
        ServerEndpoint endpoint = (ServerEndpoint)ann;
        Class[] decoders = endpoint.decoders();
        String decs = StringUtil.objectsToString((Object[])decoders);
        return decs;
    }

    protected String getSubprotocols() {
        Annotation ann = this.getClass().getAnnotations()[0];
        ServerEndpoint endpoint = (ServerEndpoint)ann;
        String[] subprotocols = endpoint.subprotocols();
        String subs = StringUtil.objectsToString((Object[])subprotocols);
        return subs;
    }

    public String getValue() {
        Annotation ann = this.getClass().getAnnotations()[0];
        ServerEndpoint endpoint = (ServerEndpoint)ann;
        return endpoint.value();
    }

    public void onError(Session session, Throwable t) throws IOException {
        logger.log(System.Logger.Level.INFO, "@OnError in " + this.getClass().getName());
        t.printStackTrace();
        String message = "Exception: " + IOUtil.printStackTrace((Throwable)t);
        session.getBasicRemote().sendText(message);
    }
}

