/*
 * Copyright (c) 2015, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: OnOpenStringHolderServerEndpoint.java 74491 2015-05-18 14:51:46Z jsupol $
 */

package com.sun.ts.tests.websocket.negdep.invalidpathparamtype.srv.onopen;

import java.io.IOException;

import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;

import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.negdep.StringHolder;

@ServerEndpoint("/invalid/{arg}")
public class OnOpenStringHolderServerEndpoint {
	private String open;

	@OnMessage
	public String echo(String echo) {
		return open + echo;
	}

	@OnOpen
	public void onOpen(Session session, @PathParam("arg") StringHolder sb) {
		open = sb.toString();
	}

	@OnError
	public void onError(Session session, Throwable thr) throws IOException {
		thr.printStackTrace(); // Write to error log, too
		String message = IOUtil.printStackTrace(thr);
		session.getBasicRemote().sendText(message);
	}
}
