/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSCReturningClientEndpointWithTextStreamEncoder.java 72876 2013-09-17 12:05:52Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.throwingcoder.annotated;

import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;

import com.sun.ts.tests.websocket.common.client.AnnotatedClientEndpoint;
import com.sun.ts.tests.websocket.common.client.StringClientEndpoint;
import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.stringbean.StringBean;
import com.sun.ts.tests.websocket.ee.javax.websocket.throwingcoder.ThrowingTextStreamEncoder;

@ClientEndpoint(encoders = ThrowingTextStreamEncoder.class)
public class WSCReturningClientEndpointWithTextStreamEncoder extends
		AnnotatedClientEndpoint<String> {

	public WSCReturningClientEndpointWithTextStreamEncoder() {
		super(new StringClientEndpoint());
	}

	@OnMessage
	public StringBean onMessage(String msg, Session session) {
		return new StringBean(msg);
	}

	@OnOpen
	public void onOpen(Session session, EndpointConfig config) {
		super.onOpen(session, config); // throwing encoder is not used here!
	}

	@OnClose
	public void onClose(Session session, CloseReason closeReason) {
		super.onClose(session, closeReason);
	}

	@OnError
	public void onError(Session session, Throwable t) {
		String error = WebSocketCommonClient.getCauseMessage(t);
		super.onMessage(error);
		super.onMessage(error);
	}

}
