/*
 * Copyright (c) 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: ByteBufferMessageHandler.java 73928 2014-08-01 09:35:37Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.session11.server;

import java.io.IOException;
import java.nio.ByteBuffer;

import javax.websocket.MessageHandler;
import javax.websocket.Session;

import com.sun.ts.tests.websocket.common.util.IOUtil;

public class ByteBufferMessageHandler implements
		MessageHandler.Whole<ByteBuffer> {

	private Session session;
	public static final String HANDLER_SAYS = "ByteBufferMessageHandler says: ";

	public ByteBufferMessageHandler(Session session) {
		super();
		this.session = session;
	}

	@Override
	public void onMessage(ByteBuffer message) {
		String msg = null;
		try {
			msg = IOUtil.byteBufferToString(message);
			session.getBasicRemote().sendText(HANDLER_SAYS + msg);
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}
}
