/*
 * Copyright (c) 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: ByteArrayPartialMessageHandler.java 73928 2014-08-01 09:35:37Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.session11.server;

import java.io.IOException;

import javax.websocket.MessageHandler;
import javax.websocket.Session;

public class ByteArrayPartialMessageHandler implements
		MessageHandler.Partial<byte[]> {

	private Session session;
	public static final String HANDLER_SAYS = "ByteArrayPartialMessageHandler says: ";
	StringBuilder sb = new StringBuilder();

	public ByteArrayPartialMessageHandler(Session session) {
		super();
		this.session = session;
	}

	@Override
	public void onMessage(byte[] message, boolean finite) {
		sb.append(new String(message));
		try {
			if (finite)
				session.getBasicRemote().sendText(HANDLER_SAYS + sb.toString());
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}
}
