/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSCModifyHandshakeServer.java 72735 2013-08-28 16:38:40Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.server.serverendpointconfig.configurator;

import java.io.IOException;

import javax.websocket.EndpointConfig;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;

import com.sun.ts.tests.websocket.common.util.IOUtil;

@ServerEndpoint(value = "/modifyhandshake", configurator = ModifyHandshakeConfigurator.class)
public class WSCModifyHandshakeServer {

	ServerEndpointConfig config;

	@OnMessage
	public String onMessage(String msg) {
		boolean ret = false;
		if (msg.equals("origin"))
			ret = ModifyHandshakeConfigurator.isCheckedOriginBeforeModifyHandshake();
		else if (msg.equals("config"))
			ret = ModifyHandshakeConfigurator.getConfig().getClass().getName()
					.equals(config.getClass().getName());
		else if (msg.equals("request"))
			ret = ModifyHandshakeConfigurator.getRequest() != null;
		else if (msg.equals("response"))
			ret = ModifyHandshakeConfigurator.getResponse() != null;
		return String.valueOf(ret);
	}

	@OnOpen
	public void onOpen(Session session, EndpointConfig config) {
		this.config = (ServerEndpointConfig) config;
	}

	@OnError
	public void onError(Session session, Throwable thr) throws IOException {
		thr.printStackTrace(); // Write to error log, too
		String message = IOUtil.printStackTrace(thr);
		session.getBasicRemote().sendText(message);
	}

}
