/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: ExtensionsServerEndpointConfig.java 72737 2013-08-28 16:53:28Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.server.serverendpointconfig;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import javax.websocket.Decoder;
import javax.websocket.Encoder;
import javax.websocket.Extension;
import javax.websocket.server.ServerEndpointConfig;

public class ExtensionsServerEndpointConfig implements ServerEndpointConfig {

	static final String[] EXT_NAMES = new String[] { "empty", "secondEmpty" };

	@Override
	public Map<String, Object> getUserProperties() {
		return Collections.emptyMap();
	}

	@Override
	public Class<?> getEndpointClass() {
		return WSProgramaticExtensionsServer.class;
	}

	@Override
	public String getPath() {
		return "/programatic/extensions";
	}

	@Override
	public List<String> getSubprotocols() {
		return Collections.emptyList();
	}

	@Override
	public List<Extension> getExtensions() {
		Extension firstExt = new Extension() {
			@Override
			public String getName() {
				return EXT_NAMES[0];
			}

			@Override
			public List<Parameter> getParameters() {
				return Collections.emptyList();
			}
		};

		Extension secondExt = new Extension() {
			@Override
			public String getName() {
				return EXT_NAMES[1];
			}

			@Override
			public List<Parameter> getParameters() {
				return Collections.emptyList();
			}
		};
		return Arrays.asList(firstExt, secondExt);
	}

	@Override
	public Configurator getConfigurator() {
		return new ServerEndpointConfig.Configurator() {
		};
	}

	@Override
	public List<Class<? extends Encoder>> getEncoders() {
		return Collections.emptyList();
	}

	@Override
	public List<Class<? extends Decoder>> getDecoders() {
		return Collections.emptyList();
	}

}
