/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id$
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.remoteendpoint.usercoder;

import java.io.IOException;
import java.io.Writer;

import javax.websocket.Decoder;
import javax.websocket.EncodeException;
import javax.websocket.Encoder;

public abstract class CoderSuperClassTextStream<T> extends CoderSuperClass implements
		Encoder.TextStream<T>, Decoder.TextStream<T> {

	@Override
	public void encode(T object, Writer writer) throws EncodeException {
		try {
			writer.write(COMMON_CODED_STRING);
			writer.close();
		} catch (IOException e) {
			throw new EncodeException(object, COMMON_CODED_STRING, e);
		}
	}

}
