/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: BasicEndpointCallback.java 72854 2013-09-12 14:31:02Z supol $
 */
package com.sun.ts.tests.websocket.ee.javax.websocket.remoteendpoint.basic;

import javax.websocket.EndpointConfig;
import javax.websocket.RemoteEndpoint.Basic;
import javax.websocket.Session;

import com.sun.ts.lib.harness.EETest.Fault;
import com.sun.ts.tests.websocket.common.client.EndpointCallback;

public abstract class BasicEndpointCallback extends EndpointCallback {
	@Override
	public void onOpen(Session session, EndpointConfig config) {
		super.onOpen(session, config);
		Basic basicRemote = session.getBasicRemote();
		try {
			doBasic(basicRemote);
		} catch (Fault f) {
			throw new RuntimeException(f);
		}
	}

	abstract void doBasic(Basic basicRemote) throws Fault;
}
