/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: AsyncEndpointCallback.java 72629 2013-08-20 13:52:08Z supol $
 */
package com.sun.ts.tests.websocket.ee.javax.websocket.remoteendpoint.async;

import javax.websocket.EndpointConfig;
import javax.websocket.RemoteEndpoint.Async;
import javax.websocket.Session;

import com.sun.ts.lib.harness.EETest.Fault;
import com.sun.ts.tests.websocket.common.client.EndpointCallback;

public abstract class AsyncEndpointCallback extends EndpointCallback {
	@Override
	public void onOpen(Session session, EndpointConfig config) {
		super.onOpen(session, config);
		Async asyncRemote = session.getAsyncRemote();
		try {
			doAsync(asyncRemote);
		} catch (Fault f) {
			throw new RuntimeException(f);
		}
	}

	abstract void doAsync(Async async) throws Fault;
}
