/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSClient.java 72828 2013-09-09 10:59:42Z supol $
 */
package com.sun.ts.tests.websocket.ee.javax.websocket.containerprovider.metainf;

import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;

/*
 * @class.setup_props: webServerHost;
 *                     webServerPort;
 *                     ts_home;
 *                     ws_wait;
 */
public class WSClient extends WebSocketCommonClient {
	private static final long serialVersionUID = 8387217970724424176L;

	public WSClient() {
		setContextRoot("wsc_ee_containerprovider_metainf_web");
	}

	public static void main(String[] args) {
		new WSClient().run(args);
	}

	/* Run test */
	/*
	 * @testName: getWebSocketContainerOnServerTest
	 * @assertion_ids: WebSocket:JAVADOC:28; 
	 * 					WebSocket:JAVADOC:27;
	 * @test_Strategy: Check the TCKContainerProvider is used, as order by 
	 * 					META-INF/services/javax.websocket.ContainerProvider file
	 * 
	 * 					ContainerProvider.ContainerProvider()				  					
	 */
	public void getWebSocketContainerOnServerTest() throws Fault {
		invoke("srv", "anything", TCKWebSocketContainer.class.getName());
	}

}
