/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WillDecodeSecondTextDecoder.java 71472 2013-04-08 11:33:13Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.coder;

import javax.websocket.DecodeException;

import com.sun.ts.tests.websocket.common.stringbean.StringBean;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanTextDecoder;

public class WillDecodeSecondTextDecoder extends StringBeanTextDecoder {
	
	@Override
	public StringBean decode(String s) throws DecodeException {
		Logger.onCode(getClass());
		return super.decode(s);
	};

	@Override
	public boolean willDecode(String s) {
		Logger.onWillCode(getClass());
		return true;
	}	
}
