/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSWillDecodeBinaryDecoderServer.java 71472 2013-04-08 11:33:13Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.coder;

import java.io.IOException;

import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;

import com.sun.ts.tests.websocket.common.stringbean.StringBean;
import com.sun.ts.tests.websocket.common.util.IOUtil;

@ServerEndpoint(value = "/binarywilldecode", decoders = {
		WillDecodeFirstBinaryDecoder.class, WillDecodeSecondBinaryDecoder.class })
public class WSWillDecodeBinaryDecoderServer {

	@OnMessage
	public String echo(StringBean bean) {
		return bean.get();
	}

	@OnError
	public void onError(Session session, Throwable t) throws IOException {
		System.out.println("@OnError in" + getClass().getName());
		t.printStackTrace(); // Write to error log, too
		String message = IOUtil.printStackTrace(t);
		session.getBasicRemote().sendText(message);
	}

}
