/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.securityapi.ham.rememberme.test1;

import java.io.IOException;
import java.io.PrintWriter;

import javax.annotation.security.DeclareRoles;
import javax.servlet.ServletException;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


@WebServlet("/servlet")
@DeclareRoles({ "Administrator", "Manager", "Employee" })
@ServletSecurity(@HttpConstraint(rolesAllowed = "Administrator"))
public class Servlet extends HttpServlet {

    private static final long serialVersionUID = 1L;

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
 
        if (request.getParameter("logout") != null) {
            request.logout();
            request.getSession().invalidate();
        }
        
        PrintWriter out = response.getWriter();

        if (request.getUserPrincipal() != null) {
            out.println("The user principal is: " + request.getUserPrincipal().getName() + "<BR>");
        }

        // Surround these with !'s so they are easier to search for.
        // (i.e. we can search for !true! or !false!)
        out.println("isUserInRole(\"Administrator\"): !" + request.isUserInRole("Administrator") + "!<BR>");
        out.println("isUserInRole(\"Manager\"): !" + request.isUserInRole("Manager") + "!<BR>");
        out.println("isUserInRole(\"Employee\"): !" + request.isUserInRole("Employee") + "!<BR>");
        
        String HAMValidateRequestCalled = (String) request.getAttribute("ham-validateRequest-called");
        boolean called = false;
        if (HAMValidateRequestCalled != null && HAMValidateRequestCalled.equalsIgnoreCase("true")) {
            called = true;
        }

        out.println("HAM authentication mechanism called: " + called);
    }
}
