/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;

public class BackupUtil {
    public static int backupFile(File file, int maxBackups) {
        boolean renamed;
        if (!file.exists()) {
            return -1;
        }
        if (file.isDirectory()) {
            return -1;
        }
        String filename = file.getPath();
        File dir = file.getParentFile();
        Object[] list = dir.list();
        if (list == null) {
            return -1;
        }
        String prefix = file.getName() + "~";
        String suffix = "~";
        boolean maxBackupIndex = false;
        Vector<Integer> backups = new Vector<Integer>();
        Arrays.sort(list);
        for (int i = list.length - 1; i >= 0; --i) {
            String mid;
            Object s = list[i];
            if (((String)s).length() <= prefix.length() + suffix.length() || !((String)s).startsWith(prefix) || !((String)s).endsWith(suffix) || !BackupUtil.checkForInteger(mid = ((String)s).substring(prefix.length(), ((String)s).length() - suffix.length()))) continue;
            int index = Integer.parseInt(mid);
            File backuppedFile = new File(filename + "~" + index + "~");
            renamed = backuppedFile.renameTo(new File(filename + "~" + ++index + "~"));
            if (!renamed) {
                return -1;
            }
            backups.addElement(new Integer(index));
        }
        renamed = file.renameTo(new File(filename + "~" + 1 + "~"));
        if (!renamed) {
            return -1;
        }
        backups.addElement(new Integer(1));
        int maxIndex = 0;
        for (int j = 0; j < backups.size(); ++j) {
            int index = (Integer)backups.get(j);
            int n = maxIndex = index > maxIndex ? index : maxIndex;
            if (index <= maxBackups) continue;
            File oldBackup = new File(filename + "~" + backups.get(j) + "~");
            oldBackup.delete();
        }
        return maxIndex > maxBackups ? maxBackups : maxIndex;
    }

    public static void backupDir(File file, int maxBackups) {
        boolean renamed;
        if (!file.isDirectory()) {
            return;
        }
        if (file.list().length == 0) {
            return;
        }
        String filename = file.getPath();
        File dir = file.getParentFile();
        Object[] list = dir.list();
        String prefix = file.getName() + "~";
        String suffix = "~";
        boolean maxBackupIndex = false;
        Vector<Integer> backups = new Vector<Integer>();
        Arrays.sort(list);
        for (int i = list.length - 1; i >= 0; --i) {
            String mid;
            Object s = list[i];
            if (((String)s).length() <= prefix.length() + suffix.length() || !((String)s).startsWith(prefix) || !((String)s).endsWith(suffix) || !BackupUtil.checkForInteger(mid = ((String)s).substring(prefix.length(), ((String)s).length() - suffix.length()))) continue;
            int index = Integer.parseInt(mid);
            File backuppedFile = new File(filename + "~" + index + "~");
            renamed = backuppedFile.renameTo(new File(filename + "~" + ++index + "~"));
            if (!renamed) {
                return;
            }
            backups.addElement(new Integer(index));
        }
        renamed = file.renameTo(new File(filename + "~" + 1 + "~"));
        if (!renamed) {
            return;
        }
        for (int j = 0; j < backups.size(); ++j) {
            int index = (Integer)backups.get(j);
            if (index <= maxBackups) continue;
            File oldBackup = new File(filename + "~" + backups.get(j) + "~");
            BackupUtil.deleteDir(oldBackup);
        }
    }

    public static void backupAllSubdirs(File dir, int maxBackups) {
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files.length == 0) {
            return;
        }
        HashSet<Integer> layers = new HashSet<Integer>();
        String suffix = "~";
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory()) continue;
            String fileName = files[i].getName();
            if (!fileName.endsWith(suffix)) {
                layers.add(new Integer(0));
                continue;
            }
            String prefix = fileName.substring(0, fileName.lastIndexOf(suffix));
            String numb = prefix.substring(prefix.lastIndexOf(suffix) + 1, prefix.length());
            if (!BackupUtil.checkForInteger(numb)) continue;
            layers.add(new Integer(Integer.parseInt(numb)));
        }
        Object[] larray = ((AbstractCollection)layers).toArray();
        Arrays.sort(larray);
        for (int i = larray.length - 1; i >= 0; --i) {
            BackupUtil.backupLayer(dir, (Integer)larray[i], maxBackups);
        }
    }

    private static void backupLayer(File parentDir, Integer numb, int maxBackups) {
        int number = numb;
        String suffix = number == 0 ? "" : "~" + number + "~";
        String newSuffix = "~" + (number + 1) + "~";
        LayerFilter filter = new LayerFilter(suffix);
        File[] layer = parentDir.listFiles(filter);
        if (number >= maxBackups) {
            for (int i = 0; i < layer.length; ++i) {
                BackupUtil.deleteDir(layer[i]);
            }
        } else {
            for (int i = 0; i < layer.length; ++i) {
                try {
                    String newName = number != 0 ? layer[i].getCanonicalPath().replaceAll(suffix, newSuffix) : layer[i].getCanonicalPath() + newSuffix;
                    layer[i].renameTo(new File(newName));
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
    }

    public static void backupContents(File dir, int maxBackups) {
        if (!dir.isDirectory()) {
            return;
        }
        String[] list = dir.list();
        for (int i = 0; i < list.length; ++i) {
            File f = new File(dir, list[i]);
            if (f.isDirectory() || f.getPath().endsWith("~")) continue;
            BackupUtil.backupFile(f, maxBackups);
        }
    }

    public static boolean checkForInteger(String s) {
        if (s.length() == 0) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean deleteDir(File dir) {
        boolean deleted = dir.delete();
        if (!deleted) {
            String[] list = dir.list();
            if (list != null) {
                for (int i = 0; i < list.length; ++i) {
                    BackupUtil.deleteDir(new File(dir, list[i]));
                }
            }
            deleted = dir.delete();
        }
        return deleted;
    }

    private static class LayerFilter
    implements FileFilter {
        private String suffix;

        public LayerFilter(String suffix) {
            this.suffix = suffix;
        }

        public boolean accept(File file) {
            if (!file.isDirectory()) {
                return false;
            }
            if (this.suffix.equals("")) {
                return !file.getName().endsWith("~");
            }
            return file.getName().endsWith(this.suffix);
        }
    }
}

