/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: MyJsonLocation.java 70573 2013-03-12 15:01:21Z adf $
 */

package com.sun.ts.tests.jsonp.common;

import com.sun.ts.lib.util.*;
import com.sun.ts.lib.porting.*;

import javax.json.stream.JsonLocation;

public class MyJsonLocation implements JsonLocation {

  private long lineNumber = -1;
  private long columnNumber = -1;
  private long streamOffset = -1;

  public MyJsonLocation() {}

  public MyJsonLocation(long lineNumber, long columnNumber, long streamOffset) {
      this.lineNumber = lineNumber;
      this.columnNumber = columnNumber;
      this.streamOffset = streamOffset;
  }

  public void setLineNumber(long lineNumber) {
      this.lineNumber = lineNumber;
  }

  public long getLineNumber() {
      return lineNumber;
  }

  public void setColumnNumber(long columnNumber) {
      this.columnNumber = columnNumber;
  }

  public long getColumnNumber() {
      return columnNumber;
  }

  public void setStreamOffset(long streamOffset) {
      this.streamOffset = streamOffset;
  }

  public long getStreamOffset() {
      return streamOffset;
  }
}
