/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: MyBufferedInputStream.java 69257 2012-12-20 15:38:14Z adf $
 */

package com.sun.ts.tests.jsonp.common;

import com.sun.ts.lib.util.*;
import com.sun.ts.lib.porting.*;

import java.io.*;

// A wrapper class to BufferedInputStream class used to inject IOException errors
// when the throwIOException instance variable is set. All methods delegate
// to the parent super class and check whether or not to throw an IOException
// before delegation.

public class MyBufferedInputStream extends BufferedInputStream {

  private boolean throwIOException = false;

  public MyBufferedInputStream(InputStream in) {
	super(in);
  }

  public MyBufferedInputStream(InputStream in, int sz) {
	super(in, sz);
  }

  public MyBufferedInputStream(InputStream in, boolean throwIOException) {
	super(in);
	this.throwIOException = throwIOException;
  }

  private void checkToTripIOException() throws IOException {
	if (throwIOException) {
	    TestUtil.logMsg("MyBufferedInputStream->checkToTripIOException: *** tripping an IOException ***");
	    throw new IOException("tripping an IOException");
	}
  }

  public void setThrowIOException(boolean throwIOException) {
	this.throwIOException = throwIOException;
  }

  public int read() throws IOException {
	checkToTripIOException();
	int c = super.read();
	return c;
  }

  public int read(byte[] b, int off, int len) throws IOException {
	checkToTripIOException();
	int c = super.read(b, off, len);
	return c;
  }

  public void close() throws IOException {
	checkToTripIOException();
	super.close();
  }
}
