/*
 * Copyright (c) 2016, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jsonp.api.mergetests;

import com.sun.ts.tests.jsonp.api.common.JsonPTest;
import com.sun.ts.tests.jsonp.api.common.TestResult;

// $Id: MergeTests.java 74775 2017-01-11 10:46:06Z tkraus $
/**
 * RFC 7396: JavaScript Object Notation (JSON) Merge Patch compatibility tests.<br>
 * {@see <a href="https://tools.ietf.org/html/rfc7396">RFC 7396</a>}.
 */
public class MergeTests extends JsonPTest {
    
    /**
     * Test JSON-P API response on 
     * {@see <a href="https://tools.ietf.org/html/rfc7396#section-1">RFC 7396: 1. Introduction</a>}:
     * If the provided merge patch contains members that do not appear within the target, those members are added.
     * @throws Fault when this test failed.
     *
     * @testName:      jsonMergeAddValueTest
     * @assertion_ids: JSONP:JAVADOC:575; JSONP:JAVADOC:576; JSONP:JAVADOC:616; JSONP:JAVADOC:617; JSONP:JAVADOC:620;
     *                 JSONP:JAVADOC:654; JSONP:JAVADOC:655;
     * @test_Strategy: Test API response on various JSON values.
     */
    public void jsonMergeAddValueTest() throws Fault {
        MergeAddValue addTest = new MergeAddValue();
        final TestResult result = addTest.test();
        result.eval();
    }

    /**
     * Test JSON-P API response on 
     * {@see <a href="https://tools.ietf.org/html/rfc7396#section-1">RFC 7396: 1. Introduction</a>}:
     * If the target does contain the member, the value is replaced.
     * @throws Fault when this test failed.
     *
     * @testName:      jsonMergeReplaceValueTest
     * @assertion_ids: JSONP:JAVADOC:575; JSONP:JAVADOC:576; JSONP:JAVADOC:616; JSONP:JAVADOC:617; JSONP:JAVADOC:654;
     *                 JSONP:JAVADOC:655;
     * @test_Strategy: Test API response on various JSON values.
     */
    public void jsonMergeReplaceValueTest() throws Fault {
        MergeReplaceValue replaceTest = new MergeReplaceValue();
        final TestResult result = replaceTest.test();
        result.eval();
    }

    /**
     * Test JSON-P API response on 
     * {@see <a href="https://tools.ietf.org/html/rfc7396#section-1">RFC 7396: 1. Introduction</a>}:
     * {@code null} values in the merge patch are given special meaning to indicate the removal
     * of existing values in the target.
     * @throws Fault when this test failed.
     *
     * @testName:      jsonMergeRemoveValueTest
     * @assertion_ids: JSONP:JAVADOC:575; JSONP:JAVADOC:576; JSONP:JAVADOC:616; JSONP:JAVADOC:617; JSONP:JAVADOC:654;
     *                 JSONP:JAVADOC:655;
     * @test_Strategy: Test API response on various JSON values.
     */
    public void jsonMergeRemoveValueTest() throws Fault {
        MergeRemoveValue removeTest = new MergeRemoveValue();
        final TestResult result = removeTest.test();
        result.eval();
    }

    /**
     * Test JSON-P API response on 
     * {@see <a href="https://tools.ietf.org/html/rfc7396#section-1">RFC 7396: 1. Introduction</a>}:
     * If the patch is anything other than an object, the result will always be to replace the entire
     * target with the entire patch.
     * @throws Fault when this test failed.
     *
     * @testName:      jsonMergeNonObjectTest
     * @assertion_ids: JSONP:JAVADOC:575; JSONP:JAVADOC:576; JSONP:JAVADOC:616; JSONP:JAVADOC:617; JSONP:JAVADOC:654;
     *                 JSONP:JAVADOC:655; JSONP:JAVADOC:583; JSONP:JAVADOC:584; 
     * @test_Strategy: Test API response on various JSON values.
     */
    public void jsonMergeNonObjectTest() throws Fault {
        MergeNonObject nonObjTest = new MergeNonObject();
        final TestResult result = nonObjTest.test();
        result.eval();
    }

    /**
     * Test JSON-P API response on 
     * Test based on
     * {@see <a href="https://tools.ietf.org/html/rfc7396#section-3">RFC 7396: 3. Example</a>}
     * objects.
     * @throws Fault when this test failed.
     *
     * @testName:      jsonMergeRFCSampleTest
     * @assertion_ids: JSONP:JAVADOC:575; JSONP:JAVADOC:576; JSONP:JAVADOC:616; JSONP:JAVADOC:617; JSONP:JAVADOC:654;
     *                 JSONP:JAVADOC:655;
     * @test_Strategy: Test API response on RFC example objects.
     */
    public void jsonMergeRFCSampleTest() throws Fault {
        MergeRFCSample rfcSampleTest = new MergeRFCSample();
        final TestResult result = rfcSampleTest.test();
        result.eval();
    }

}
