<%--
  Copyright 2009, Oracle and its affiliates. All rights reserved.
  ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 
  @(#)encodetestColumnHeaderFooter.jsp	1.2 10/03/05
--%>

<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f" %>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h" %>

<%@ include file="include.jsp" %>

<html>
<head>
    <title>encodetest</title>
    <style type="text/css">
        th.sansserif {
            font-family: sans-serif
        }

        td.sansserif {
            font-family: sans-serif
        }
        
        .columnClass {
            font-family: sans-serif
        }
    </style>
</head>

<body>
<f:view>

    <%--
        Table with column level headers and footers
    --%>
    <h:dataTable id="data1" value="#{requestScope.DataList}" var="data1">
        <h:column>
            <f:facet name="header">
                <h:outputText value="Name Header"/>
            </f:facet>
            <h:outputText value="#{data1.name}"/>
        </h:column>
        <h:column>
            <f:facet name="footer">
                <h:outputText value="Gender Footer"/>
            </f:facet>
            <h:outputText value="#{data1.gender}"/>
        </h:column>
        <h:column>
            <f:facet name="header">
                <h:outputText value="Age Header"/>
            </f:facet>
            <f:facet name="footer">
                <h:outputText value="Age Footer"/>
            </f:facet>
            <h:outputText value="#{data1.age}"/>
        </h:column>
    </h:dataTable>
    
     <%--
        Table with column level headers and footers
        with headerClass and footerClass attributes defined
    --%>
    <h:dataTable id="data2" 
                 value="#{requestScope.DataList}" 
                 var="data2"
                 headerClass="sansserif"
                 footerClass="sansserif">
        <h:column>
            <f:facet name="header">
                <h:outputText value="Name Header"/>
            </f:facet>
            <h:outputText value="#{data2.name}"/>
        </h:column>
        <h:column>
            <f:facet name="footer">
                <h:outputText value="Gender Footer"/>
            </f:facet>
            <h:outputText value="#{data2.gender}"/>
        </h:column>
        <h:column>
            <f:facet name="header">
                <h:outputText value="Age Header"/>
            </f:facet>
            <f:facet name="footer">
                <h:outputText value="Age Footer"/>
            </f:facet>
            <h:outputText value="#{data2.age}"/>
        </h:column>
    </h:dataTable>
    
    
     <%--
      validate rendering when footerClass and headerClass are
      specified on both the data table and the column
    --%>
    <h:dataTable id="data3" 
                 value="#{requestScope.DataList}" 
                 var="data3"
                 headerClass="sansserif"
                 footerClass="sansserif">
        <h:column headerClass="columnClass">
            <f:facet name="header">
                <h:outputText value="Name Header"/>
            </f:facet>
            <h:outputText value="#{data3.name}"/>
        </h:column>
        <h:column>
            <f:facet name="footer">
                <h:outputText value="Gender Footer"/>
            </f:facet>
            <h:outputText value="#{data3.gender}"/>
        </h:column>
        <h:column footerClass="columnClass">
            <f:facet name="header">
                <h:outputText value="Age Header"/>
            </f:facet>
            <f:facet name="footer">
                <h:outputText value="Age Footer"/>
            </f:facet>
            <h:outputText value="#{data3.age}"/>
        </h:column>
    </h:dataTable>
    
</f:view>
</body>
</html>
