<%--
  Copyright 2009, Oracle and its affiliates. All rights reserved.
  ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 
  @(#)encodetestBasic.jsp	1.2 10/03/05
--%>

<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f" %>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h" %>

<%@ include file="include.jsp"%>

<html>
<head>
    <title>encodetestBasic</title> 
    <style type="text/css">
        .odd {
            color: cadetblue;
        }
        .even {
            color: darkgray;
        }
    </style>
</head>

<body>
<f:view>
    <%-- 
        Most basic table - no facets
    --%>
    <h:dataTable id="data1" value="#{requestScope.DataList}" var="data1">
        <h:column>
            <h:outputText value="#{data1.name}"/>
        </h:column>
        <h:column>
            <h:outputText value="#{data1.gender}"/>
        </h:column>
        <h:column>
            <h:outputText value="#{data1.age}"/>
        </h:column>
    </h:dataTable>    
    
    <%--
        Same as above, but mix in rowClasses
    --%>
    <h:dataTable id="data2" 
                 value="#{requestScope.DataList}" 
                 var="data2"
                 rowClasses="odd,even"
                 columnClasses="even,odd">
        <h:column>
            <h:outputText value="#{data2.name}"/>
        </h:column>
        <h:column>
            <h:outputText value="#{data2.gender}"/>
        </h:column>
        <h:column>
            <h:outputText value="#{data2.age}"/>
        </h:column>
    </h:dataTable>
    
    <%-- Test binding attribute --%>
    <h:dataTable id="data3" binding="#{library.books}"/>

</f:view>
</body>
</html>
