/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

/*
 * $Id: DataTableUIBean.java 62525 2011-04-15 12:14:31Z dougd $
 */
package com.sun.ts.tests.jsf.spec.render.datatable;

import javax.faces.application.Application;
import javax.faces.component.html.HtmlDataTable;
import javax.faces.component.html.HtmlColumn;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.context.FacesContext;

public class DataTableUIBean {

    private HtmlDataTable books;

    public HtmlDataTable getBooks() {
        return books;
    }

    public void setBooks(HtmlDataTable hdt) {
        this.books = hdt;

        books.setId("books");
        books.setTitle("Books");
        books.setBgcolor("FFFF99");
        books.setBorder(2);

        books.getChildren().add(bookTableColumn("Authors"));
        books.getChildren().add(bookTableColumn("Titles"));
        books.getChildren().add(bookTableColumn("Dates"));

    }

    private HtmlColumn bookTableColumn(String colheader) {
        Application application =
                FacesContext.getCurrentInstance().getApplication();
        HtmlColumn column = (HtmlColumn) application.createComponent(
                HtmlColumn.COMPONENT_TYPE);
        HtmlOutputText header = (HtmlOutputText) application.createComponent(
                HtmlOutputText.COMPONENT_TYPE);

        column.setId(colheader);
        header.setValue(colheader);
        column.setHeader(header);

        return column;
    }
}
