/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: SelectUIComponentBean.java 62525 2011-04-15 12:14:31Z dougd $
 */

package com.sun.ts.tests.jsf.spec.render.common;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.application.Application;
import javax.faces.component.UISelectItem;

public class SelectUIComponentBean {

    private UIComponent yesNo;

    public UIComponent getYesNo() {
        return yesNo;
    }

    public void setYesNo(UIComponent answer) {
        Application application =
                FacesContext.getCurrentInstance().getApplication();

        UISelectItem yes = (UISelectItem) application.createComponent(
                UISelectItem.COMPONENT_TYPE);
        UISelectItem no = (UISelectItem) application.createComponent(
                UISelectItem.COMPONENT_TYPE);

        answer.setId("ManySelectItems");

        // Setup the checkboxes.
        yes.setId("y");
        yes.setItemLabel("yes");
        yes.setItemValue("yes");

        no.setId("n");
        no.setItemLabel("no");
        no.setItemValue("no");

        // Added the selectItems to the Many UIComponent.
        answer.getChildren().add(no);
        answer.getChildren().add(yes);

        this.yesNo = answer;
    }
}
