/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: MaintainCustomerBean.java 70341 2013-02-28 16:38:09Z dougd $
 */
package com.sun.ts.tests.jsf.spec.flows.intermediate.beans;

import java.io.Serializable;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.flow.FlowHandler;

public class MaintainCustomerBean implements Serializable
{
   public MaintainCustomerBean() {
      super();
   }
   
   public String createCustomer() {
       //  Logic to create a new customer object.
       FacesContext context = FacesContext.getCurrentInstance();
       CustomerBean customer = new CustomerBean();
       FlowHandler flowHandler = context.getApplication().getFlowHandler();
       Map<Object, Object> flowScope = flowHandler.getCurrentFlowScope();
       if (null == flowScope) {
           throw new IllegalStateException("Must have a flow handler");
       }
       flowScope.put("customerId", customer.getCustomerId());
       flowScope.put("customerIdValue", customer);
       return "router1";
   }
   
   public String fetchCustomer() {
      //  Logic to fetch a customer.
      return "success";
   }
   
   public void upgradeCustomer() {
       FacesContext context = FacesContext.getCurrentInstance();
       FlowHandler flowHandler = context.getApplication().getFlowHandler();
       Map<Object, Object> flowScope = flowHandler.getCurrentFlowScope();
       if (null == flowScope) {
           throw new IllegalStateException("Must have a flow handler");
       }
       CustomerBean customer = (CustomerBean) flowScope.get("customerIdValue");
       customer.setUpgraded(true);

   }
   
   public void initializeFlow() {
       FacesContext context = FacesContext.getCurrentInstance();
       Map<String,Object> requestMap = context.getExternalContext().getRequestMap();
       requestMap.put("initializerMessage", "Initializer called");

   }
   
   public void cleanUpFlow() {
       Map<String,Object> requestMap = FacesContext.getCurrentInstance().getExternalContext().getRequestMap();
       requestMap.put("finalizerMessage", "Finalizer called");
   }
}
