/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: URLClient.java 68235 2012-10-24 12:45:35Z dougd $
 */

package com.sun.ts.tests.jsf.api.javax_faces.context.externalcontextfactory;

import com.sun.javatest.Status;
import com.sun.ts.tests.jsf.common.client.AbstractUrlClient;

import java.io.PrintWriter;

public final class URLClient extends AbstractUrlClient {

    private static final String CONTEXT_ROOT = "/jsf_ctx_externalctxfactory_web";

    public static void main(String[] args) {
	URLClient theTests = new URLClient();
	Status s = theTests.run(args, new PrintWriter(System.out),
		new PrintWriter(System.err));
	s.exit();
    }

    public Status run(String args[], PrintWriter out, PrintWriter err) {
	setContextRoot(CONTEXT_ROOT);
	setServletName(DEFAULT_SERVLET_NAME);
	return super.run(args, out, err);
    }

    /*
     * @class.setup_props: webServerHost; webServerPort; ts_home;
     */

    /* Test Declarations */

    /**
     * @testName: externalContextFactoryGetExternalContextTest
     * 
     * @assertion_ids: JSF:JAVADOC:1186; JSF:JAVADOC:1187
     * 
     * @test_Strategy: Ensure a ExternalContext instance can be obtained from
     *                 the ExternalContextFactory when providing the correct
     *                 objects.
     */
    public void externalContextFactoryGetExternalContextTest() throws Fault {
	TEST_PROPS.setProperty(APITEST,
		"externalContextFactoryGetExternalContextTest");
	invoke();
    }

    /**
     * @testName: externalCtxFactoryGetExternalContextNPETest
     * 
     * @assertion_ids: JSF:JAVADOC:1186; JSF:JAVADOC:1189
     * 
     * @test_Strategy: Ensure NullPointerExceptions are thrown if any of the
     *                 arguments to ExternalContextFactory are null.
     */
    public void externalCtxFactoryGetExternalContextNPETest() throws Fault {
	TEST_PROPS.setProperty(APITEST,
		"externalCtxFactoryGetExternalContextNPETest");
	invoke();
    }

    /**
     * @testName: externalContextFactoryGetWrappedTest
     * 
     * @assertion_ids: JSF:JAVADOC:1186; JSF:JAVADOC:1190
     * 
     * @test_Strategy: Ensure that A default implementation is provided that
     *                 returns null.
     */
    public void externalContextFactoryGetWrappedTest() throws Fault {
	TEST_PROPS.setProperty(APITEST, "externalContextFactoryGetWrappedTest");
	invoke();
    }

} // end of URLClient
