/*
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TestServlet.java 65758 2012-04-12 15:33:14Z dougd $
 */

package com.sun.ts.tests.jsf.api.javax_faces.component.uinamingcontainer;

import java.io.IOException;
import java.io.PrintWriter;

import javax.faces.component.UIComponentBase;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.sun.ts.tests.jsf.api.javax_faces.component.common.BaseComponentTestServlet;
import com.sun.ts.tests.jsf.common.util.JSFTestUtil;


public class TestServlet extends BaseComponentTestServlet {

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);                
        setRendererType(null);
    }


    /**
     * <p>Creates a new {@link javax.faces.component.UIComponent} instance.</p>
     * 
     * @return a new {@link javax.faces.component.UIComponent} instance.
     */
    @Override
    protected UIComponentBase createComponent() {
        return new UINamingContainer();
    }
    
// ------------------------------------------- Test Methods ----
    
    // ------------------------------------------------------------- UINamingContainer Specific
    
    public void uiNamingContainerGetSeparatorCharTest(HttpServletRequest request,
            HttpServletResponse response)
            throws ServletException, IOException {
        PrintWriter out = response.getWriter();
        FacesContext context = getFacesContext();

        char golden = ':';
        char result = UINamingContainer.getSeparatorChar(context);

        if (!(golden == result)) {
            out.println(JSFTestUtil.FAIL + " Unexpected result calling " +
                    "UINamingContainer.getSeparatorChar()!" + JSFTestUtil.NL +
                    "Expected: " + golden + JSFTestUtil.NL +
                    "Received: " + result);
            
        } else {
            out.println(JSFTestUtil.PASS); 
        }      
    }
  

}
