/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
/*
 * @(#)TCKPropertyManager.java	1.9   03/05/16
 */


package com.sun.ts.lib.deliverable.jsf;

import com.sun.javatest.TestEnvironment;
import com.sun.ts.lib.deliverable.AbstractPropertyManager;
import com.sun.ts.lib.deliverable.PropertyNotSetException;

import java.util.Properties;


/**
 * This class serves as a well known place for harness, util, and porting
 * classes to retrieve property values.
 *
 * @author	Kyle Grucci, Ryan Lubke
 */
public class JSFPropertyManager extends AbstractPropertyManager {

    private static JSFPropertyManager jteMgr = new JSFPropertyManager();


    private JSFPropertyManager() {
    }


    /**
     * This method returns the singleton instance of TCKPropertyManager which
     * provides access to all ts.jte properties.  This is only called once by
     * the test harness.
     *
     * @param	env - TestEnvironment object from JavaTest
     * @return	TCKPropertyManager - singleton property manager object
     */
    public final static JSFPropertyManager getTCKPropertyManager(
        TestEnvironment env) throws Exception {
        jteMgr.setTestEnvironment(env);
        return jteMgr;
    }


    /**
     * This method returns the singleton instance of TCKPropertyManager which
     * provides access to all ts.jte properties.  This is only called by the
     * init() method in ManualDeployment.java
     *
     * @param	p - Properties object from JavaTest
     * @return	TCKPropertyManager - singleton property manager object
     */
    public final static JSFPropertyManager getTCKPropertyManager(Properties p)
        throws Exception {
        jteMgr.setJteProperties(p);
        return jteMgr;
    }


    public final static JSFPropertyManager getTCKPropertyManager()
        throws Exception {
        return jteMgr;
    }


    /**
     * This method is called by the test harness to retrieve all properties
     * needed by a particular test.
     *
     * @param	sPropKeys - Properties to retrieve
     * @return	Properties - property/value pairs
     */
    public Properties getTestSpecificProperties(String[] sPropKeys)
        throws PropertyNotSetException {
        Properties pTestProps = super.getTestSpecificProperties(sPropKeys);
        String sJtePropVal = "";
        pTestProps.put("porting.ts.url.class.1",
            getProperty("porting.ts.url.class.1"));
        String tsHome = getProperty("TS_HOME", null);

        pTestProps.put("cts_home", getProperty("cts_home"));
        pTestProps.put("jsf.core.tld.name",
            getProperty("jsf.core.tld.name"));
        pTestProps.put("jsf.html.basic.tld.name",
            getProperty("jsf.html.basic.tld.name"));                

        return pTestProps;
    }
}



