/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: W2JRLR2709Client.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxws.wsi.w2j.rpc.literal.R2709;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.tests.jaxws.sharedclients.SOAPClient;

public class W2JRLR2709Client extends SOAPClient {
    public W2JRLR2709Client(String webServerHost, int webServerPort, int mode) throws EETest.Fault {
        this(webServerHost, webServerPort, mode, null);
    }

    public W2JRLR2709Client(String webServerHost, int webServerPort, int mode, javax.xml.ws.Service webServiceRef) throws EETest.Fault {
        super(webServerHost, webServerPort, mode);
        stubContext.setNamespace("http://w2jrlr2709testservice.org/W2JRLR2709TestService.wsdl");
        stubContext.setService("W2JRLR2709TestService");
        stubContext.setPort("W2JRLR2709TestPort");
        stubContext.setEndpointInterface(W2JRLR2709Test.class);
	stubContext.setWebServiceRef(webServiceRef);
    }

    protected String getEndpointURLProperty() {
        return "wsi.w2jrlr2709.endpoint.1";
    }

    protected String getWSDLURLProperty() {
        return "wsi.w2jrlr2709.wsdlloc.1";
    }

    public String echoString(String str) throws Exception {
        NonNullString nns = new NonNullString();
        nns.setP1(str);
        nns = ((W2JRLR2709Test)stubContext.getStub()).echoString(nns);
        return nns.getP1();
    }
}
