/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
/*
 * $Id: AddressingFeatureTestImpl2.java 62602 2011-04-21 14:51:41Z kgrucci $
 */
package com.sun.ts.tests.jaxws.wsa.j2w.document.literal.addressingfeature;

import com.sun.ts.lib.util.*;
import com.sun.ts.lib.porting.*;
import com.sun.ts.lib.harness.*;

import javax.jws.WebService;
import javax.jws.WebParam;
import javax.jws.HandlerChain;
import javax.xml.ws.BindingType;
import javax.xml.ws.soap.SOAPBinding;
import javax.xml.ws.Holder;
import javax.xml.ws.Action;
import javax.xml.ws.soap.Addressing;

@WebService(
    name="AddressingFeatureTest2",
    portName="AddressingFeatureTest2Port",
    targetNamespace="http://addressingfeatureservice.org/wsdl",
    serviceName="AddressingFeatureTest2Service"
)

@BindingType(value=SOAPBinding.SOAP11HTTP_BINDING)
@Addressing(enabled=true,required=true)
@HandlerChain(name="", file="server-handler.xml")

public class AddressingFeatureTestImpl2 {
    @Action(
        input="inputAction",
        output="outputAction")
    public int addNumbers2(
        @WebParam(name="testName",
		mode=WebParam.Mode.INOUT) Holder<String> testName,
        @WebParam(name="number1") int number1,
        @WebParam(name="number2") int number2) {
        if (number1 < 0 || number2 < 0) {
            throw new AddressingFeatureException("One of the numbers received was negative:"+number1+", "+number2);
        }
        System.out.printf("Adding %s and %s\n", number1, number2);
	return number1 + number2;
    }

}
