/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.concurrency.spec.ContextService.contextPropagate_servlet;

import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.BASE64Encoder;
import com.sun.ts.lib.util.TestUtil;

import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;

@WebServlet("/ProxyCreatorServlet")
public class ProxyCreatorServlet extends HttpServlet {

  @Override
  protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {

    String action = req.getParameter("action");
    Object proxy = true;
    String result = null;
    URL url = new URL("http://" + req.getServerName() + ":" + req.getServerPort() + "/ContextPropagate_servlet2_web/TestServlet");;
    TSURL ctsurl = new TSURL();
    if ("createJNDIWork".equals(action)) {
      try {
        proxy = Util.lookupDefaultContextService().createContextualProxy(new TestJNDIRunnableWork(),
            Runnable.class, TestWorkInterface.class, Serializable.class);
      } catch (NamingException e) {
        throw new ServletException(e);
      }
    }

    if ("createClassloaderWork".equals(action)) {
      try {
        proxy = Util.lookupDefaultContextService().createContextualProxy(new TestClassloaderRunnableWork(),
            Runnable.class, TestWorkInterface.class, Serializable.class);
      } catch (NamingException e) {
        throw new ServletException(e);
      }
    }

    Properties p = new Properties();
    p.setProperty("proxy", proxyToString(proxy));
    URLConnection urlConn = TestUtil.sendPostData(p, url);
    result = TestUtil.getResponse(urlConn);
    resp.getWriter().write(result);
  }

  private String proxyToString(Object proxy) throws IOException {
    ByteArrayOutputStream bout = new ByteArrayOutputStream();
    ObjectOutputStream out = new ObjectOutputStream(bout);
    out.writeObject(proxy);
    out.close();
    BASE64Encoder encoder = new BASE64Encoder();
    return encoder.encode(bout.toByteArray());
  }
}
