/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee20.resourcedefs.annotations;

import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.ee20.resourcedefs.annotations.EjbClientIF;
import jakarta.ejb.EJB;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSConnectionFactoryDefinition;
import jakarta.jms.JMSConnectionFactoryDefinitions;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSDestinationDefinition;
import jakarta.jms.JMSDestinationDefinitions;
import jakarta.jms.JMSProducer;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnectionFactory;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@JMSDestinationDefinitions(value={@JMSDestinationDefinition(description="Define Queue AppClientMyTestQueue", interfaceName="jakarta.jms.Queue", name="java:global/env/AppClientMyTestQueue", destinationName="AppClientMyTestQueue"), @JMSDestinationDefinition(description="Define Topic AppClientMyTestTopic", interfaceName="jakarta.jms.Topic", name="java:app/env/AppClientMyTestTopic", destinationName="AppClientMyTestTopic")})
@JMSConnectionFactoryDefinitions(value={@JMSConnectionFactoryDefinition(description="Define ConnectionFactory AppClientMyTestConnectionFactory", interfaceName="jakarta.jms.ConnectionFactory", name="java:global/AppClientMyTestConnectionFactory", user="j2ee", password="j2ee"), @JMSConnectionFactoryDefinition(description="Define QueueConnectionFactory AppClientMyTestQueueConnectionFactory", interfaceName="jakarta.jms.QueueConnectionFactory", name="java:app/AppClientMyTestQueueConnectionFactory", user="j2ee", password="j2ee"), @JMSConnectionFactoryDefinition(description="Define TopicConnectionFactory AppClientMyTestTopicConnectionFactory", interfaceName="jakarta.jms.TopicConnectionFactory", name="java:module/AppClientMyTestTopicConnectionFactory", user="j2ee", password="j2ee"), @JMSConnectionFactoryDefinition(description="Define Durable TopicConnectionFactory AppClientMyTestDurableTopicConnectionFactory", interfaceName="jakarta.jms.TopicConnectionFactory", name="java:comp/env/jms/AppClientMyTestDurableTopicConnectionFactory", user="j2ee", password="j2ee", clientId="MyClientID", properties={"Property1=10", "Property2=20"}, transactional=false, maxPoolSize=30, minPoolSize=20)})
public class ClientIT {
    private static final long serialVersionUID = 1L;
    protected transient ConnectionFactory dcf = null;
    protected transient ConnectionFactory cf = null;
    protected transient ConnectionFactory cfra = null;
    protected transient QueueConnectionFactory qcf = null;
    protected transient TopicConnectionFactory tcf = null;
    protected transient TopicConnectionFactory dtcf = null;
    protected transient Topic topic = null;
    protected transient Topic topica = null;
    protected transient Queue queue = null;
    protected transient JMSContext context = null;
    protected transient JMSConsumer consumerQ = null;
    protected transient JMSProducer producerQ = null;
    protected transient JMSConsumer consumerT = null;
    protected transient JMSProducer producerT = null;
    protected boolean queueTest = false;
    protected Properties props = null;
    protected long timeout;
    protected String user;
    protected String password;
    protected String mode;
    private static final String PROTOCOL = "http";
    private static final String HOSTNAME = "localhost";
    private static final int PORTNUM = 8000;
    private TSURL ctsurl = new TSURL();
    private String hostname = "localhost";
    private int portnum = 8000;
    private URL url = null;
    private transient URLConnection urlConn = null;
    private String SERVLET = "/resourcedefs_annotations_web/ServletTest";
    private String JSP = "/resourcedefs_annotations_web/JspClient.jsp";
    @EJB(name="ejb/JMSResourceDefsEjbClientBean")
    static EjbClientIF ejbclient;
    private static final System.Logger logger;

    @BeforeEach
    public void setup() throws Exception {
        boolean pass = true;
        try {
            this.timeout = Integer.parseInt(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            this.hostname = System.getProperty("webServerHost");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null ");
            }
            if (this.password == null) {
                throw new Exception("'password' is null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' is null");
            }
            if (this.hostname == null) {
                throw new Exception("'webServerHost' is null");
            }
            try {
                this.portnum = Integer.parseInt(System.getProperty("webServerPort"));
            }
            catch (Exception e) {
                throw new Exception("'webServerPort' in must be a number");
            }
            if (ejbclient == null) {
                throw new Exception("setup failed: ejbclient injection failure");
            }
        }
        catch (Exception e) {
            throw new Exception("setup failed:", e);
        }
        logger.log(System.Logger.Level.INFO, "setup ok");
    }

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.INFO, "cleanup ok");
    }

    private void doLookupJMSObjects() throws Exception {
        try {
            logger.log(System.Logger.Level.INFO, "Lookup JMS factories defined in @JMSConnectionFactoryDefinitions");
            logger.log(System.Logger.Level.INFO, "Lookup JMS destinations defined in @JMSDestinationDefinitions");
            TSNamingContext namingctx = new TSNamingContext();
            logger.log(System.Logger.Level.INFO, "Lookup java:comp/DefaultJMSConnectionFactory");
            this.dcf = (ConnectionFactory)namingctx.lookup("java:comp/DefaultJMSConnectionFactory");
            logger.log(System.Logger.Level.INFO, "Lookup java:global/AppClientMyTestConnectionFactory");
            this.cf = (ConnectionFactory)namingctx.lookup("java:global/AppClientMyTestConnectionFactory");
            logger.log(System.Logger.Level.INFO, "Lookup java:app/AppClientMyTestQueueConnectionFactory");
            this.qcf = (QueueConnectionFactory)namingctx.lookup("java:app/AppClientMyTestQueueConnectionFactory");
            logger.log(System.Logger.Level.INFO, "Lookup java:module/AppClientMyTestTopicConnectionFactory");
            this.tcf = (TopicConnectionFactory)namingctx.lookup("java:module/AppClientMyTestTopicConnectionFactory");
            logger.log(System.Logger.Level.INFO, "Lookup java:comp/env/jms/AppClientMyTestDurableTopicConnectionFactory");
            this.dtcf = (TopicConnectionFactory)namingctx.lookup("java:comp/env/jms/AppClientMyTestDurableTopicConnectionFactory");
            logger.log(System.Logger.Level.INFO, "Lookup java:global/env/AppClientMyTestQueue");
            this.queue = (Queue)namingctx.lookup("java:global/env/AppClientMyTestQueue");
            logger.log(System.Logger.Level.INFO, "Lookup java:app/env/AppClientMyTestTopic");
            this.topic = (Topic)namingctx.lookup("java:app/env/AppClientMyTestTopic");
            logger.log(System.Logger.Level.INFO, "Create JMSContext, JMSProducer's and JMSConsumer's");
            this.context = this.cf.createContext(this.user, this.password, 1);
            this.producerQ = this.context.createProducer();
            this.consumerQ = this.context.createConsumer((Destination)this.queue);
            this.producerT = this.context.createProducer();
            this.consumerT = this.context.createConsumer((Destination)this.topic);
        }
        catch (Exception e) {
            throw new Exception("doLookupJMSObjects failed:", e);
        }
    }

    private void doCleanup() throws Exception {
        try {
            if (this.queueTest && this.consumerQ != null) {
                logger.log(System.Logger.Level.INFO, "Flush any messages left on Queue");
                Message rmsg = this.consumerQ.receive(this.timeout);
                while (rmsg != null) {
                    rmsg = this.consumerQ.receiveNoWait();
                    if (rmsg != null) continue;
                    rmsg = this.consumerQ.receiveNoWait();
                }
                this.consumerQ.close();
            }
            if (this.consumerT != null) {
                this.consumerT.close();
            }
            logger.log(System.Logger.Level.INFO, "Close JMSContext Objects");
            if (this.context != null) {
                this.context.close();
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("doCleanup failed!", e);
        }
    }

    @Test
    public void sendAndRecvQueueTestFromAppClient() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.doLookupJMSObjects();
            this.queueTest = true;
            logger.log(System.Logger.Level.INFO, "Creating TextMessage via JMSContext.createTextMessage(String)");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvQueueTestFromAppClient");
            logger.log(System.Logger.Level.INFO, "Sending TextMessage via JMSProducer.send(Destination, Message)");
            this.producerQ.send((Destination)this.queue, (Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "Receive TextMessage via JMSconsumer.receive(long)");
            TextMessage actTextMessage = (TextMessage)this.consumerQ.receive(this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("sendAndRecvQueueTestFromAppClient", e);
        }
        finally {
            try {
                this.doCleanup();
            }
            catch (Exception e) {
                throw new Exception("doCleanup failed: ", e);
            }
        }
        if (!pass) {
            throw new Exception("sendAndRecvQueueTestFromAppClient failed");
        }
    }

    @Test
    public void sendAndRecvTopicTestFromAppClient() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.doLookupJMSObjects();
            this.queueTest = false;
            logger.log(System.Logger.Level.INFO, "Creating TextMessage via JMSContext.createTextMessage(String)");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvTopicTestFromAppClient");
            logger.log(System.Logger.Level.INFO, "Sending TextMessage via JMSProducer.send(Destination, Message)");
            this.producerT.send((Destination)this.topic, (Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "Receive TextMessage via JMSconsumer.receive(long)");
            TextMessage actTextMessage = (TextMessage)this.consumerT.receive(this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("sendAndRecvTopicTestFromAppClient", e);
        }
        finally {
            try {
                this.doCleanup();
            }
            catch (Exception e) {
                throw new Exception("doCleanup failed: ", e);
            }
        }
        if (!pass) {
            throw new Exception("sendAndRecvTopicTestFromAppClient failed");
        }
    }

    @Test
    public void sendAndRecvQueueTestFromServletClient() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "-------------------------------------");
            logger.log(System.Logger.Level.INFO, "sendAndRecvQueueTestFromServletClient");
            logger.log(System.Logger.Level.INFO, "-------------------------------------");
            this.url = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.SERVLET);
            logger.log(System.Logger.Level.INFO, "Servlet URL: " + this.url);
            this.props.setProperty("TEST", "sendAndRecvQueueTestFromServletClient");
            this.urlConn = TestUtil.sendPostData((Properties)this.props, (URL)this.url);
            Properties p = TestUtil.getResponseProperties((URLConnection)this.urlConn);
            String passStr = System.getProperty("TESTRESULT");
            if (passStr.equals("fail")) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "JMSConnectionFactoryDefinitions test failed from Servlet");
                logger.log(System.Logger.Level.ERROR, "JMSDestinationDefinitions test failed from Servlet");
            } else {
                logger.log(System.Logger.Level.INFO, "JMSConnectionFactoryDefinitions test passed from Servlet");
                logger.log(System.Logger.Level.INFO, "JMSDestinationDefinitions test passed from Servlet");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "JMSConnectionFactoryDefinitions test failed from Servlet");
            logger.log(System.Logger.Level.ERROR, "JMSDestinationDefinitions test failed from Servlet");
            pass = false;
        }
        if (!pass) {
            throw new Exception("sendAndRecvQueueTestFromServletClient failed");
        }
    }

    @Test
    public void sendAndRecvTopicTestFromServletClient() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "-------------------------------------");
            logger.log(System.Logger.Level.INFO, "sendAndRecvTopicTestFromServletClient");
            logger.log(System.Logger.Level.INFO, "-------------------------------------");
            this.url = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.SERVLET);
            logger.log(System.Logger.Level.INFO, "Servlet URL: " + this.url);
            this.props.setProperty("TEST", "sendAndRecvTopicTestFromServletClient");
            this.urlConn = TestUtil.sendPostData((Properties)this.props, (URL)this.url);
            Properties p = TestUtil.getResponseProperties((URLConnection)this.urlConn);
            String passStr = System.getProperty("TESTRESULT");
            if (passStr.equals("fail")) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "JMSConnectionFactoryDefinitions test failed from Servlet");
                logger.log(System.Logger.Level.ERROR, "JMSDestinationDefinitions test failed from Servlet");
            } else {
                logger.log(System.Logger.Level.INFO, "JMSConnectionFactoryDefinitions test passed from Servlet");
                logger.log(System.Logger.Level.INFO, "JMSDestinationDefinitions test passed from Servlet");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "JMSConnectionFactoryDefinitions test failed from Servlet");
            logger.log(System.Logger.Level.ERROR, "JMSDestinationDefinitions test failed from Servlet");
            pass = false;
        }
        if (!pass) {
            throw new Exception("sendAndRecvTopicTestFromServletClient failed");
        }
    }

    @Test
    public void sendAndRecvQueueTestFromJspClient() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "---------------------------------");
            logger.log(System.Logger.Level.INFO, "sendAndRecvQueueTestFromJspClient");
            logger.log(System.Logger.Level.INFO, "---------------------------------");
            this.url = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.JSP);
            logger.log(System.Logger.Level.INFO, "Jsp URL: " + this.url);
            this.props.setProperty("TEST", "sendAndRecvQueueTestFromJspClient");
            this.urlConn = TestUtil.sendPostData((Properties)this.props, (URL)this.url);
            Properties p = TestUtil.getResponseProperties((URLConnection)this.urlConn);
            String passStr = System.getProperty("TESTRESULT");
            if (passStr.equals("fail")) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "JMSConnectionFactoryDefinitions test failed from Jsp");
                logger.log(System.Logger.Level.ERROR, "JMSDestinationDefinitions test failed from Jsp");
            } else {
                logger.log(System.Logger.Level.INFO, "JMSConnectionFactoryDefinitions test passed from Jsp");
                logger.log(System.Logger.Level.INFO, "JMSDestinationDefinitions test passed from Jsp");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "JMSConnectionFactoryDefinitions test failed from Jsp");
            logger.log(System.Logger.Level.ERROR, "JMSDestinationDefinitions test failed from Jsp");
            pass = false;
        }
        if (!pass) {
            throw new Exception("sendAndRecvQueueTestFromJspClient failed");
        }
    }

    @Test
    public void sendAndRecvTopicTestFromJspClient() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "---------------------------------");
            logger.log(System.Logger.Level.INFO, "sendAndRecvTopicTestFromJspClient");
            logger.log(System.Logger.Level.INFO, "---------------------------------");
            this.url = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.JSP);
            logger.log(System.Logger.Level.INFO, "Jsp URL: " + this.url);
            this.props.setProperty("TEST", "sendAndRecvTopicTestFromJspClient");
            this.urlConn = TestUtil.sendPostData((Properties)this.props, (URL)this.url);
            Properties p = TestUtil.getResponseProperties((URLConnection)this.urlConn);
            String passStr = System.getProperty("TESTRESULT");
            if (passStr.equals("fail")) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "JMSConnectionFactoryDefinitions test failed from Jsp");
                logger.log(System.Logger.Level.ERROR, "JMSDestinationDefinitions test failed from Jsp");
            } else {
                logger.log(System.Logger.Level.INFO, "JMSConnectionFactoryDefinitions test passed from Jsp");
                logger.log(System.Logger.Level.INFO, "JMSDestinationDefinitions test passed from Jsp");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "JMSConnectionFactoryDefinitions test failed from Jsp");
            logger.log(System.Logger.Level.ERROR, "JMSDestinationDefinitions test failed from Jsp");
            pass = false;
        }
        if (!pass) {
            throw new Exception("sendAndRecvTopicTestFromJspClient failed");
        }
    }

    @Test
    public void sendAndRecvQueueTestFromEjbClient() throws Exception {
        boolean pass = true;
        try {
            ejbclient.init(this.props);
            logger.log(System.Logger.Level.INFO, "---------------------------------");
            logger.log(System.Logger.Level.INFO, "sendAndRecvQueueTestFromEjbClient");
            logger.log(System.Logger.Level.INFO, "---------------------------------");
            boolean passEjb = ejbclient.echo("sendAndRecvQueueTestFromEjbClient");
            if (!passEjb) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "JMSConnectionFactoryDefinitions test failed from Ejb");
                logger.log(System.Logger.Level.ERROR, "JMSDestinationDefinitions test failed from Ejb");
            } else {
                logger.log(System.Logger.Level.INFO, "JMSConnectionFactoryDefinitions test passed from Ejb");
                logger.log(System.Logger.Level.INFO, "JMSDestinationDefinitions test passed from Ejb");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "JMSConnectionFactoryDefinitions test failed from Ejb");
            logger.log(System.Logger.Level.ERROR, "JMSDestinationDefinitions test failed from Ejb");
            pass = false;
        }
        if (!pass) {
            throw new Exception("sendAndRecvQueueTestFromEjbClient failed");
        }
    }

    @Test
    public void sendAndRecvTopicTestFromEjbClient() throws Exception {
        boolean pass = true;
        try {
            ejbclient.init(this.props);
            logger.log(System.Logger.Level.INFO, "---------------------------------");
            logger.log(System.Logger.Level.INFO, "sendAndRecvTopicTestFromEjbClient");
            logger.log(System.Logger.Level.INFO, "---------------------------------");
            boolean passEjb = ejbclient.echo("sendAndRecvTopicTestFromEjbClient");
            if (!passEjb) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "JMSConnectionFactoryDefinitions test failed from Ejb");
                logger.log(System.Logger.Level.ERROR, "JMSDestinationDefinitions test failed from Ejb");
            } else {
                logger.log(System.Logger.Level.INFO, "JMSConnectionFactoryDefinitions test passed from Ejb");
                logger.log(System.Logger.Level.INFO, "JMSDestinationDefinitions test passed from Ejb");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "JMSConnectionFactoryDefinitions test failed from Ejb");
            logger.log(System.Logger.Level.ERROR, "JMSDestinationDefinitions test failed from Ejb");
            pass = false;
        }
        if (!pass) {
            throw new Exception("sendAndRecvTopicTestFromEjbClient failed");
        }
    }

    @Test
    public void checkClientIDOnDurableConnFactoryTest() throws Exception {
        boolean pass = true;
        JMSContext context = null;
        try {
            this.queueTest = false;
            this.doLookupJMSObjects();
            logger.log(System.Logger.Level.INFO, "==============================================================");
            logger.log(System.Logger.Level.INFO, "Verify admin configured client id is MyClientID from AppClient");
            logger.log(System.Logger.Level.INFO, "==============================================================");
            logger.log(System.Logger.Level.INFO, "Create JMSContext from durable topic connection factory");
            logger.log(System.Logger.Level.INFO, "Check the client id which is configured as MyClientID in the JMSConnectionFactoryDefinition annotation");
            context = this.dtcf.createContext(this.user, this.password, 1);
            String clientid = context.getClientID();
            if (clientid == null) {
                logger.log(System.Logger.Level.ERROR, "Client ID value is null (expected MyClientID)");
                pass = false;
            } else if (clientid.equals("MyClientID")) {
                logger.log(System.Logger.Level.INFO, "Client ID value is correct (MyClientID)");
            } else {
                logger.log(System.Logger.Level.ERROR, "Client ID value is incorrect (expected MyClientID, got " + clientid + ")");
                pass = false;
            }
            context.close();
            context = null;
            try {
                this.doCleanup();
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error in cleanup");
            }
            logger.log(System.Logger.Level.INFO, "==================================================================");
            logger.log(System.Logger.Level.INFO, "Verify admin configured client id is MyClientID from ServletClient");
            logger.log(System.Logger.Level.INFO, "==================================================================");
            this.url = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.SERVLET);
            logger.log(System.Logger.Level.INFO, "Servlet URL: " + this.url);
            this.props.setProperty("TEST", "checkClientIDTestFromServletClient");
            this.urlConn = TestUtil.sendPostData((Properties)this.props, (URL)this.url);
            Properties p = TestUtil.getResponseProperties((URLConnection)this.urlConn);
            String passStr = System.getProperty("TESTRESULT");
            if (passStr.equals("fail")) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Check ClientID test failed from Servlet");
            } else {
                logger.log(System.Logger.Level.INFO, "Check ClientID test passed from Servlet");
            }
            logger.log(System.Logger.Level.INFO, "==============================================================");
            logger.log(System.Logger.Level.INFO, "Verify admin configured client id is MyClientID from JspClient");
            logger.log(System.Logger.Level.INFO, "==============================================================");
            this.url = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.JSP);
            logger.log(System.Logger.Level.INFO, "Jsp URL: " + this.url);
            this.props.setProperty("TEST", "checkClientIDTestFromJspClient");
            this.urlConn = TestUtil.sendPostData((Properties)this.props, (URL)this.url);
            p = TestUtil.getResponseProperties((URLConnection)this.urlConn);
            passStr = System.getProperty("TESTRESULT");
            if (passStr.equals("fail")) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Check ClientID test failed from Jsp");
            } else {
                logger.log(System.Logger.Level.INFO, "Check ClientID test passed from Jsp");
            }
            logger.log(System.Logger.Level.INFO, "==============================================================");
            logger.log(System.Logger.Level.INFO, "Verify admin configured client id is MyClientID from EjbClient");
            logger.log(System.Logger.Level.INFO, "==============================================================");
            boolean passEjb = ejbclient.echo("checkClientIDTestFromEjbClient");
            if (!passEjb) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Check ClientID test failed from Ejb");
            } else {
                logger.log(System.Logger.Level.INFO, "Check ClientID test passed from Ejb");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("checkClientIDOnDurableConnFactoryTest", e);
        }
        finally {
            try {
                if (context != null) {
                    context.close();
                }
                this.doCleanup();
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error cleanup " + e);
            }
        }
        if (!pass) {
            throw new Exception("checkClientIDOnDurableConnFactoryTest failed");
        }
    }

    static {
        logger = System.getLogger(ClientIT.class.getName());
    }
}

