/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee20.cditests.mdb;

import com.sun.ts.lib.util.TSNamingContext;
import jakarta.annotation.Resource;
import jakarta.ejb.EJBContext;
import jakarta.ejb.MessageDrivenBean;
import jakarta.ejb.MessageDrivenContext;
import jakarta.inject.Inject;
import jakarta.jms.Destination;
import jakarta.jms.JMSConnectionFactory;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.Queue;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.util.Properties;

public class MsgBeanQ
implements MessageDrivenBean,
MessageListener {
    private static final long serialVersionUID = 1L;
    private Properties p = new Properties();
    private TSNamingContext context = null;
    private transient MessageDrivenContext mdc = null;
    private static final System.Logger logger = System.getLogger(MsgBeanQ.class.getName());
    @Inject
    @JMSConnectionFactory(value="jms/QueueConnectionFactory")
    transient JMSContext context1;
    @Inject
    @JMSConnectionFactory(value="jms/TopicConnectionFactory")
    transient JMSContext context2;
    @Resource(name="jms/mdbReplyQueue")
    private transient Queue replyQueue;
    @Resource(name="jms/mdbReplyTopic")
    private transient Topic replyTopic;

    public void ejbCreate() {
        System.out.println("MsgBeanQ.ejbCreate()!");
    }

    public void setMessageDrivenContext(MessageDrivenContext mdc) {
        System.out.println("MsgBeanQ.setMessageDrivenContext()!");
        this.mdc = mdc;
    }

    public void ejbRemove() {
        System.out.println("MsgBeanQ.ejbRemove()!");
    }

    public EJBContext getEJBContext() {
        return this.mdc;
    }

    public void onMessage(Message msg) {
        System.out.println("MsgBeanQ.onMessage(): entering MDB");
        System.out.println("MsgBeanQ.onMessage(): JMSContext context1=" + this.context1);
        System.out.println("MsgBeanQ.onMessage(): JMSContext context2=" + this.context2);
        boolean status = false;
        Object reason = null;
        String testname = null;
        try {
            testname = msg.getStringProperty("TESTNAME");
        }
        catch (JMSException e) {
            reason = "MsgBeanQ.onMessage(): failed to get TESTNAME from message";
            if (this.context1 == null || this.context2 == null) {
                reason = (String)reason + ", failed CDI injection of JMSContext";
            }
            System.out.println((String)reason);
            return;
        }
        if (this.context1 == null || this.context2 == null) {
            reason = "MsgBeanQ.onMessage(): failed CDI injection of JMSContext";
            System.out.println((String)reason);
            if (testname.equals("testCDIInjectionOfMDBWithQueueReplyFromEjb")) {
                this.sendReplyToQ(testname, status, (String)reason, this.context1, this.replyQueue);
            } else {
                this.sendReplyToT(testname, status, (String)reason, this.context2, this.replyTopic);
            }
        }
        status = true;
        reason = "MsgBeanQ.onMessage(): received message from TESTNAME=" + testname;
        System.out.println((String)reason);
        if (testname.equals("testCDIInjectionOfMDBWithQueueReplyFromEjb")) {
            this.sendReplyToQ(testname, status, (String)reason, this.context1, this.replyQueue);
        } else {
            this.sendReplyToT(testname, status, (String)reason, this.context2, this.replyTopic);
        }
        System.out.println("MsgBeanQ.onMessage(): leaving MDB");
    }

    private void sendReplyToQ(String testname, boolean status, String reason, JMSContext context, Queue qReply) {
        TextMessage msg = null;
        System.out.println("MsgBeanQ.sendReplyToQ(): entering");
        try {
            msg = context.createTextMessage();
            msg.setStringProperty("TESTNAME", testname);
            msg.setStringProperty("JMSCONTEXT", "context1");
            msg.setStringProperty("REASON", reason);
            msg.setText(testname);
            if (status) {
                msg.setStringProperty("STATUS", "Pass");
            } else {
                msg.setStringProperty("STATUS", "Fail");
            }
            System.out.println("MsgBeanQ.sendReplyToQ(): sending reply with TESTNAME=" + testname + " STATUS=" + status + " JMSCONTEXT=context1 REASON=" + reason);
            context.createProducer().send((Destination)qReply, (Message)msg);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to send reply to ReplyQueue");
        }
        System.out.println("MsgBeanQ.sendReplyToQ(): leaving");
    }

    private void sendReplyToT(String testname, boolean status, String reason, JMSContext context, Topic tReply) {
        TextMessage msg = null;
        System.out.println("MsgBeanQ.sendReplyToT(): entering");
        try {
            msg = context.createTextMessage();
            msg.setStringProperty("TESTNAME", testname);
            msg.setStringProperty("JMSCONTEXT", "context2");
            msg.setStringProperty("REASON", reason);
            msg.setText(testname);
            if (status) {
                msg.setStringProperty("STATUS", "Pass");
            } else {
                msg.setStringProperty("STATUS", "Fail");
            }
            System.out.println("MsgBeanQ.sendReplyToT(): sending reply with TESTNAME=" + testname + " STATUS=" + status + " JMSCONTEXT=context2 REASON=" + reason);
            context.createProducer().send((Destination)tReply, (Message)msg);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to send reply to ReplyTopic");
        }
        System.out.println("MsgBeanQ.sendReplyToT(): leaving");
    }
}

