/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.mdb_msgTypesT3;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.commonee.MDB_T_Test;
import jakarta.ejb.EJB;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MDBClientIT {
    @EJB(name="ejb/MDB_MSGT3_Test")
    private static MDB_T_Test hr;
    private Properties props = new Properties();
    private static final System.Logger logger;

    @BeforeEach
    public void setup() throws Exception {
        try {
            if (hr == null) {
                throw new Exception("@EJB injection failed");
            }
            this.props.put("jms_timeout", System.getProperty("jms_property"));
            this.props.put("user", System.getProperty("user"));
            this.props.put("password", System.getProperty("password"));
            hr.setup(this.props);
            if (hr.isThereSomethingInTheQueue()) {
                logger.log(System.Logger.Level.TRACE, "Error: message(s) left in Q");
                hr.cleanTheQueue();
            } else {
                logger.log(System.Logger.Level.TRACE, "Nothing left in queue");
            }
            logger.log(System.Logger.Level.INFO, "Setup ok;");
        }
        catch (Exception e) {
            throw new Exception("Setup Failed!", e);
        }
    }

    @Test
    public void mdbMsgClearBodyTopicTextTest() throws Exception {
        String testCase1 = "msgClearBodyTopicTextTestCreate";
        String testCase2 = "msgClearBodyTopicTextTest";
        try {
            System.out.println("client - run testcase msgClearBodyTopicTextTestCreate");
            hr.askMDBToRunATest(testCase1);
            System.out.println("client - Check for response from msgClearBodyTopicTextTest");
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: msgClearBodyTopicTextTest failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbMsgClearBodyTopicObjectTest() throws Exception {
        String testCase1 = "msgClearBodyTopicObjectTestCreate";
        String testCase2 = "msgClearBodyTopicObjectTest";
        try {
            System.out.println("client - run testcase msgClearBodyTopicObjectTestCreate");
            hr.askMDBToRunATest(testCase1);
            System.out.println("client - Check for response from msgClearBodyTopicObjectTest");
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: msgClearBodyTopicObjectTest failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbMsgClearBodyTopicMapTest() throws Exception {
        String testCase1 = "msgClearBodyTopicMapTestCreate";
        String testCase2 = "msgClearBodyTopicMapTest";
        try {
            System.out.println("client - run testcase msgClearBodyTopicMapTestCreate");
            hr.askMDBToRunATest(testCase1);
            System.out.println("client - Check for response from msgClearBodyTopicMapTest");
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: msgClearBodyTopicMapTest failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbMsgClearBodyTopicBytesTest() throws Exception {
        String testCase1 = "msgClearBodyTopicBytesTestCreate";
        String testCase2 = "msgClearBodyTopicBytesTest";
        try {
            System.out.println("client - run testcase msgClearBodyTopicBytesTestCreate");
            hr.askMDBToRunATest(testCase1);
            System.out.println("client - Check for response from msgClearBodyTopicBytesTest");
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: msgClearBodyTopicBytesTest failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbMsgClearBodyTopicStreamTest() throws Exception {
        String testCase1 = "msgClearBodyTopicStreamTestCreate";
        String testCase2 = "msgClearBodyTopicStreamTest";
        try {
            System.out.println("client - run testcase msgClearBodyTopicStreamTestCreate");
            hr.askMDBToRunATest(testCase1);
            System.out.println("client - Check for response from msgClearBodyTopicStreamTest");
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: msgClearBodyTopicStreamTest failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbMsgResetTopicTest() throws Exception {
        String testCase = "msgResetTopicTest";
        try {
            System.out.println("client - run testcase msgResetTopicTest");
            hr.askMDBToRunATest(testCase);
            System.out.println("client - Check for response from msgResetTopicTest");
            if (!hr.checkOnResponse(testCase)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: msgResetTopicTest failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbReadNullCharNotValidTopicMapTest() throws Exception {
        String testCase1 = "readNullCharNotValidTopicMapTestCreate";
        String testCase2 = "readNullCharNotValidTopicMapTest";
        try {
            System.out.println("client - run testcase readNullCharNotValidTopicMapTestCreate");
            hr.askMDBToRunATest(testCase1);
            System.out.println("client - Check for response from readNullCharNotValidTopicMapTest");
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: readNullCharNotValidTopicMapTest failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbReadNullCharNotValidTopicStreamTest() throws Exception {
        String testCase1 = "readNullCharNotValidTopicStreamTestCreate";
        String testCase2 = "readNullCharNotValidTopicStreamTest";
        try {
            System.out.println("client - run testcase readNullCharNotValidTopicStreamTestCreate");
            hr.askMDBToRunATest(testCase1);
            System.out.println("client - Check for response from readNullCharNotValidTopicStreamTest");
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: readNullCharNotValidTopicStreamTest failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            if (hr.isThereSomethingInTheQueue()) {
                logger.log(System.Logger.Level.TRACE, "Error: message(s) left in Q");
                hr.cleanTheQueue();
            } else {
                logger.log(System.Logger.Level.TRACE, "Nothing left in queue");
            }
            logger.log(System.Logger.Level.INFO, "End  of client cleanup;");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    static {
        logger = System.getLogger(MDBClientIT.class.getName());
    }
}

