/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.mdb_msgTypesQ1;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsUtil;
import jakarta.ejb.EJBException;
import jakarta.ejb.MessageDrivenBean;
import jakarta.ejb.MessageDrivenContext;
import jakarta.jms.BytesMessage;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageListener;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.TextMessage;
import java.util.Properties;

public class MsgBean
implements MessageDrivenBean,
MessageListener {
    private Properties p = null;
    private TSNamingContext context = null;
    private MessageDrivenContext mdc = null;
    private QueueConnectionFactory qFactory = null;
    private QueueConnection qConnection = null;
    private Queue queueR = null;
    private Queue queue = null;
    private QueueSender mSender = null;
    private QueueSession qSession = null;
    private static final System.Logger logger = System.getLogger(MsgBean.class.getName());

    public MsgBean() {
        logger.log(System.Logger.Level.TRACE, "@MsgBean()!");
    }

    public void ejbCreate() {
        logger.log(System.Logger.Level.TRACE, "jms.ee.mdb.mdb_msgTypesQ1  - @MsgBean-ejbCreate() !!");
        try {
            this.context = new TSNamingContext();
            this.qFactory = (QueueConnectionFactory)this.context.lookup("java:comp/env/jms/MyQueueConnectionFactory");
            if (this.qFactory == null) {
                logger.log(System.Logger.Level.TRACE, "qFactory error");
            }
            logger.log(System.Logger.Level.TRACE, "got a qFactory !!");
            this.queueR = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE_REPLY");
            if (this.queueR == null) {
                logger.log(System.Logger.Level.TRACE, "queueR error");
            }
            this.queue = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE");
            if (this.queue == null) {
                logger.log(System.Logger.Level.TRACE, "queue error");
            }
            this.p = new Properties();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("MDB ejbCreate Error!", e);
        }
    }

    public void onMessage(Message msg) {
        JmsUtil.initHarnessProps((Message)msg, (Properties)this.p);
        logger.log(System.Logger.Level.TRACE, "from jms.ee.mdb.mdb_msgTypesQ1 @onMessage!" + msg);
        try {
            this.qConnection = this.qFactory.createQueueConnection();
            if (this.qConnection == null) {
                logger.log(System.Logger.Level.TRACE, "connection error");
            } else {
                this.qConnection.start();
                this.qSession = this.qConnection.createQueueSession(true, 0);
            }
            if (msg.getStringProperty("TestCase").equals("bytesMsgNullStreamQTest")) {
                this.bytesMsgNullStreamQTest();
            } else if (msg.getStringProperty("TestCase").equals("bytesMessageQTestsFullMsgCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running bytesMessageQTestsFullMsg1 - create the message");
                this.bytesMessageQTestsFullMsgCreate();
            } else if (msg.getStringProperty("TestCase").equals("bytesMessageQTestsFullMsg")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running bytesMessageQTestsFullMsg - read and verify the message");
                this.bytesMessageQTestsFullMsg((BytesMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("mapMessageFullMsgQTestCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running mapMessageFullMsgQTestCreate - read and verify the message");
                this.mapMessageFullMsgQTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("mapMessageFullMsgQTest")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running mapMessageFullMsgQTest - read and verify the message");
                this.mapMessageFullMsgQTest((MapMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsBooleanCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running mapMessageConversionQTestsBooleanCreate - read and verify the message");
                this.mapMessageConversionQTestsBooleanCreate();
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsBoolean")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running MapMessageConversionQTestsBoolean - read and verify the message");
                this.mapMessageConversionQTestsBoolean((MapMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsByteCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running mapMessageConversionQTestsByteCreate - read and verify the message");
                this.mapMessageConversionQTestsByteCreate();
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsByte")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running  mapMessageConversionQTestsByte - read and verify the message");
                this.mapMessageConversionQTestsByte((MapMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsShortCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running mapMessageConversionQTestsShortCreate - read and verify the message");
                this.mapMessageConversionQTestsShortCreate();
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsShort")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running  mapMessageConversionQTestsShort - read and verify the message");
                this.mapMessageConversionQTestsShort((MapMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsCharCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running mapMessageConversionQTestsCharCreate - read and verify the message");
                this.mapMessageConversionQTestsCharCreate();
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsChar")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running  mapMessageConversionQTestsChar - read and verify the message");
                this.mapMessageConversionQTestsChar((MapMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsIntCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running mapMessageConversionQTestsIntCreate - read and verify the message");
                this.mapMessageConversionQTestsIntCreate();
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsInt")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running  mapMessageConversionQTestsInt - read and verify the message");
                this.mapMessageConversionQTestsInt((MapMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsLongCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running mapMessageConversionQTestsLongCreate - read and verify the message");
                this.mapMessageConversionQTestsLongCreate();
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsLong")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running  mapMessageConversionQTestsLong - read and verify the message");
                this.mapMessageConversionQTestsLong((MapMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsFloatCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running mapMessageConversionQTestsFloatCreate - read and verify the message");
                this.mapMessageConversionQTestsFloatCreate();
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsFloat")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running  mapMessageConversionQTestsFloat - read and verify the message");
                this.mapMessageConversionQTestsFloat((MapMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsDoubleCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running mapMessageConversionQTestsDoubleCreate - read and verify the message");
                this.mapMessageConversionQTestsDoubleCreate();
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsDouble")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running  mapMessageConversionQTestsDouble - read and verify the message");
                this.mapMessageConversionQTestsDouble((MapMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsStringCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running mapMessageConversionQTestsStringCreate - read and verify the message");
                this.mapMessageConversionQTestsStringCreate();
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsString")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running  mapMessageConversionQTestsString - read and verify the message");
                this.mapMessageConversionQTestsString((MapMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsBytesCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running mapMessageConversionQTestsBytesCreate - read and verify the message");
                this.mapMessageConversionQTestsBytesCreate();
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsBytes")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running  mapMessageConversionQTestsBytes - read and verify the message");
                this.mapMessageConversionQTestsBytes((MapMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsInvFormatStringCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running mapMessageConversionQTestsInvFormatStringCreate - read and verify the message");
                this.mapMessageConversionQTestsInvFormatStringCreate();
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsInvFormatString")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running  mapMessageConversionQTestsInvFormatString - read and verify the message");
                this.mapMessageConversionQTestsInvFormatString((MapMessage)msg);
            } else {
                logger.log(System.Logger.Level.TRACE, "@onMessage - invalid message type found in StringProperty");
                logger.log(System.Logger.Level.TRACE, "@onMessage - could not find method for this testcase: " + msg.getStringProperty("TestCase"));
            }
            logger.log(System.Logger.Level.TRACE, "@onMessage - Finished for this test!");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.qConnection != null) {
                try {
                    this.qConnection.close();
                }
                catch (Exception e) {
                    TestUtil.printStackTrace((Throwable)e);
                }
            }
        }
    }

    private void bytesMsgNullStreamQTest() {
        BytesMessage messageSentBytesMessage = null;
        boolean ok = true;
        TextMessage msg = null;
        logger.log(System.Logger.Level.TRACE, "@bytesMsgNullStreamQTest");
        try {
            this.mSender = this.qSession.createSender(this.queueR);
            msg = this.qSession.createTextMessage();
            JmsUtil.addPropsToMessage((Message)msg, (Properties)this.p);
            msg.setStringProperty("TestCase", "bytesMsgNullStreamQTest");
            msg.setText("bytesMsgNullStreamQTest");
            logger.log(System.Logger.Level.TRACE, "Writing a null stream to byte message should throw a NullPointerException");
            messageSentBytesMessage = this.qSession.createBytesMessage();
            JmsUtil.addPropsToMessage((Message)messageSentBytesMessage, (Properties)this.p);
            messageSentBytesMessage.writeObject(null);
            logger.log(System.Logger.Level.TRACE, "Fail: message did not throw NullPointerException exception as expected");
        }
        catch (NullPointerException np) {
            logger.log(System.Logger.Level.TRACE, "Pass: NullPointerException thrown as expected");
            ok = true;
        }
        catch (JMSException jmsE) {
            TestUtil.printStackTrace((Throwable)jmsE);
            logger.log(System.Logger.Level.TRACE, "Error: " + ((Object)((Object)jmsE)).getClass().getName() + " was thrown");
            ok = false;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            logger.log(System.Logger.Level.TRACE, "Error: " + e.getClass().getName() + " was thrown");
            ok = false;
        }
        try {
            if (ok) {
                msg.setStringProperty("Status", "Pass");
            } else {
                msg.setStringProperty("Status", "Fail");
            }
            logger.log(System.Logger.Level.TRACE, "Sending response message");
            this.mSender.send((Message)msg);
        }
        catch (JMSException je) {
            TestUtil.printStackTrace((Throwable)je);
            logger.log(System.Logger.Level.TRACE, "Error: " + ((Object)((Object)je)).getClass().getName() + " was thrown");
        }
        catch (Exception ee) {
            TestUtil.printStackTrace((Throwable)ee);
            logger.log(System.Logger.Level.TRACE, "Error: " + ee.getClass().getName() + " was thrown");
        }
    }

    private void bytesMessageQTestsFullMsgCreate() {
        this.mSender = null;
        logger.log(System.Logger.Level.TRACE, "MsgBean - @bytesMessageQTestsFullMsgCreate");
        try {
            BytesMessage messageSent = null;
            boolean pass = true;
            boolean booleanValue = false;
            byte byteValue = 127;
            byte[] bytesValue = new byte[]{127, -127, 1, 0};
            char charValue = 'Z';
            double doubleValue = 6.02E23;
            float floatValue = 6.02E23f;
            int intValue = Integer.MAX_VALUE;
            long longValue = Long.MAX_VALUE;
            Integer nInteger = new Integer(Integer.MIN_VALUE);
            short shortValue = Short.MIN_VALUE;
            String utfValue = "what";
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.qSession.createBytesMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "bytesMessageQTestsFullMsg");
            logger.log(System.Logger.Level.TRACE, "Writing one of each primitive type to the message");
            messageSent.writeBoolean(booleanValue);
            messageSent.writeByte(byteValue);
            messageSent.writeChar(charValue);
            messageSent.writeDouble(doubleValue);
            messageSent.writeFloat(floatValue);
            messageSent.writeInt(intValue);
            messageSent.writeLong(longValue);
            messageSent.writeObject((Object)nInteger);
            messageSent.writeShort(shortValue);
            messageSent.writeUTF(utfValue);
            messageSent.writeBytes(bytesValue);
            messageSent.writeBytes(bytesValue, 0, 1);
            messageSent.setStringProperty("TestCase", "bytesMessageQTestsFullMsg");
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void bytesMessageQTestsFullMsg(BytesMessage msg) {
        logger.log(System.Logger.Level.TRACE, "MsgBean - @bytesMessageQTestsFullMsg");
        String testCase = "bytesMessageQTestsFullMsg";
        try {
            Object messageSent = null;
            BytesMessage messageReceived = msg;
            boolean pass = true;
            boolean booleanValue = false;
            byte byteValue = 127;
            byte[] bytesValue = new byte[]{127, -127, 1, 0};
            byte[] bytesValueRecvd = new byte[]{0, 0, 0, 0};
            char charValue = 'Z';
            double doubleValue = 6.02E23;
            float floatValue = 6.02E23f;
            int intValue = Integer.MAX_VALUE;
            long longValue = Long.MAX_VALUE;
            Integer nInteger = new Integer(Integer.MIN_VALUE);
            short shortValue = Short.MIN_VALUE;
            String utfValue = "what";
            logger.log(System.Logger.Level.TRACE, "Starting tests in @bytesMessageQTestsFullMsg");
            try {
                if (messageReceived.readBoolean() == booleanValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: boolean returned ok");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: boolean not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readByte() == byteValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: Byte returned ok");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: Byte not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readChar() == charValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: correct char");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: char not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readDouble() == doubleValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: correct double");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: double not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readFloat() == floatValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: correct float");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: float not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readInt() == intValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: correct int");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: int not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readLong() == longValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: correct long");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: long not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readInt() == nInteger.intValue()) {
                    logger.log(System.Logger.Level.TRACE, "Pass: correct Integer returned");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: Integer not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readShort() == shortValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: correct short");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: short not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readUTF().equals(utfValue)) {
                    logger.log(System.Logger.Level.TRACE, "Pass: correct UTF");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: UTF not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                int nCount = messageReceived.readBytes(bytesValueRecvd);
                for (int i = 0; i < nCount; ++i) {
                    if (bytesValueRecvd[i] != bytesValue[i]) {
                        logger.log(System.Logger.Level.TRACE, "Fail: bytes value incorrect");
                        pass = false;
                        continue;
                    }
                    logger.log(System.Logger.Level.TRACE, "Pass: byte value " + i + " ok");
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                int nCount = messageReceived.readBytes(bytesValueRecvd);
                logger.log(System.Logger.Level.TRACE, "count returned " + nCount);
                if (bytesValueRecvd[0] != bytesValue[0]) {
                    logger.log(System.Logger.Level.TRACE, "Fail: bytes value incorrect");
                    pass = false;
                } else {
                    logger.log(System.Logger.Level.TRACE, "Pass: byte value ok");
                }
                if (nCount == 1) {
                    logger.log(System.Logger.Level.TRACE, "Pass: correct count");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: count not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageFullMsgQTestCreate() {
        boolean booleanValue = false;
        byte byteValue = 127;
        byte[] bytesValue = new byte[]{127, -127, 1, 0};
        char charValue = 'Z';
        double doubleValue = 6.02E23;
        float floatValue = 6.02E23f;
        int intValue = Integer.MAX_VALUE;
        long longValue = Long.MAX_VALUE;
        short shortValue = Short.MAX_VALUE;
        String stringValue = "Map Message Test";
        Integer integerValue = 100;
        String initial = "spring is here!";
        try {
            MapMessage messageSentMapMessage = null;
            logger.log(System.Logger.Level.TRACE, "Send MapMessage to Topic.");
            messageSentMapMessage = this.qSession.createMapMessage();
            JmsUtil.addPropsToMessage((Message)messageSentMapMessage, (Properties)this.p);
            messageSentMapMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "mapMessageFullMsgQTestCreate");
            messageSentMapMessage.setBoolean("booleanValue", booleanValue);
            messageSentMapMessage.setByte("byteValue", byteValue);
            messageSentMapMessage.setBytes("bytesValue", bytesValue);
            messageSentMapMessage.setBytes("bytesValue2", bytesValue, 0, 1);
            messageSentMapMessage.setChar("charValue", charValue);
            messageSentMapMessage.setDouble("doubleValue", doubleValue);
            messageSentMapMessage.setFloat("floatValue", floatValue);
            messageSentMapMessage.setInt("intValue", intValue);
            messageSentMapMessage.setLong("longValue", longValue);
            messageSentMapMessage.setObject("integerValue", (Object)integerValue);
            messageSentMapMessage.setShort("shortValue", shortValue);
            messageSentMapMessage.setString("stringValue", stringValue);
            messageSentMapMessage.setString("nullTest", null);
            messageSentMapMessage.setStringProperty("TestCase", "mapMessageFullMsgQTest");
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSentMapMessage);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageFullMsgQTest(MapMessage messageReceivedMapMessage) {
        String testCase = "mapMessageFullMsgQTest";
        boolean pass = true;
        boolean booleanValue = false;
        byte byteValue = 127;
        byte[] bytesValue = new byte[]{127, -127, 1, 0};
        char charValue = 'Z';
        double doubleValue = 6.02E23;
        float floatValue = 6.02E23f;
        int intValue = Integer.MAX_VALUE;
        long longValue = Long.MAX_VALUE;
        short shortValue = Short.MAX_VALUE;
        String stringValue = "Map Message Test";
        Integer integerValue = 100;
        String initial = "spring is here!";
        try {
            byte[] b;
            try {
                if (messageReceivedMapMessage.getBoolean("booleanValue") == booleanValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: valid boolean returned");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: invalid boolean returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: unexpected exception " + e.getClass().getName() + " was returned");
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.getByte("byteValue") == byteValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: valid byte returned");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: invalid byte returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: unexpected exception " + e.getClass().getName() + " was returned");
                pass = false;
            }
            try {
                b = messageReceivedMapMessage.getBytes("bytesValue");
                for (int i = 0; i < b.length; ++i) {
                    if (b[i] != bytesValue[i]) {
                        logger.log(System.Logger.Level.TRACE, "Fail: byte array " + i + " not valid");
                        pass = false;
                        continue;
                    }
                    logger.log(System.Logger.Level.TRACE, "Pass: byte array " + i + " valid");
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: unexpected exception " + e.getClass().getName() + " was returned");
                pass = false;
            }
            try {
                b = messageReceivedMapMessage.getBytes("bytesValue2");
                if (b[0] != bytesValue[0]) {
                    logger.log(System.Logger.Level.TRACE, "Fail: byte array not valid");
                    pass = false;
                } else {
                    logger.log(System.Logger.Level.TRACE, "Pass: byte array valid");
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: unexpected exception " + e.getClass().getName() + " was returned");
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.getChar("charValue") == charValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: valid char returned");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: invalid char returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: unexpected exception " + e.getClass().getName() + " was returned");
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.getDouble("doubleValue") == doubleValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: valid double returned");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: invalid double returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: unexpected exception " + e.getClass().getName() + " was returned");
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.getFloat("floatValue") == floatValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: valid float returned");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: invalid float returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: unexpected exception " + e.getClass().getName() + " was returned");
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.getInt("intValue") == intValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: valid int returned");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: invalid int returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: unexpected exception " + e.getClass().getName() + " was returned");
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.getLong("longValue") == longValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: valid long returned");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: invalid long returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: unexpected exception " + e.getClass().getName() + " was returned");
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.getObject("integerValue").toString().equals(integerValue.toString())) {
                    logger.log(System.Logger.Level.TRACE, "Pass: valid object returned");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: invalid object returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: unexpected exception " + e.getClass().getName() + " was returned");
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.getShort("shortValue") == shortValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: valid short returned");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: invalid short returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: unexpected exception " + e.getClass().getName() + " was returned");
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.getString("stringValue").equals(stringValue)) {
                    logger.log(System.Logger.Level.TRACE, "Pass: valid string returned");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: invalid string returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: unexpected exception " + e.getClass().getName() + " was returned");
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.getString("nullTest") == null) {
                    logger.log(System.Logger.Level.TRACE, "Pass: null returned");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail:  null not returned from getString");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: unexpected exception " + e.getClass().getName() + " was returned");
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsBooleanCreate() {
        try {
            MapMessage messageSent = null;
            Object messageReceived = null;
            boolean booleanValue = true;
            boolean pass = true;
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.qSession.createMapMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "mapMessageConversionQTestsBooleanCreate");
            messageSent.setStringProperty("TestCase", "mapMessageConversionQTestsBoolean");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for boolean primitive type section 3.11.3");
            messageSent.setBoolean("booleanValue", booleanValue);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsBoolean(MapMessage messageReceived) {
        String testCase = "mapMessageConversionQTestsBoolean";
        try {
            boolean booleanValue = true;
            boolean pass = true;
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for boolean primitive type section 3.11.3");
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readBoolean to read a boolean");
            try {
                if (messageReceived.getBoolean("booleanValue") == booleanValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: boolean to boolean - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readString to read a boolean");
            try {
                if (messageReceived.getString("booleanValue").equals(Boolean.valueOf(booleanValue).toString())) {
                    logger.log(System.Logger.Level.TRACE, "Pass: boolean to string - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readBytes[] to read a boolean - expect MessageFormatException");
            int nCount = 0;
            try {
                byte[] b = messageReceived.getBytes("booleanValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "Count returned from readBytes is : " + nCount);
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readByte to read a boolean - expect MessageFormatException");
            try {
                byte b = messageReceived.getByte("booleanValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readShort to read a boolean - expect MessageFormatException");
            try {
                short s = messageReceived.getShort("booleanValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readChar to read a boolean - expect MessageFormatException");
            try {
                char c = messageReceived.getChar("booleanValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readInt to read a boolean - expect MessageFormatException");
            try {
                int i = messageReceived.getInt("booleanValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readLong to read a boolean - expect MessageFormatException");
            try {
                long l = messageReceived.getLong("booleanValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readFloat to read a boolean - expect MessageFormatException");
            try {
                float f = messageReceived.getFloat("booleanValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readDouble to read a boolean - expect MessageFormatException");
            try {
                double d = messageReceived.getDouble("booleanValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsByteCreate() {
        MapMessage messageSent = null;
        byte byteValue = 127;
        boolean pass = true;
        try {
            messageSent = this.qSession.createMapMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "mapMessageConversionQTestsByteCreate");
            messageSent.setStringProperty("TestCase", "mapMessageConversionQTestsByte");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setByte("byteValue", byteValue);
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsByte(MapMessage messageReceived) {
        String testCase = "mapMessageConversionQTestsByte";
        Object messageSent = null;
        byte byteValue = 127;
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte primitive type section 3.11.3");
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getBoolean to read a byte - this is not valid");
            try {
                boolean b = messageReceived.getBoolean("byteValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getString to read a byte");
            try {
                if (messageReceived.getString("byteValue").equals(Byte.toString(byteValue))) {
                    logger.log(System.Logger.Level.TRACE, "Pass: byte to string - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getBytes[] to read a byte - expect MessageFormatException");
            boolean nCount = false;
            try {
                byte[] b = messageReceived.getBytes("byteValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getByte to read a byte");
            try {
                if (messageReceived.getByte("byteValue") == byteValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: byte to byte - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getShort to read a byte");
            try {
                if (messageReceived.getShort("byteValue") == byteValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: byte to short - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getChar to read a boolean - this is not valid");
            try {
                char c = messageReceived.getChar("byteValue");
                pass = false;
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getInt to read a byte");
            try {
                if (messageReceived.getInt("byteValue") == byteValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: byte to int - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getLong to read a byte");
            try {
                if (messageReceived.getLong("byteValue") == (long)byteValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: byte to long - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getFloat to read a boolean - this is not valid");
            try {
                float f = messageReceived.getFloat("byteValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getDouble to read a boolean - this is not valid");
            try {
                double d = messageReceived.getDouble("byteValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void mapMessageConversionQTestsShortCreate() {
        try {
            MapMessage messageSent = null;
            short shortValue = 1;
            boolean pass = true;
            messageSent = this.qSession.createMapMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "MapMessageConversionQTestsShort");
            messageSent.setStringProperty("TestCase", "mapMessageConversionQTestsShort");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setShort("shortValue", shortValue);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsShort(MapMessage messageReceived) {
        String testCase = "mapMessageConversionQTestsShort";
        try {
            short shortValue = 1;
            boolean pass = true;
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte primitive type section 3.11.3");
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getBoolean to read a short - this is not valid");
            try {
                boolean b = messageReceived.getBoolean("shortValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getString to read a short");
            try {
                if (messageReceived.getString("shortValue").equals(Short.toString(shortValue))) {
                    logger.log(System.Logger.Level.TRACE, "Pass: short to string - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getBytes[] to read a short - expect MessageFormatException");
            try {
                byte[] b = messageReceived.getBytes("shortValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getByte to read a short - this is not valid");
            try {
                byte b = messageReceived.getByte("shortValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getShort to read a short");
            try {
                if (messageReceived.getShort("shortValue") == shortValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: short to short - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getChar to read a short - this is not valid");
            try {
                char c = messageReceived.getChar("shortValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getInt to read a short");
            try {
                if (messageReceived.getInt("shortValue") == shortValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: short to int - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getLong to read a short");
            try {
                if (messageReceived.getLong("shortValue") == (long)shortValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: short to long - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getFloat to read a short - this is not valid");
            try {
                float f = messageReceived.getFloat("shortValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getDouble to read a short - this is not valid");
            try {
                double d = messageReceived.getDouble("shortValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsCharCreate() {
        try {
            MapMessage messageSent = null;
            char charValue = 'a';
            boolean pass = true;
            messageSent = this.qSession.createMapMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "mapMessageConversionQTestsChar");
            messageSent.setStringProperty("TestCase", "mapMessageConversionQTestsChar");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setChar("charValue", charValue);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsIntCreate() {
        try {
            MapMessage messageSent = null;
            int intValue = 6;
            boolean pass = true;
            messageSent = this.qSession.createMapMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "mapMessageConversionQTestsIntCreate");
            messageSent.setStringProperty("TestCase", "mapMessageConversionQTestsInt");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setInt("intValue", intValue);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsLongCreate() {
        try {
            MapMessage messageSent = null;
            long longValue = 2L;
            boolean pass = true;
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.qSession.createMapMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "mapMessageConversionQTestsLongCreate");
            messageSent.setStringProperty("TestCase", "mapMessageConversionQTestsLong");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setLong("longValue", longValue);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsFloatCreate() {
        try {
            MapMessage messageSent = null;
            float floatValue = 5.0f;
            boolean pass = true;
            messageSent = this.qSession.createMapMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "mapMessageConversionQTestsFloatCreate");
            messageSent.setStringProperty("TestCase", "mapMessageConversionQTestsFloat");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setFloat("floatValue", floatValue);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsDoubleCreate() {
        try {
            MapMessage messageSent = null;
            double doubleValue = 3.0;
            boolean pass = true;
            messageSent = this.qSession.createMapMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "mapMessageConversionQTestsDoubleCreate");
            messageSent.setStringProperty("TestCase", "mapMessageConversionQTestsDouble");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setDouble("doubleValue", doubleValue);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsStringCreate() {
        try {
            MapMessage messageSent = null;
            boolean pass = true;
            String myString = "10";
            String myString2 = "true";
            messageSent = this.qSession.createMapMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "mapMessageConversionQTestsStringCreate");
            messageSent.setStringProperty("TestCase", "mapMessageConversionQTestsString");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setString("myString", myString);
            messageSent.setString("myString2", myString2);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsBytesCreate() {
        try {
            MapMessage messageSent = null;
            byte[] byteValues = new byte[]{1, 2, 3};
            boolean pass = true;
            messageSent = this.qSession.createMapMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "mapMessageConversionQTestsBytesCreate");
            messageSent.setStringProperty("TestCase", "mapMessageConversionQTestsBytes");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte[] primitive type section 3.11.3");
            messageSent.setBytes("byteValues", byteValues);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsInvFormatStringCreate() {
        try {
            MapMessage messageSent = null;
            boolean pass = true;
            String myString = "mytest string";
            messageSent = this.qSession.createMapMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "mapMessageConversionQTestsInvFormatStringCreate");
            messageSent.setStringProperty("TestCase", "mapMessageConversionQTestsInvFormatString");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setString("myString", myString);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsChar(MapMessage messageReceived) {
        String testCase = "mapMessageConversionQTestsChar";
        try {
            char charValue = 'a';
            boolean pass = true;
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getBoolean to read a char - this is not valid");
            try {
                boolean b = messageReceived.getBoolean("charValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getString to read a char");
            try {
                if (messageReceived.getString("charValue").equals(Character.valueOf(charValue).toString())) {
                    logger.log(System.Logger.Level.TRACE, "Pass: char to string - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getBytes[] to read a char - expect MessageFormatException");
            try {
                byte[] b = messageReceived.getBytes("charValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getByte to read a char - this is not valid");
            try {
                byte b = messageReceived.getByte("charValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getShort to read a char");
            try {
                short s = messageReceived.getShort("charValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getChar to read a char ");
            try {
                if (messageReceived.getChar("charValue") == charValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: char to char - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getInt to read a char ");
            try {
                int i = messageReceived.getInt("charValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getLong to read a char");
            try {
                long l = messageReceived.getLong("charValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getFloat to read a char - this is not valid");
            try {
                float f = messageReceived.getFloat("charValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getDouble to read a char - this is not valid");
            try {
                double d = messageReceived.getDouble("charValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsInt(MapMessage messageReceived) {
        String testCase = "mapMessageConversionQTestsInt";
        try {
            int intValue = 6;
            boolean pass = true;
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getBoolean to read an int - this is not valid");
            try {
                boolean b = messageReceived.getBoolean("intValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getString to read an int");
            try {
                if (messageReceived.getString("intValue").equals(Integer.toString(intValue))) {
                    logger.log(System.Logger.Level.TRACE, "Pass: int to string - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getBytes[] to read an int - expect MessageFormatException");
            boolean nCount = false;
            try {
                byte[] b = messageReceived.getBytes("intValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getByte to read an int - this is not valid");
            try {
                byte b = messageReceived.getByte("intValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getShort to read an int");
            try {
                short s = messageReceived.getShort("intValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getChar to read an int - this is not valid");
            try {
                char c = messageReceived.getChar("intValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getInt to read an int");
            try {
                if (messageReceived.getInt("intValue") == intValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: int to int - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getLong to read an int");
            try {
                if (messageReceived.getLong("intValue") == (long)intValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: int to long - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getFloat to read an int - this is not valid");
            try {
                float f = messageReceived.getFloat("intValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getDouble to read an int - this is not valid");
            try {
                double d = messageReceived.getDouble("intValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsLong(MapMessage messageReceived) {
        String testCase = "mapMessageConversionQTestsLong";
        try {
            long longValue = 2L;
            boolean pass = true;
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getBoolean to read a long - this is not valid");
            try {
                boolean b = messageReceived.getBoolean("longValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getString to read a long");
            try {
                if (messageReceived.getString("longValue").equals(Long.toString(longValue))) {
                    logger.log(System.Logger.Level.TRACE, "Pass: long to string - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getBytes[] to read  a long - expect MessageFormatException");
            try {
                byte[] b = messageReceived.getBytes("longValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getByte to read an long - this is not valid");
            try {
                byte b = messageReceived.getByte("longValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getShort to read a long");
            try {
                short s = messageReceived.getShort("longValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getChar to read a long - this is not valid");
            try {
                char c = messageReceived.getChar("longValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getInt to read a long");
            try {
                int i = messageReceived.getInt("longValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getLong to read a long");
            try {
                if (messageReceived.getLong("longValue") == longValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: int to long - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getFloat to read a long - this is not valid");
            try {
                float f = messageReceived.getFloat("longValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getDouble to read a long ");
            try {
                double d = messageReceived.getDouble("longValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsFloat(MapMessage messageReceived) {
        String testCase = "mapMessageConversionQTestsFloat";
        try {
            float floatValue = 5.0f;
            boolean pass = true;
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getBoolean to read a float  ");
            try {
                boolean b = messageReceived.getBoolean("floatValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getString to read a float");
            try {
                if (messageReceived.getString("floatValue").equals(Float.toString(floatValue))) {
                    logger.log(System.Logger.Level.TRACE, "Pass: float to string - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getBytes[] to read  a float ");
            try {
                byte[] b = messageReceived.getBytes("floatValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getByte to read a float  ");
            try {
                byte b = messageReceived.getByte("floatValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getShort to read a float");
            try {
                short s = messageReceived.getShort("floatValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getChar to read a long  ");
            try {
                char c = messageReceived.getChar("floatValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getInt to read a float");
            try {
                int i = messageReceived.getInt("floatValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getLong to read a long");
            try {
                long l = messageReceived.getLong("floatValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getFloat to read a float  ");
            try {
                if (messageReceived.getFloat("floatValue") == floatValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: float to float - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getDouble to read a float  ");
            try {
                if (messageReceived.getDouble("floatValue") == (double)floatValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: float to double - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsDouble(MapMessage messageReceived) {
        String testCase = "mapMessageConversionQTestsDouble";
        try {
            double doubleValue = 3.0;
            boolean pass = true;
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getBoolean to read a double  ");
            try {
                boolean b = messageReceived.getBoolean("doubleValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getString to read a double");
            try {
                if (messageReceived.getString("doubleValue").equals(Double.toString(doubleValue))) {
                    logger.log(System.Logger.Level.TRACE, "Pass: double to string");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getBytes[] to read  a double ");
            try {
                byte[] b = messageReceived.getBytes("doubleValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getByte to read a double  ");
            try {
                byte b = messageReceived.getByte("doubleValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getShort to read a double");
            try {
                short s = messageReceived.getShort("doubleValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getChar to read a double  ");
            try {
                char c = messageReceived.getChar("doubleValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getInt to read a double");
            try {
                int i = messageReceived.getInt("doubleValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getLong to read a double");
            try {
                long l = messageReceived.getLong("doubleValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getFloat to read a double  ");
            try {
                float f = messageReceived.getFloat("doubleValue");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getDouble to read an float  ");
            try {
                if (messageReceived.getDouble("doubleValue") == doubleValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: double to double ");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsString(MapMessage messageReceived) {
        String testCase = "mapMessageConversionQTestsString";
        try {
            boolean pass = true;
            String myString = "10";
            String myString2 = "true";
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getString to read a String");
            try {
                if (messageReceived.getString("myString").equals(myString)) {
                    logger.log(System.Logger.Level.TRACE, "Pass: string to string - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getBytes[] to read a String");
            try {
                byte[] b = messageReceived.getBytes("myString");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getByte to read a String");
            try {
                if (messageReceived.getByte("myString") == Byte.parseByte(myString)) {
                    logger.log(System.Logger.Level.TRACE, "Pass: String to byte ");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getShort to read a string");
            try {
                if (messageReceived.getShort("myString") == Short.parseShort(myString)) {
                    logger.log(System.Logger.Level.TRACE, "Pass: String to short ");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getChar to read a String ");
            try {
                char c = messageReceived.getChar("myString");
                logger.log(System.Logger.Level.TRACE, "getChar returned " + c);
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getInt to read a String");
            try {
                if (messageReceived.getInt("myString") == Integer.parseInt(myString)) {
                    logger.log(System.Logger.Level.TRACE, "Pass: String to int ");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getLong to read a String");
            try {
                if (messageReceived.getLong("myString") == Long.parseLong(myString)) {
                    logger.log(System.Logger.Level.TRACE, "Pass: String to long ");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getFloat to read a String");
            try {
                if (messageReceived.getFloat("myString") == Float.parseFloat(myString)) {
                    logger.log(System.Logger.Level.TRACE, "Pass: String to float ");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getDouble to read a String");
            try {
                if (messageReceived.getDouble("myString") == Double.parseDouble(myString)) {
                    logger.log(System.Logger.Level.TRACE, "Pass: String to double ");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getBoolean to read a string ");
            try {
                if (messageReceived.getBoolean("myString2") == Boolean.valueOf(myString2).booleanValue()) {
                    logger.log(System.Logger.Level.TRACE, "Pass: String to boolean ");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getBoolean to read a string that is not true");
            try {
                boolean b = messageReceived.getBoolean("myString");
                if (b) {
                    logger.log(System.Logger.Level.TRACE, "Fail: !true should have returned false");
                    pass = false;
                } else {
                    logger.log(System.Logger.Level.TRACE, "Pass: !true returned false");
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsBytes(MapMessage messageReceived) {
        String testCase = "mapMessageConversionQTestsBytes";
        try {
            byte[] byteValues = new byte[]{1, 2, 3};
            boolean pass = true;
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getBytes[] to read a byte[] ");
            try {
                byte[] b = messageReceived.getBytes("byteValues");
                for (int i = 0; i < b.length; ++i) {
                    if (b[i] != byteValues[i]) {
                        logger.log(System.Logger.Level.TRACE, "Fail: byte[] value returned is invalid");
                        pass = false;
                        continue;
                    }
                    logger.log(System.Logger.Level.TRACE, "Pass: byte[] returned is valid");
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getBoolean to read a byte[]");
            try {
                boolean b = messageReceived.getBoolean("byteValues");
                logger.log(System.Logger.Level.TRACE, "Fail: byte[] to boolean conversion should have thrown MessageFormatException");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getString to read a byte[]");
            try {
                String s = messageReceived.getString("byteValues");
                logger.log(System.Logger.Level.TRACE, "Fail: byte[] to boolean conversion should have thrown MessageFormatException");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getByte to read a byte[] - expect MessageFormatException");
            try {
                byte b = messageReceived.getByte("byteValues");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getShort to read a byte[] - expect MessageFormatException");
            try {
                short s = messageReceived.getShort("byteValues");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getChar to read a byte[] - expect MessageFormatException");
            try {
                char c = messageReceived.getChar("byteValues");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getInt to read a byte[] - expect MessageFormatException");
            try {
                int i = messageReceived.getInt("byteValues");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getLong to read a byte[] - expect MessageFormatException");
            try {
                long l = messageReceived.getLong("byteValues");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getFloat to read a byte[] - expect MessageFormatException");
            try {
                float f = messageReceived.getFloat("byteValues");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getDouble to read a byte[] - expect MessageFormatException");
            try {
                double d = messageReceived.getDouble("byteValues");
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsInvFormatString(MapMessage messageReceived) {
        String testCase = "mapMessageConversionQTestsInvFormatString";
        try {
            boolean pass = true;
            String myString = "mytest string";
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getByte to read a String that is not valid ");
            try {
                byte b = messageReceived.getByte("myString");
                logger.log(System.Logger.Level.TRACE, "Fail: java.lang.NumberFormatException expected");
                pass = false;
            }
            catch (NumberFormatException nf) {
                logger.log(System.Logger.Level.TRACE, "Pass: NumberFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getShort to read a string that is not valid ");
            try {
                short s = messageReceived.getShort("myString");
                logger.log(System.Logger.Level.TRACE, "Fail: NumberFormatException was expected");
                pass = false;
            }
            catch (NumberFormatException nf) {
                logger.log(System.Logger.Level.TRACE, "Pass: NumberFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getInt to read a String that is not valid ");
            try {
                int i = messageReceived.getInt("myString");
                logger.log(System.Logger.Level.TRACE, "Fail: NumberFormatException was expected");
                pass = false;
            }
            catch (NumberFormatException nf) {
                logger.log(System.Logger.Level.TRACE, "Pass: NumberFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getLong to read a String that is not valid ");
            try {
                long l = messageReceived.getLong("myString");
                logger.log(System.Logger.Level.TRACE, "Fail: NumberFormatException was expected");
                pass = false;
            }
            catch (NumberFormatException nf) {
                logger.log(System.Logger.Level.TRACE, "Pass: NumberFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getFloat to read a String that is not valid ");
            try {
                float f = messageReceived.getFloat("myString");
                logger.log(System.Logger.Level.TRACE, "Fail: NumberFormatException was expected");
                pass = false;
            }
            catch (NumberFormatException nf) {
                logger.log(System.Logger.Level.TRACE, "Pass: NumberFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use getDouble to read a String that is not valid ");
            try {
                double d = messageReceived.getDouble("myString");
                logger.log(System.Logger.Level.TRACE, "Fail: NumberFormatException was expected");
                pass = false;
            }
            catch (NumberFormatException nf) {
                logger.log(System.Logger.Level.TRACE, "Pass: NumberFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void sendTestResults(String testCase, boolean results) {
        TextMessage msg = null;
        try {
            this.mSender = this.qSession.createSender(this.queueR);
            msg = this.qSession.createTextMessage();
            msg.setStringProperty("TestCase", testCase);
            msg.setText(testCase);
            if (results) {
                msg.setStringProperty("Status", "Pass");
            } else {
                msg.setStringProperty("Status", "Fail");
            }
            logger.log(System.Logger.Level.TRACE, "Sending response message");
            logger.log(System.Logger.Level.TRACE, "==================================Test Results from: " + testCase);
            logger.log(System.Logger.Level.TRACE, "==================================Status: " + results);
            this.mSender.send((Message)msg);
        }
        catch (JMSException je) {
            TestUtil.printStackTrace((Throwable)je);
            logger.log(System.Logger.Level.TRACE, "Error: " + ((Object)((Object)je)).getClass().getName() + " was thrown");
        }
        catch (Exception ee) {
            TestUtil.printStackTrace((Throwable)ee);
            logger.log(System.Logger.Level.TRACE, "Error: " + ee.getClass().getName() + " was thrown");
        }
    }

    public void setMessageDrivenContext(MessageDrivenContext mdc) {
        logger.log(System.Logger.Level.TRACE, "jms.ee.mdb.mdb_msgTypesQ1  In MsgBean::setMessageDrivenContext()!!");
        this.mdc = mdc;
    }

    public void ejbRemove() {
        logger.log(System.Logger.Level.TRACE, "jms.ee.mdb.mdb_msgTypesQ1  In MsgBean::remove()!!");
    }
}

