/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.ejb.sessionTtests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.commonee.TestsT;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClientIT {
    private static final String testName = "com.sun.ts.tests.jms.ee.ejb.sessionTtests.ClientIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(ClientIT.class.getName());
    private transient Connection connr = null;
    @Resource(name="jms/DURABLE_SUB_CONNECTION_FACTORY")
    private static ConnectionFactory cf;
    @Resource(name="jms/MY_TOPIC")
    private static Topic testDestination;
    private String name = "ctssub";
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    @EJB(name="ejb/SessionTestsT")
    private static TestsT beanRef;

    @BeforeEach
    public void setup() throws Exception {
        try {
            if (beanRef == null) {
                throw new Exception("@EJB injection failed");
            }
            if (cf == null || testDestination == null) {
                throw new Exception("@Resource injection failed");
            }
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null ");
            }
            if (this.password == null) {
                throw new Exception("'password' is null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' is null");
            }
            beanRef.initLogging(this.props);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
    }

    @Test
    public void simpleSendReceiveT() throws Exception {
        String testMessage = "Just a test from simpleSendReceiveT";
        String messageReceived = null;
        try {
            this.connr = cf.createConnection(this.user, this.password);
            if (this.connr.getClientID() == null) {
                this.connr.setClientID("cts");
            }
            Session sessr = this.connr.createSession(true, 1);
            TopicSubscriber recr = sessr.createDurableSubscriber(testDestination, this.name);
            try {
                recr.close();
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception closing topic subscriber: ", (Throwable)e);
            }
            try {
                this.connr.close();
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception closing connection: ", (Throwable)e);
            }
            beanRef.sendTextMessage_CT(testName, testMessage);
            messageReceived = beanRef.receiveTextMessage_CT();
            if (messageReceived == null) {
                throw new Exception("Null message received!");
            }
            if (!messageReceived.equals(testMessage)) {
                throw new Exception("EJB didn't get the right message");
            }
            logger.log(System.Logger.Level.INFO, "Correct Message received");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("simpleSendReceiveT");
        }
        finally {
            try {
                this.connr = cf.createConnection(this.user, this.password);
                Session sessr = this.connr.createSession(true, 1);
                try {
                    sessr.unsubscribe(this.name);
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception unsubscribing: ", (Throwable)e);
                }
                try {
                    this.connr.close();
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception closing connection: ", (Throwable)e);
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception creating Connection: ", (Throwable)e);
            }
            try {
                if (null != beanRef) {
                    beanRef.remove();
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "[Client] Ignoring Exception on bean remove", (Throwable)e);
            }
        }
    }
}

