/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.ejb.queueCMTTests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import com.sun.ts.tests.jms.commonee.Tests;
import jakarta.ejb.EJB;
import jakarta.jms.Queue;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClientIT {
    private static final String testName = "com.sun.ts.tests.jms.ee.ejb.queueCMTTests.ClientIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final System.Logger logger = System.getLogger(ClientIT.class.getName());
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    @EJB(name="ejb/QueueTests")
    private static Tests beanRef;

    @BeforeEach
    public void setup() throws Exception {
        try {
            if (beanRef == null) {
                throw new Exception("@EJB injection failed");
            }
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null ");
            }
            if (this.password == null) {
                throw new Exception("'password' is null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' is null");
            }
            beanRef.initLogging(this.props);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
    }

    private void flushTheQueue() throws Exception {
        JmsTool tool = null;
        try {
            tool = new JmsTool(0, this.user, this.password, this.mode);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error creating JmsTool and closing Connection", (Throwable)e);
        }
        finally {
            try {
                tool.flushQueue();
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error flush : ", (Throwable)e);
            }
            try {
                logger.log(System.Logger.Level.TRACE, "Closing default QueueConnection");
                tool.getDefaultQueueConnection().close();
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error clsoing connection : ", (Throwable)e);
            }
        }
    }

    @Test
    public void bytesMessageFullMsgTests() throws Exception {
        try {
            beanRef.sendFullBytesMessage_Q(testName);
            if (!beanRef.verifyFullBytesMessage()) {
                throw new Exception("didn't get the right message");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught Exception in test bytesMessageFullMsgTests: ", (Throwable)e);
            throw new Exception("bytesMessageFullMsgTests", e);
        }
        finally {
            try {
                this.flushTheQueue();
                if (null != beanRef) {
                    beanRef.remove();
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "[Client] Ignoring Exception on bean remove", (Throwable)e);
            }
        }
    }

    @Test
    public void mapMessageFullMsgTest() throws Exception {
        try {
            beanRef.sendFullMapMessage_Q(testName);
            if (!beanRef.verifyFullMapMessage()) {
                throw new Exception("didn't get the right message");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught Exception in test mapMessageFullMsgTest: ", (Throwable)e);
            throw new Exception("mapMessageFullMsgTest", e);
        }
        finally {
            try {
                this.flushTheQueue();
                if (null != beanRef) {
                    beanRef.remove();
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "[Client] Ignoring Exception on bean remove", (Throwable)e);
            }
        }
    }

    @Test
    public void streamMessageFullMsgTest() throws Exception {
        try {
            beanRef.sendFullStreamMessage_Q(testName);
            if (!beanRef.verifyFullStreamMessage()) {
                throw new Exception("didn't get the right message");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught Exception in test streamMessageFullMsgTest: ", (Throwable)e);
            throw new Exception("streamMessageFullMsgTest", e);
        }
        finally {
            try {
                this.flushTheQueue();
                if (null != beanRef) {
                    beanRef.remove();
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "[Client] Ignoring Exception on bean remove", (Throwable)e);
            }
        }
    }

    @Test
    public void msgHdrIDTest() throws Exception {
        String id = null;
        boolean pass = true;
        try {
            beanRef.sendTextMessage_Q(testName);
            id = beanRef.getMessageID();
            if (!this.chkMessageID(id)) {
                logger.log(System.Logger.Level.ERROR, "TextMessage: JMSMessageID does not start with ID:" + id);
                pass = false;
            }
            beanRef.sendFullBytesMessage_Q(testName);
            id = beanRef.getMessageID();
            if (!this.chkMessageID(id)) {
                logger.log(System.Logger.Level.ERROR, "BytesMessage: JMSMessageID does not start with ID:" + id);
                pass = false;
            }
            beanRef.sendFullMapMessage_Q(testName);
            id = beanRef.getMessageID();
            if (!this.chkMessageID(id)) {
                logger.log(System.Logger.Level.ERROR, "MapMessage: JMSMessageID does not start with ID:" + id);
                pass = false;
            }
            beanRef.sendFullStreamMessage_Q(testName);
            id = beanRef.getMessageID();
            if (!this.chkMessageID(id)) {
                logger.log(System.Logger.Level.ERROR, "StreamMessage: JMSMessageID does not start with ID:" + id);
                pass = false;
            }
            beanRef.sendObjectMessage_Q(testName);
            id = beanRef.getMessageID();
            if (!this.chkMessageID(id)) {
                logger.log(System.Logger.Level.ERROR, "ObjectMessage: JMSMessageID does not start with ID:" + id);
                pass = false;
            }
            if (!pass) {
                throw new Exception("msgHdrIDTest failed with at least one type of JMS Message");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught Exception in test msgHdrIDTest: ", (Throwable)e);
            throw new Exception("msgHdrIDTest", e);
        }
        finally {
            try {
                this.flushTheQueue();
                if (null != beanRef) {
                    beanRef.remove();
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "[Client] Ignoring Exception on bean remove", (Throwable)e);
            }
        }
    }

    private boolean chkMessageID(String id) {
        boolean retcode = true;
        boolean index = false;
        if (id != null && !id.startsWith("ID:")) {
            retcode = false;
        }
        return retcode;
    }

    @Test
    public void msgHdrTimeStampTest() throws Exception {
        ArrayList sendValue = null;
        boolean pass = true;
        try {
            sendValue = beanRef.sendTextMessage_Q(testName);
            long JMSTimestamp = beanRef.getTimeStamp();
            if ((Long)sendValue.get(0) > JMSTimestamp || (Long)sendValue.get(1) < JMSTimestamp) {
                logger.log(System.Logger.Level.ERROR, "TextMessage: JMSMessageTimestamp return wrong value:" + JMSTimestamp);
                logger.log(System.Logger.Level.ERROR, "should be between time before send " + sendValue.get(0) + " and time after send " + sendValue.get(1));
                pass = false;
            }
            sendValue = beanRef.sendFullBytesMessage_Q(testName);
            JMSTimestamp = beanRef.getTimeStamp();
            if ((Long)sendValue.get(0) > JMSTimestamp || (Long)sendValue.get(1) < JMSTimestamp) {
                logger.log(System.Logger.Level.ERROR, "BytesMessage: JMSMessageTimestamp return wrong value:" + JMSTimestamp);
                logger.log(System.Logger.Level.ERROR, "should be between time before send " + sendValue.get(0) + " and time after send " + sendValue.get(1));
                pass = false;
            }
            sendValue = beanRef.sendFullMapMessage_Q(testName);
            JMSTimestamp = beanRef.getTimeStamp();
            if ((Long)sendValue.get(0) > JMSTimestamp || (Long)sendValue.get(1) < JMSTimestamp) {
                logger.log(System.Logger.Level.ERROR, "MapMessage: JMSMessageTimestamp return wrong value:" + JMSTimestamp);
                logger.log(System.Logger.Level.ERROR, "should be between time before send " + sendValue.get(0) + " and time after send " + sendValue.get(1));
                pass = false;
            }
            sendValue = beanRef.sendFullStreamMessage_Q(testName);
            JMSTimestamp = beanRef.getTimeStamp();
            if ((Long)sendValue.get(0) > JMSTimestamp || (Long)sendValue.get(1) < JMSTimestamp) {
                logger.log(System.Logger.Level.ERROR, "StreamMessage: JMSMessageTimestamp return wrong value: " + JMSTimestamp);
                logger.log(System.Logger.Level.ERROR, "should be between time before send " + sendValue.get(0) + " and time after send " + sendValue.get(1));
                pass = false;
            }
            sendValue = beanRef.sendObjectMessage_Q(testName);
            JMSTimestamp = beanRef.getTimeStamp();
            if ((Long)sendValue.get(0) > JMSTimestamp || (Long)sendValue.get(1) < JMSTimestamp) {
                logger.log(System.Logger.Level.ERROR, "ObjectMessage: JMSMessageTimestamp return wrong value: " + JMSTimestamp);
                logger.log(System.Logger.Level.ERROR, "should be between time before send " + sendValue.get(0) + " and time after send " + sendValue.get(1));
                pass = false;
            }
            if (!pass) {
                throw new Exception("msgHdrTimeStampTest failed with at least one type of JMS Message");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught Exception in test msgHdrTimeStampTest: ", (Throwable)e);
            throw new Exception("msgHdrTimeStampTest", e);
        }
        finally {
            try {
                this.flushTheQueue();
                if (null != beanRef) {
                    beanRef.remove();
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "[Client] Ignoring Exception on bean remove", (Throwable)e);
            }
        }
    }

    @Test
    public void msgHdrCorlIdTest() throws Exception {
        boolean pass = true;
        String jmsCorrelationID = "JMSTCKCorrelationID";
        try {
            beanRef.sendTextMessage_Q(testName);
            String tmp = beanRef.getCorrelationID();
            if (!tmp.equals(jmsCorrelationID)) {
                logger.log(System.Logger.Level.ERROR, "TextMessage: incorrect JMSCorrelationID returned: " + tmp);
                pass = false;
            }
            beanRef.sendFullBytesMessage_Q(testName);
            tmp = beanRef.getCorrelationID();
            if (!tmp.equals(jmsCorrelationID)) {
                logger.log(System.Logger.Level.ERROR, "BytesMessage: incorrect JMSCorrelationID returned: " + tmp);
                pass = false;
            }
            beanRef.sendFullMapMessage_Q(testName);
            tmp = beanRef.getCorrelationID();
            if (!tmp.equals(jmsCorrelationID)) {
                logger.log(System.Logger.Level.ERROR, "MapMessage: incorrect JMSCorrelationID returned:" + tmp);
                pass = false;
            }
            beanRef.sendFullStreamMessage_Q(testName);
            tmp = beanRef.getCorrelationID();
            if (!tmp.equals(jmsCorrelationID)) {
                logger.log(System.Logger.Level.ERROR, "StreamMessage: incorrect JMSCorrelationID returned:" + tmp);
                pass = false;
            }
            beanRef.sendObjectMessage_Q(testName);
            tmp = beanRef.getCorrelationID();
            if (!tmp.equals(jmsCorrelationID)) {
                logger.log(System.Logger.Level.ERROR, "ObjectMessage: incorrect JMSCorrelationID returned:" + tmp);
                pass = false;
            }
            if (!pass) {
                throw new Exception("msgHdrCorlIdTest failed with at least one type of JMS Message");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught Exception in test msgHdrCorlIdTest: ", (Throwable)e);
            throw new Exception("msgHdrCorlIdTest", e);
        }
        finally {
            try {
                this.flushTheQueue();
                if (null != beanRef) {
                    beanRef.remove();
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "[Client] Ignoring Exception on bean remove", (Throwable)e);
            }
        }
    }

    @Test
    public void msgHdrReplyToTest() throws Exception {
        boolean pass = true;
        String QueueName = null;
        String QueueName_used = null;
        try {
            beanRef.sendTextMessage_Q(testName);
            QueueName = beanRef.getReplyTo();
            if (QueueName != null) {
                logger.log(System.Logger.Level.ERROR, "TextMessage: null JMSReplyTo should be returned");
                pass = false;
            }
            beanRef.sendTextMessage_Q(testName, true);
            QueueName = beanRef.getReplyTo();
            QueueName_used = beanRef.getDestination_1();
            if (!QueueName.equals(QueueName_used)) {
                logger.log(System.Logger.Level.ERROR, "TextMessage: incorrect JMSReplyTo returned: " + QueueName);
                logger.log(System.Logger.Level.ERROR, "TextMessage: expecting: " + QueueName_used);
                pass = false;
            } else {
                logger.log(System.Logger.Level.TRACE, "TextMessage: passed");
            }
            beanRef.sendFullBytesMessage_Q(testName);
            QueueName = beanRef.getReplyTo();
            if (QueueName != null) {
                logger.log(System.Logger.Level.ERROR, "BytesMessage: null JMSReplyTo should be returned");
                pass = false;
            }
            beanRef.sendBytesMessage_Q(testName, true);
            QueueName = beanRef.getReplyTo();
            if (!QueueName.equals(QueueName_used)) {
                logger.log(System.Logger.Level.ERROR, "BytesMessage: incorrect JMSReplyTo returned:" + QueueName);
                logger.log(System.Logger.Level.ERROR, "BytesMessage: expecting: " + QueueName_used);
                pass = false;
            } else {
                logger.log(System.Logger.Level.TRACE, "BytesMessage: passed");
            }
            beanRef.sendFullMapMessage_Q(testName);
            QueueName = beanRef.getReplyTo();
            if (QueueName != null) {
                logger.log(System.Logger.Level.ERROR, "MapMessage: null JMSReplyTo should be returned:" + QueueName);
                pass = false;
            }
            beanRef.sendMapMessage_Q(testName, true);
            QueueName = beanRef.getReplyTo();
            if (!QueueName.equals(QueueName_used)) {
                logger.log(System.Logger.Level.ERROR, "MapMessage: incorrect JMSReplyTo returned: " + QueueName);
                logger.log(System.Logger.Level.ERROR, "MapMessage: expecting: " + QueueName_used);
                pass = false;
            } else {
                logger.log(System.Logger.Level.TRACE, "MapMessage: passed");
            }
            beanRef.sendFullStreamMessage_Q(testName);
            QueueName = beanRef.getReplyTo();
            if (QueueName != null) {
                logger.log(System.Logger.Level.ERROR, "StreamMessage: null JMSReplyTo should be returned: " + QueueName);
                pass = false;
            }
            beanRef.sendStreamMessage_Q(testName, true);
            QueueName = beanRef.getReplyTo();
            if (!QueueName.equals(QueueName_used)) {
                logger.log(System.Logger.Level.ERROR, "StreamMessage: incorrect JMSReplyTo returned: " + QueueName);
                logger.log(System.Logger.Level.ERROR, "StreamMessage: expecting: " + QueueName_used);
                pass = false;
            } else {
                logger.log(System.Logger.Level.TRACE, "StreamMessage: passed");
            }
            beanRef.sendObjectMessage_Q(testName);
            QueueName = beanRef.getReplyTo();
            if (QueueName != null) {
                logger.log(System.Logger.Level.ERROR, "ObjectMessage: null JMSReplyTo should be returned" + QueueName);
                pass = false;
            }
            beanRef.sendObjectMessage_Q(testName, true);
            QueueName = beanRef.getReplyTo();
            if (!QueueName.equals(QueueName_used)) {
                logger.log(System.Logger.Level.ERROR, "ObjectMessage: incorrect JMSReplyTo returned: " + QueueName);
                logger.log(System.Logger.Level.ERROR, "ObjectMessage: expecting: " + QueueName_used);
                pass = false;
            } else {
                logger.log(System.Logger.Level.TRACE, "ObjectMessage: passed");
            }
            if (!pass) {
                throw new Exception("msgHdrReplyToTest failed with at least one type of JMS Message");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught Exception in test msgHdrReplyToTest: ", (Throwable)e);
            throw new Exception("msgHdrReplyToTest", e);
        }
        finally {
            try {
                this.flushTheQueue();
                if (null != beanRef) {
                    beanRef.remove();
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "[Client] Ignoring Exception on bean remove", (Throwable)e);
            }
        }
    }

    @Test
    public void msgHdrJMSTypeTest() throws Exception {
        boolean pass = true;
        String type = "JMSTCKTESTMSG";
        try {
            beanRef.sendTextMessage_Q(testName);
            if (!beanRef.getType().equals(type)) {
                logger.log(System.Logger.Level.ERROR, "TextMessage: wrong JMSType returned: " + beanRef.getType());
                pass = false;
            }
            beanRef.sendFullBytesMessage_Q(testName);
            if (!beanRef.getType().equals(type)) {
                logger.log(System.Logger.Level.ERROR, "BytesMessage: wrong JMSType returned");
                pass = false;
            }
            beanRef.sendFullMapMessage_Q(testName);
            if (!beanRef.getType().equals(type)) {
                logger.log(System.Logger.Level.ERROR, "MapMessage: wrong JMSType returned");
                pass = false;
            }
            beanRef.sendFullStreamMessage_Q(testName);
            if (!beanRef.getType().equals(type)) {
                logger.log(System.Logger.Level.ERROR, "StreamMessage: wrong JMSType returned" + beanRef.getType());
                pass = false;
            }
            beanRef.sendObjectMessage_Q(testName);
            if (!beanRef.getType().equals(type)) {
                logger.log(System.Logger.Level.ERROR, "ObjectMessage: wrong JMSType returned" + beanRef.getType());
                pass = false;
            }
            if (!pass) {
                throw new Exception("msgHdrJMSTypeTest failed with at least one type of JMS Message");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught Exception in test msgHdrJMSTypeTest: ", (Throwable)e);
            throw new Exception("msgHdrJMSTypeTest", e);
        }
        finally {
            try {
                this.flushTheQueue();
                if (null != beanRef) {
                    beanRef.remove();
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "[Client] Ignoring Exception on bean remove", (Throwable)e);
            }
        }
    }

    @Test
    public void msgHdrJMSPriorityTest() throws Exception {
        boolean pass = true;
        int priority = 2;
        try {
            beanRef.sendTextMessage_Q(testName);
            if (beanRef.getPriority() != priority) {
                logger.log(System.Logger.Level.ERROR, "TextMessage: wrong JMSPriority returned: " + beanRef.getPriority());
                pass = false;
            }
            beanRef.sendFullBytesMessage_Q(testName);
            if (beanRef.getPriority() != priority) {
                logger.log(System.Logger.Level.ERROR, "BytesMessage: wrong JMSPriority returned: " + beanRef.getPriority());
                pass = false;
            }
            beanRef.sendFullMapMessage_Q(testName);
            if (beanRef.getPriority() != priority) {
                logger.log(System.Logger.Level.ERROR, "MapMessage: wrong JMSPriority returned: " + beanRef.getPriority());
                pass = false;
            }
            beanRef.sendFullStreamMessage_Q(testName);
            if (beanRef.getPriority() != priority) {
                logger.log(System.Logger.Level.ERROR, "StreamMessage: wrong JMSPriority returned: " + beanRef.getPriority());
                pass = false;
            }
            beanRef.sendObjectMessage_Q(testName);
            if (beanRef.getPriority() != priority) {
                logger.log(System.Logger.Level.ERROR, "ObjectMessage: wrong JMSPriority returned: " + beanRef.getPriority());
                pass = false;
            }
            if (!pass) {
                throw new Exception("msgHdrJMSPriorityTest failed with at least one type of JMS Message");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught Exception in test msgHdrJMSPriorityTest: ", (Throwable)e);
            throw new Exception("msgHdrJMSPriorityTest", e);
        }
        finally {
            try {
                this.flushTheQueue();
                if (null != beanRef) {
                    beanRef.remove();
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "[Client] Ignoring Exception on bean remove", (Throwable)e);
            }
        }
    }

    @Test
    public void msgHdrJMSExpirationTest() throws Exception {
        boolean pass = true;
        long forever = 0L;
        try {
            beanRef.sendTextMessage_Q(testName);
            if (beanRef.getExpiration() != forever) {
                logger.log(System.Logger.Level.ERROR, "TextMessage: wrong JMSExpiration returned: " + beanRef.getExpiration());
                pass = false;
            }
            beanRef.sendFullBytesMessage_Q(testName);
            if (beanRef.getExpiration() != forever) {
                logger.log(System.Logger.Level.ERROR, "BytesMessage: wrong JMSExpiration returned: " + beanRef.getExpiration());
                pass = false;
            }
            beanRef.sendFullMapMessage_Q(testName);
            if (beanRef.getExpiration() != forever) {
                logger.log(System.Logger.Level.ERROR, "MapMessage: wrong JMSExpiration returned: " + beanRef.getExpiration());
                pass = false;
            }
            beanRef.sendFullStreamMessage_Q(testName);
            if (beanRef.getExpiration() != forever) {
                logger.log(System.Logger.Level.ERROR, "StreamMessage: wrong JMSExpiration returned: " + beanRef.getExpiration());
                pass = false;
            }
            beanRef.sendObjectMessage_Q(testName);
            if (beanRef.getExpiration() != forever) {
                logger.log(System.Logger.Level.ERROR, "ObjectMessage: wrong JMSExpiration returned: " + beanRef.getExpiration());
                pass = false;
            }
            if (!pass) {
                throw new Exception("msgHdrJMSExpirationTest failed with at least one type of JMS Message");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught Exception in test msgHdrJMSExpirationTest: ", (Throwable)e);
            throw new Exception("msgHdrJMSExpirationTest");
        }
        finally {
            try {
                this.flushTheQueue();
                if (null != beanRef) {
                    beanRef.remove();
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "[Client] Ignoring Exception on bean remove", (Throwable)e);
            }
        }
    }

    @Test
    public void msgHdrJMSDestinationTest() throws Exception {
        boolean pass = true;
        long forever = 0L;
        String dest = null;
        String dest_used = null;
        try {
            beanRef.sendTextMessage_Q(testName);
            dest = beanRef.getDestination();
            dest_used = beanRef.getDestination_1();
            if (!dest.equals(dest_used)) {
                logger.log(System.Logger.Level.ERROR, "TextMessage: wrong JMSDestination returned: " + dest);
                logger.log(System.Logger.Level.ERROR, "Expecting " + dest_used);
                pass = false;
            } else {
                logger.log(System.Logger.Level.TRACE, "TextMessage: msgHdrJMSDestinationTest passed.");
            }
            beanRef.sendFullBytesMessage_Q(testName);
            if (!beanRef.getDestination().equals(dest_used)) {
                logger.log(System.Logger.Level.ERROR, "BytesMessage: wrong JMSDestination returned: " + dest);
                logger.log(System.Logger.Level.ERROR, "Expecting " + dest_used);
                pass = false;
            } else {
                logger.log(System.Logger.Level.TRACE, "BytesMessage: msgHdrJMSDestinationTest passed.");
            }
            beanRef.sendFullMapMessage_Q(testName);
            if (!beanRef.getDestination().equals(dest_used)) {
                logger.log(System.Logger.Level.ERROR, "MapMessage: wrong JMSDestination returned: " + dest);
                logger.log(System.Logger.Level.ERROR, "Expecting " + dest_used);
                pass = false;
            } else {
                logger.log(System.Logger.Level.TRACE, "MapMessage: msgHdrJMSDestinationTest passed.");
            }
            beanRef.sendFullStreamMessage_Q(testName);
            if (!beanRef.getDestination().equals(dest_used)) {
                logger.log(System.Logger.Level.ERROR, "StreamMessage: wrong JMSDestination returned: " + dest);
                logger.log(System.Logger.Level.ERROR, "Expecting " + dest_used);
                pass = false;
            } else {
                logger.log(System.Logger.Level.TRACE, "StreamMessage: msgHdrJMSDestinationTest passed.");
            }
            beanRef.sendObjectMessage_Q(testName);
            if (!beanRef.getDestination().equals(dest_used)) {
                logger.log(System.Logger.Level.ERROR, "ObjectMessage: wrong JMSDestination returned: " + dest);
                logger.log(System.Logger.Level.ERROR, "Expecting " + dest_used);
                pass = false;
            } else {
                logger.log(System.Logger.Level.TRACE, "ObjectMessage: msgHdrJMSDestinationTest passed.");
            }
            if (!pass) {
                throw new Exception("msgHdrJMSDestinationTest failed with at least one type of JMS Message");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught Exception in test msgHdrJMSDestinationTest: ", (Throwable)e);
            throw new Exception("msgHdrJMSDestinationTest", e);
        }
        finally {
            try {
                this.flushTheQueue();
                if (null != beanRef) {
                    beanRef.remove();
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "[Client] Ignoring Exception on bean remove", (Throwable)e);
            }
        }
    }

    @Test
    public void msgHdrJMSDeliveryModeTest() throws Exception {
        boolean pass = true;
        long forever = 0L;
        try {
            beanRef.sendTextMessage_Q(testName);
            if (beanRef.getDeliveryMode() != 2) {
                logger.log(System.Logger.Level.ERROR, "TextMessage: wrong DeliveryMode returned: " + beanRef.getDeliveryMode());
                pass = false;
            }
            beanRef.sendTextMessage_Q(testName, false, 1);
            if (beanRef.getDeliveryMode() != 1) {
                logger.log(System.Logger.Level.ERROR, "TextMessage: wrong DeliveryMode returned: " + beanRef.getDeliveryMode());
                pass = false;
            }
            beanRef.sendFullBytesMessage_Q(testName);
            if (beanRef.getDeliveryMode() != 2) {
                logger.log(System.Logger.Level.ERROR, "BytesMessage: wrong DeliveryMode returned: ");
                pass = false;
            }
            beanRef.sendBytesMessage_Q(testName, false, 1);
            if (beanRef.getDeliveryMode() != 1) {
                logger.log(System.Logger.Level.ERROR, "BytesMessage: wrong DeliveryMode returned: ");
                pass = false;
            }
            beanRef.sendFullMapMessage_Q(testName);
            if (beanRef.getDeliveryMode() != 2) {
                logger.log(System.Logger.Level.ERROR, "MapMessage: wrong DeliveryMode returned: ");
                pass = false;
            }
            beanRef.sendMapMessage_Q(testName, false, 1);
            if (beanRef.getDeliveryMode() != 1) {
                logger.log(System.Logger.Level.ERROR, "MapMessage: wrong DeliveryMode returned: ");
                pass = false;
            }
            beanRef.sendFullStreamMessage_Q(testName);
            if (beanRef.getDeliveryMode() != 2) {
                logger.log(System.Logger.Level.ERROR, "StreamMessage: wrong DeliveryMode returned: ");
                pass = false;
            }
            beanRef.sendStreamMessage_Q(testName, false, 1);
            if (beanRef.getDeliveryMode() != 1) {
                logger.log(System.Logger.Level.ERROR, "StreamMessage: wrong DeliveryMode returned: ");
                pass = false;
            }
            beanRef.sendObjectMessage_Q(testName);
            if (beanRef.getDeliveryMode() != 2) {
                logger.log(System.Logger.Level.ERROR, "ObjectMessage: wrong DeliveryMode returned: ");
                pass = false;
            }
            beanRef.sendObjectMessage_Q(testName, false, 1);
            if (beanRef.getDeliveryMode() != 1) {
                logger.log(System.Logger.Level.ERROR, "ObjectMessage: wrong DeliveryMode returned: ");
                pass = false;
            }
            if (!pass) {
                throw new Exception("msgHdrJMSDeliveryModeTest failed with at least one type of JMS Message");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught Exception in test msgHdrJMSDeliveryModeTest: ", (Throwable)e);
            throw new Exception("msgHdrJMSDeliveryModeTest", e);
        }
        finally {
            try {
                this.flushTheQueue();
                if (null != beanRef) {
                    beanRef.remove();
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "[Client] Ignoring Exception on bean remove", (Throwable)e);
            }
        }
    }

    @Test
    public void messageOrderTest() throws Exception {
        int numMessages = 3;
        String[] text = new String[numMessages];
        try {
            int i;
            for (i = 0; i < numMessages; ++i) {
                text[i] = "message order test " + i;
                beanRef.sendTextMessage_Q(testName + i, text[i]);
            }
            for (i = 0; i < numMessages; ++i) {
                if (beanRef.getText().equals(text[i])) continue;
                logger.log(System.Logger.Level.ERROR, "Received message: ");
                throw new Exception("received wrong message");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught Exception in test messageOrderTest: ", (Throwable)e);
            throw new Exception("messageOrderTest", e);
        }
        finally {
            try {
                this.flushTheQueue();
                if (null != beanRef) {
                    beanRef.remove();
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "[Client] Ignoring Exception on bean remove", (Throwable)e);
            }
        }
    }

    @Test
    public void nullDestinationTest() throws Exception {
        String text = "JMS TCK test for null Destination";
        Queue testQueue = null;
        try {
            beanRef.sendTextMessage_Q(testName, text, testQueue);
            if (!beanRef.getText().equals(text)) {
                throw new Exception("received wrong message");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught Exception in test nullDestinationTest: ", (Throwable)e);
            throw new Exception("nullDestinationTest", e);
        }
        finally {
            try {
                this.flushTheQueue();
                if (null != beanRef) {
                    beanRef.remove();
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "[Client] Ignoring Exception on bean remove", (Throwable)e);
            }
        }
    }
}

