/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core20.connectionfactorytests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.JMSSecurityException;
import jakarta.jms.JMSSecurityRuntimeException;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicConnectionFactory;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClientIT {
    private static final String testName = "com.sun.ts.tests.jms.core20.connectionfactorytests.ClientIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(ClientIT.class.getName());
    private transient JmsTool tool = null;
    private transient ConnectionFactory cf = null;
    private transient QueueConnectionFactory qcf = null;
    private transient TopicConnectionFactory tcf = null;
    private transient JMSContext context = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList connections = null;
    String vehicle = null;

    private String printSessionMode(int sessionMode) {
        switch (sessionMode) {
            case 0: {
                return "SESSION_TRANSACTED";
            }
            case 1: {
                return "AUTO_ACKNOWLEDGE";
            }
            case 2: {
                return "CLIENT_ACKNOWLEDGE";
            }
            case 3: {
                return "DUPS_OK_ACKNOWLEDGE";
            }
        }
        return "UNEXPECTED_SESSIONMODE";
    }

    @BeforeEach
    public void setup() throws Exception {
        try {
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null ");
            }
            if (this.password == null) {
                throw new Exception("'password' is null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' is null");
            }
            this.connections = new ArrayList(5);
            this.vehicle = System.getProperty("vehicle");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
    }

    @Test
    public void qcfCreateJMSContextTest1() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "Setup JmsTool for QUEUE_FACTORY");
            this.tool = new JmsTool(7, this.user, this.password, this.mode);
            this.qcf = this.tool.getQueueConnectionFactory();
            logger.log(System.Logger.Level.INFO, "Test QueueConnectionFactory.createContext()");
            this.context = this.qcf.createContext();
            logger.log(System.Logger.Level.INFO, "Verify that JMSContext.getSessionMode() returns JMSContext.AUTO_ACKNOWLEDGE");
            int expSessionMode = 1;
            int actSessionMode = this.context.getSessionMode();
            if (actSessionMode != expSessionMode) {
                logger.log(System.Logger.Level.ERROR, "getSessionMode() returned " + this.printSessionMode(actSessionMode) + ", expected " + this.printSessionMode(expSessionMode));
                pass = false;
            }
            this.context.close();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("qcfCreateJMSContextTest1");
        }
        if (!pass) {
            throw new Exception("qcfCreateJMSContextTest1 failed");
        }
    }

    @Test
    public void qcfCreateJMSContextTest3() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "Setup JmsTool for QUEUE_FACTORY");
            this.tool = new JmsTool(7, this.user, this.password, this.mode);
            this.qcf = this.tool.getQueueConnectionFactory();
            logger.log(System.Logger.Level.INFO, "Test QueueConnectionFactory.createContext(String, String)");
            this.context = this.qcf.createContext(this.user, this.password);
            logger.log(System.Logger.Level.INFO, "Verify that JMSContext.getSessionMode() returns JMSContext.AUTO_ACKNOWLEDGE");
            int expSessionMode = 1;
            int actSessionMode = this.context.getSessionMode();
            if (actSessionMode != expSessionMode) {
                logger.log(System.Logger.Level.ERROR, "getSessionMode() returned " + this.printSessionMode(actSessionMode) + ", expected " + this.printSessionMode(expSessionMode));
                pass = false;
            }
            this.context.close();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("qcfCreateJMSContextTest3");
        }
        if (!pass) {
            throw new Exception("qcfCreateJMSContextTest3 failed");
        }
    }

    @Test
    public void qcfCreateConnectionTest() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "Setup JmsTool for QUEUE_FACTORY");
            this.tool = new JmsTool(7, this.user, this.password, this.mode);
            this.qcf = this.tool.getQueueConnectionFactory();
            logger.log(System.Logger.Level.INFO, "Test QueueConnectionFactory.createQueueConnection()");
            QueueConnection qc = this.qcf.createQueueConnection();
            qc.close();
            logger.log(System.Logger.Level.INFO, "Test QueueConnectionFactory.createQueueConnection(String, String) with valid credentials");
            qc = this.qcf.createQueueConnection(this.user, this.password);
            qc.close();
            logger.log(System.Logger.Level.INFO, "Test QueueConnectionFactory.createConnection()");
            Connection c = this.qcf.createConnection();
            c.close();
            logger.log(System.Logger.Level.INFO, "Test QueueConnectionFactory.createConnection(String, String) with valid credentials");
            c = this.qcf.createConnection(this.user, this.password);
            c.close();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("qcfCreateConnectionTest");
        }
        if (!pass) {
            throw new Exception("qcfCreateConnectionTest failed");
        }
    }

    @Test
    public void tcfCreateJMSContextTest1() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "Setup JmsTool for TOPIC_FACTORY");
            this.tool = new JmsTool(8, this.user, this.password, this.mode);
            this.tcf = this.tool.getTopicConnectionFactory();
            logger.log(System.Logger.Level.INFO, "Test TopicConnectionFactory.createContext()");
            this.context = this.tcf.createContext();
            logger.log(System.Logger.Level.INFO, "Verify that JMSContext.getSessionMode() returns JMSContext.AUTO_ACKNOWLEDGE");
            int expSessionMode = 1;
            int actSessionMode = this.context.getSessionMode();
            if (actSessionMode != expSessionMode) {
                logger.log(System.Logger.Level.ERROR, "getSessionMode() returned " + this.printSessionMode(actSessionMode) + ", expected " + this.printSessionMode(expSessionMode));
                pass = false;
            }
            this.context.close();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("tcfCreateJMSContextTest1");
        }
        if (!pass) {
            throw new Exception("tcfCreateJMSContextTest1 failed");
        }
    }

    @Test
    public void tcfCreateJMSContextTest3() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "Setup JmsTool for TOPIC_FACTORY");
            this.tool = new JmsTool(8, this.user, this.password, this.mode);
            this.tcf = this.tool.getTopicConnectionFactory();
            logger.log(System.Logger.Level.INFO, "Test TopicConnectionFactory.createContext(String, String)");
            this.context = this.tcf.createContext(this.user, this.password);
            logger.log(System.Logger.Level.INFO, "Verify that JMSContext.getSessionMode() returns JMSContext.AUTO_ACKNOWLEDGE");
            int expSessionMode = 1;
            int actSessionMode = this.context.getSessionMode();
            if (actSessionMode != expSessionMode) {
                logger.log(System.Logger.Level.ERROR, "getSessionMode() returned " + this.printSessionMode(actSessionMode) + ", expected " + this.printSessionMode(expSessionMode));
                pass = false;
            }
            this.context.close();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("tcfCreateJMSContextTest3");
        }
        if (!pass) {
            throw new Exception("tcfCreateJMSContextTest3 failed");
        }
    }

    @Test
    public void tcfCreateConnectionTest() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "Setup JmsTool for TOPIC_FACTORY");
            this.tool = new JmsTool(8, this.user, this.password, this.mode);
            this.tcf = this.tool.getTopicConnectionFactory();
            logger.log(System.Logger.Level.INFO, "Test TopicConnectionFactory.createTopicConnection()");
            TopicConnection tc = this.tcf.createTopicConnection();
            tc.close();
            logger.log(System.Logger.Level.INFO, "Test TopicConnectionFactory.createTopicConnection(String, String) with valid credentials");
            tc = this.tcf.createTopicConnection(this.user, this.password);
            tc.close();
            logger.log(System.Logger.Level.INFO, "Test TopicConnectionFactory.createConnection()");
            Connection c = this.tcf.createConnection();
            c.close();
            logger.log(System.Logger.Level.INFO, "Test TopicConnectionFactory.createConnection(String, String) with valid credentials");
            c = this.tcf.createConnection(this.user, this.password);
            c.close();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("tcfCreateConnectionTest");
        }
        if (!pass) {
            throw new Exception("tcfCreateConnectionTest failed");
        }
    }

    @Test
    public void createConnectionExceptionTests() throws Exception {
        QueueConnection c;
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "Setup JmsTool for QUEUE_FACTORY");
            this.tool = new JmsTool(7, this.user, this.password, this.mode);
            this.qcf = this.tool.getQueueConnectionFactory();
            logger.log(System.Logger.Level.INFO, "Test QueueConnectionFactory.createQueueConnection(String, String) with invalid credentials");
            logger.log(System.Logger.Level.INFO, "Verify JMSSecurityException is thrown");
            c = this.qcf.createQueueConnection("invalid", "invalid");
            logger.log(System.Logger.Level.ERROR, "Didn't throw expected JMSSecurityException");
            pass = false;
            c.close();
        }
        catch (JMSSecurityException e) {
            logger.log(System.Logger.Level.INFO, "Caught expected JMSSecurityException");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Expected JMSSecurityException, received " + e);
            pass = false;
        }
        try {
            logger.log(System.Logger.Level.INFO, "Setup JmsTool for TOPIC_FACTORY");
            this.tool = new JmsTool(8, this.user, this.password, this.mode);
            this.tcf = this.tool.getTopicConnectionFactory();
            logger.log(System.Logger.Level.INFO, "Test TopicConnectionFactory.createTopicConnection(String, String) with invalid credentials");
            logger.log(System.Logger.Level.INFO, "Verify JMSSecurityException is thrown");
            c = this.tcf.createTopicConnection("invalid", "invalid");
            logger.log(System.Logger.Level.ERROR, "Didn't throw expected JMSSecurityException");
            pass = false;
            c.close();
        }
        catch (JMSSecurityException e) {
            logger.log(System.Logger.Level.INFO, "Caught expected JMSSecurityException");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("createConnectionExceptionTests failed");
        }
    }

    @Test
    public void createJMSContextExceptionTests() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "Setup JmsTool for QUEUE_FACTORY");
            this.tool = new JmsTool(7, this.user, this.password, this.mode);
            this.qcf = this.tool.getQueueConnectionFactory();
            logger.log(System.Logger.Level.INFO, "Test QueueConnectionFactory.createContext(String, String) with bad credentials");
            logger.log(System.Logger.Level.INFO, "Verify JMSRuntimeSecurityException is thrown");
            try {
                this.context = this.qcf.createContext("invalid", "invalid");
                logger.log(System.Logger.Level.ERROR, "Didn't throw expected JMSSecurityRuntimeException");
                pass = false;
                this.context.close();
            }
            catch (JMSSecurityRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected JMSRuntimeSecurityException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected JMSSecurityRuntimeException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Test QueueConnectionFactory.createContext(int) with bad session mode");
            logger.log(System.Logger.Level.INFO, "Verify JMSRuntimeException is thrown");
            try {
                this.context = this.qcf.createContext(-1);
                logger.log(System.Logger.Level.ERROR, "Didn't throw expected JMSRuntimeException");
                pass = false;
                this.context.close();
            }
            catch (JMSRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected JMSRuntimeException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected JMSRuntimeException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Setup JmsTool for TOPIC_FACTORY");
            this.tool = new JmsTool(8, this.user, this.password, this.mode);
            this.tcf = this.tool.getTopicConnectionFactory();
            logger.log(System.Logger.Level.INFO, "Test TopicConnectionFactory.createContext(String, String) with bad credentials");
            logger.log(System.Logger.Level.INFO, "Verify JMSSecurityRuntimeException is thrown");
            try {
                this.context = this.tcf.createContext("invalid", "invalid");
                logger.log(System.Logger.Level.ERROR, "Didn't throw expected JMSSecurityRuntimeException");
                pass = false;
                this.context.close();
            }
            catch (JMSSecurityRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected JMSRuntimeSecurityException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Test TopicConnectionFactory.createContext(int) with bad session mode");
            logger.log(System.Logger.Level.INFO, "Verify JMSRuntimeException is thrown");
            try {
                this.context = this.tcf.createContext(-1);
                logger.log(System.Logger.Level.ERROR, "Didn't throw expected JMSRuntimeException");
                pass = false;
                this.context.close();
            }
            catch (JMSRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected JMSRuntimeException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("createJMSContextExceptionTests");
        }
        if (!pass) {
            throw new Exception("createJMSContextExceptionTests failed");
        }
    }
}

