/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core20.appclient.messageproducertests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.InvalidTextMessageTestImpl;
import com.sun.ts.tests.jms.common.JmsTool;
import com.sun.ts.tests.jms.core20.appclient.messageproducertests.MyCompletionListener;
import jakarta.jms.CompletionListener;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClientIT {
    private static final String testName = "com.sun.ts.tests.jms.core20.messageproducertests.ClientIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(ClientIT.class.getName());
    private transient JmsTool tool = null;
    private transient JmsTool toolForProducer = null;
    transient MessageProducer producer = null;
    transient MessageConsumer consumer = null;
    transient Connection connection = null;
    transient Session session = null;
    transient Destination destination = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    private static final int numMessages = 3;
    private static final int iterations = 5;
    boolean queueTest = false;

    private void checkExceptionPass(boolean passed) throws Exception {
        if (!passed) {
            logger.log(System.Logger.Level.INFO, "Didn't get expected exception");
            throw new Exception("Didn't get expected exception");
        }
    }

    @BeforeEach
    public void setup() throws Exception {
        try {
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null ");
            }
            if (this.password == null) {
                throw new Exception("'password' is null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' is null");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.INFO, "Closing default Connection");
            this.tool.getDefaultConnection().close();
            if (this.queueTest) {
                logger.log(System.Logger.Level.INFO, "Flush any messages left on Queue");
                this.tool.flushDestination();
            }
            this.tool.closeAllResources();
            if (this.toolForProducer != null) {
                this.toolForProducer.getDefaultConnection().close();
                if (this.queueTest) {
                    logger.log(System.Logger.Level.INFO, "Flush any messages left on Queue");
                    this.toolForProducer.flushDestination();
                }
                this.toolForProducer.closeAllResources();
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("cleanup failed!", e);
        }
    }

    @Test
    public void queueSendRecvCompletionListenerTest1() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.tool.getDefaultProducer().close();
            this.producer = this.tool.getDefaultSession().createProducer((Destination)((Queue)null));
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = true;
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueSendRecvCompletionListenerTest1");
            MyCompletionListener listener = new MyCompletionListener();
            logger.log(System.Logger.Level.INFO, "Calling send(Destination,Message,CompletionListener)");
            this.producer.send(this.destination, (Message)expTextMessage, (CompletionListener)listener);
            logger.log(System.Logger.Level.INFO, "Poll listener waiting for TestMessage to arrive");
            TextMessage actTextMessage = null;
            for (int i = 0; !listener.isComplete() && i < 60; ++i) {
                logger.log(System.Logger.Level.INFO, "Loop " + i + ": sleep 2 seconds waiting for messages to arrive at listener");
                TestUtil.sleepSec((int)2);
            }
            if (listener.isComplete()) {
                actTextMessage = (TextMessage)listener.getMessage();
            }
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("queueSendRecvCompletionListenerTest1", e);
        }
        finally {
            try {
                this.producer.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("queueSendRecvCompletionListenerTest1 failed");
        }
    }

    @Test
    public void queueSendRecvCompletionListenerTest2() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.tool.getDefaultProducer().close();
            this.producer = this.tool.getDefaultSession().createProducer((Destination)((Queue)null));
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = true;
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueSendRecvCompletionListenerTest2");
            MyCompletionListener listener = new MyCompletionListener();
            logger.log(System.Logger.Level.INFO, "Calling send(Destination,Message,int,int,long,CompletionListener)");
            this.producer.send(this.destination, (Message)expTextMessage, 1, 4, 0L, (CompletionListener)listener);
            logger.log(System.Logger.Level.INFO, "Poll listener waiting for TestMessage to arrive");
            TextMessage actTextMessage = null;
            for (int i = 0; !listener.isComplete() && i < 60; ++i) {
                logger.log(System.Logger.Level.INFO, "Loop " + i + ": sleep 2 seconds waiting for messages to arrive at listener");
                TestUtil.sleepSec((int)2);
            }
            if (listener.isComplete()) {
                actTextMessage = (TextMessage)listener.getMessage();
            }
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the values in TextMessage, deliverymode, priority, time to live");
            if (!actTextMessage.getText().equals(expTextMessage.getText()) || actTextMessage.getJMSDeliveryMode() != 1 || actTextMessage.getJMSPriority() != 4 || actTextMessage.getJMSExpiration() != 0L) {
                logger.log(System.Logger.Level.ERROR, "Didn't get the right message.");
                logger.log(System.Logger.Level.ERROR, "text=" + actTextMessage.getText() + ", expected " + expTextMessage.getText());
                logger.log(System.Logger.Level.ERROR, "DeliveryMode=" + actTextMessage.getJMSDeliveryMode() + ", expected " + expTextMessage.getJMSDeliveryMode());
                logger.log(System.Logger.Level.ERROR, "Priority=" + actTextMessage.getJMSPriority() + ", expected " + expTextMessage.getJMSPriority());
                logger.log(System.Logger.Level.ERROR, "TimeToLive=" + actTextMessage.getJMSExpiration() + ", expected " + expTextMessage.getJMSExpiration());
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("queueSendRecvCompletionListenerTest2", e);
        }
        finally {
            try {
                this.producer.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("queueSendRecvCompletionListenerTest2 failed");
        }
    }

    @Test
    public void queueSendRecvCompletionListenerTest3() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = true;
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueSendRecvCompletionListenerTest3");
            MyCompletionListener listener = new MyCompletionListener();
            logger.log(System.Logger.Level.INFO, "Calling send(Message,CompletionListener)");
            this.producer.send((Message)expTextMessage, (CompletionListener)listener);
            logger.log(System.Logger.Level.INFO, "Poll listener waiting for TestMessage to arrive");
            TextMessage actTextMessage = null;
            for (int i = 0; !listener.isComplete() && i < 60; ++i) {
                logger.log(System.Logger.Level.INFO, "Loop " + i + ": sleep 2 seconds waiting for messages to arrive at listener");
                TestUtil.sleepSec((int)2);
            }
            if (listener.isComplete()) {
                actTextMessage = (TextMessage)listener.getMessage();
            }
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("queueSendRecvCompletionListenerTest3", e);
        }
        if (!pass) {
            throw new Exception("queueSendRecvCompletionListenerTest3 failed");
        }
    }

    @Test
    public void queueSendRecvCompletionListenerTest4() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = true;
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueSendRecvCompletionListeneTest4");
            MyCompletionListener listener = new MyCompletionListener();
            logger.log(System.Logger.Level.INFO, "Calling send(Message,int,int,long,CompletionListener)");
            this.producer.send((Message)expTextMessage, 2, 4, 0L, (CompletionListener)listener);
            logger.log(System.Logger.Level.INFO, "Poll listener waiting for TestMessage to arrive");
            TextMessage actTextMessage = null;
            for (int i = 0; !listener.isComplete() && i < 60; ++i) {
                logger.log(System.Logger.Level.INFO, "Loop " + i + ": sleep 2 seconds waiting for messages to arrive at listener");
                TestUtil.sleepSec((int)2);
            }
            if (listener.isComplete()) {
                actTextMessage = (TextMessage)listener.getMessage();
            }
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the values in TextMessage, deliverymode, priority, time to live");
            if (!actTextMessage.getText().equals(expTextMessage.getText()) || actTextMessage.getJMSDeliveryMode() != 2 || actTextMessage.getJMSPriority() != 4 || actTextMessage.getJMSExpiration() != 0L) {
                logger.log(System.Logger.Level.ERROR, "Didn't get the right message.");
                logger.log(System.Logger.Level.ERROR, "text=" + actTextMessage.getText() + ", expected " + expTextMessage.getText());
                logger.log(System.Logger.Level.ERROR, "DeliveryMode=" + actTextMessage.getJMSDeliveryMode() + ", expected " + expTextMessage.getJMSDeliveryMode());
                logger.log(System.Logger.Level.ERROR, "Priority=" + actTextMessage.getJMSPriority() + ", expected " + expTextMessage.getJMSPriority());
                logger.log(System.Logger.Level.ERROR, "TimeToLive=" + actTextMessage.getJMSExpiration() + ", expected " + expTextMessage.getJMSExpiration());
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("queueSendRecvCompletionListenerTest4", e);
        }
        if (!pass) {
            throw new Exception("queueSendRecvCompletionListenerTest4 failed");
        }
    }

    @Test
    public void queueJMSExceptionTests() throws Exception {
        boolean pass;
        block19: {
            pass = true;
            Object tempMsg = null;
            String message = "Where are you!";
            try {
                int i;
                Exception exception;
                logger.log(System.Logger.Level.INFO, "Setup JmsTool for COMMON QUEUE");
                this.tool = new JmsTool(13, this.user, this.password, this.mode);
                this.tool.getDefaultProducer().close();
                this.producer = this.tool.getDefaultSession().createProducer((Destination)((Queue)null));
                this.consumer = this.tool.getDefaultConsumer();
                this.connection = this.tool.getDefaultConnection();
                this.session = this.tool.getDefaultSession();
                this.destination = this.tool.getDefaultDestination();
                this.connection.start();
                this.queueTest = true;
                logger.log(System.Logger.Level.INFO, "Creating TextMessage");
                TextMessage expTextMessage = this.session.createTextMessage(message);
                logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueJMSExceptionTests");
                MyCompletionListener listener = new MyCompletionListener();
                try {
                    logger.log(System.Logger.Level.INFO, "Try and set an invalid mode of -1 on send");
                    this.producer.send(this.destination, (Message)expTextMessage, -1, 4, 0L, (CompletionListener)listener);
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 30; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            logger.log(System.Logger.Level.INFO, "Received Exception after polling loop " + (i + 1));
                            break;
                        }
                        logger.log(System.Logger.Level.INFO, "Completed polling loop " + i);
                    }
                    if (exception == null) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Didn't throw and exception");
                    } else {
                        logger.log(System.Logger.Level.INFO, "Check the value in Exception");
                        if (exception instanceof JMSException) {
                            logger.log(System.Logger.Level.INFO, "Exception is expected JMSException");
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Exception is incorrect expected JMSException, received " + exception.getCause());
                            pass = false;
                        }
                    }
                }
                catch (JMSException e) {
                    logger.log(System.Logger.Level.INFO, "Caught expected JMSException");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected JMSException, received " + e);
                    pass = false;
                }
                try {
                    logger.log(System.Logger.Level.INFO, "Try and set an invalid priority of -1 on send");
                    this.producer.send(this.destination, (Message)expTextMessage, 1, -1, 0L, (CompletionListener)listener);
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 30; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            logger.log(System.Logger.Level.INFO, "Received Exception after polling loop " + (i + 1));
                            break;
                        }
                        logger.log(System.Logger.Level.INFO, "Completed polling loop " + i);
                    }
                    if (exception == null) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Didn't throw and exception");
                        break block19;
                    }
                    logger.log(System.Logger.Level.INFO, "Check the value in Exception");
                    if (exception instanceof JMSException) {
                        logger.log(System.Logger.Level.INFO, "Exception is expected JMSException");
                        break block19;
                    }
                    logger.log(System.Logger.Level.ERROR, "Exception is incorrect expected JMSException, received " + exception.getCause());
                    pass = false;
                }
                catch (JMSException e) {
                    logger.log(System.Logger.Level.INFO, "Caught expected JMSException");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected JMSException, received " + e);
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
                throw new Exception("queueJMSExceptionTests", e);
            }
        }
        if (!pass) {
            throw new Exception("queueJMSExceptionTests failed");
        }
    }

    @Test
    public void queueInvalidDestinationExceptionTests() throws Exception {
        boolean pass;
        block28: {
            pass = true;
            Object tempMsg = null;
            String message = "Where are you!";
            try {
                int i;
                Exception exception;
                logger.log(System.Logger.Level.INFO, "Setup JmsTool for COMMON QUEUE");
                this.tool = new JmsTool(13, this.user, this.password, this.mode);
                this.toolForProducer = new JmsTool(13, this.user, this.password, this.mode);
                this.producer = this.toolForProducer.getDefaultProducer();
                this.consumer = this.tool.getDefaultConsumer();
                this.connection = this.tool.getDefaultConnection();
                this.session = this.tool.getDefaultSession();
                this.destination = null;
                this.connection.start();
                this.queueTest = true;
                MyCompletionListener listener = new MyCompletionListener();
                logger.log(System.Logger.Level.INFO, "Creating TextMessage");
                TextMessage expTextMessage = this.session.createTextMessage(message);
                logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueInvalidDestinationExceptionTests");
                try {
                    logger.log(System.Logger.Level.INFO, "Send message with invalid destination");
                    this.producer.send(this.destination, (Message)expTextMessage, (CompletionListener)listener);
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 30; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            logger.log(System.Logger.Level.INFO, "Received Exception after polling loop " + (i + 1));
                            break;
                        }
                        logger.log(System.Logger.Level.INFO, "Completed polling loop " + i);
                    }
                    if (exception == null) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Didn't throw and exception");
                    } else {
                        logger.log(System.Logger.Level.INFO, "Check the value in Exception");
                        if (exception instanceof InvalidDestinationException) {
                            logger.log(System.Logger.Level.INFO, "Exception is expected InvalidDestinationException");
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Exception is incorrect expected InvalidDestinationException, received " + exception.getCause());
                            pass = false;
                        }
                    }
                }
                catch (InvalidDestinationException e) {
                    logger.log(System.Logger.Level.INFO, "Caught expected InvalidDestinationException");
                }
                catch (UnsupportedOperationException e) {
                    logger.log(System.Logger.Level.INFO, "Caught expected UnsupportedOperationException");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationException, received " + e);
                    pass = false;
                }
                try {
                    logger.log(System.Logger.Level.INFO, "Send message with invalid destination");
                    this.producer.send(this.destination, (Message)expTextMessage, 1, 4, 0L, (CompletionListener)listener);
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 30; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            logger.log(System.Logger.Level.INFO, "Received Exception after polling loop " + (i + 1));
                            break;
                        }
                        logger.log(System.Logger.Level.INFO, "Completed polling loop " + i);
                    }
                    if (exception == null) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Didn't throw and exception");
                        break block28;
                    }
                    logger.log(System.Logger.Level.INFO, "Check the value in Exception");
                    if (exception instanceof InvalidDestinationException) {
                        logger.log(System.Logger.Level.INFO, "Exception is expected InvalidDestinationException");
                        break block28;
                    }
                    logger.log(System.Logger.Level.ERROR, "Exception is incorrect expected InvalidDestinationException, received " + exception.getCause());
                    pass = false;
                }
                catch (InvalidDestinationException e) {
                    logger.log(System.Logger.Level.INFO, "Caught expected InvalidDestinationException");
                }
                catch (UnsupportedOperationException e) {
                    logger.log(System.Logger.Level.INFO, "Caught expected UnsupportedOperationException");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationException, received " + e);
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
                throw new Exception("queueInvalidDestinationExceptionTests", e);
            }
            finally {
                try {
                    this.producer.close();
                }
                catch (Exception exception) {}
            }
        }
        if (!pass) {
            throw new Exception("queueInvalidDestinationExceptionTests failed");
        }
    }

    @Test
    public void queueUnsupportedOperationExceptionTests() throws Exception {
        boolean pass;
        block44: {
            pass = true;
            Object tempMsg = null;
            String message = "Where are you!";
            try {
                int i;
                Exception exception;
                logger.log(System.Logger.Level.INFO, "Setup JmsTool for COMMON QUEUE");
                this.tool = new JmsTool(13, this.user, this.password, this.mode);
                this.producer = this.tool.getDefaultProducer();
                this.consumer = this.tool.getDefaultConsumer();
                this.connection = this.tool.getDefaultConnection();
                this.session = this.tool.getDefaultSession();
                this.destination = this.tool.getDefaultDestination();
                this.connection.start();
                this.queueTest = true;
                MyCompletionListener listener = new MyCompletionListener();
                logger.log(System.Logger.Level.INFO, "Creating TextMessage");
                TextMessage expTextMessage = this.session.createTextMessage(message);
                logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueUnsupportedOperationExceptionTests");
                try {
                    logger.log(System.Logger.Level.INFO, "Send message with invalid destination");
                    this.producer.send(this.destination, (Message)expTextMessage, (CompletionListener)listener);
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 30; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            logger.log(System.Logger.Level.INFO, "Received Exception after polling loop " + (i + 1));
                            break;
                        }
                        logger.log(System.Logger.Level.INFO, "Completed polling loop " + i);
                    }
                    if (exception == null) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Didn't throw and exception");
                    } else {
                        logger.log(System.Logger.Level.INFO, "Check the value in Exception");
                        if (exception instanceof UnsupportedOperationException) {
                            logger.log(System.Logger.Level.INFO, "Exception is expected UnsupportedOperationException");
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Exception is incorrect expected UnsupportedOperationException, received " + exception.getCause());
                            pass = false;
                        }
                    }
                }
                catch (UnsupportedOperationException e) {
                    logger.log(System.Logger.Level.INFO, "Caught expected UnsupportedOperationException");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected UnsupportedOperationException, received " + e);
                    pass = false;
                }
                try {
                    logger.log(System.Logger.Level.INFO, "Send message with invalid destination");
                    this.producer.send(this.destination, (Message)expTextMessage, 1, 4, 0L, (CompletionListener)listener);
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 30; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            logger.log(System.Logger.Level.INFO, "Received Exception after polling loop " + (i + 1));
                            break;
                        }
                        logger.log(System.Logger.Level.INFO, "Completed polling loop " + i);
                    }
                    if (exception == null) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Didn't throw and exception");
                    } else {
                        logger.log(System.Logger.Level.INFO, "Check the value in Exception");
                        if (exception instanceof UnsupportedOperationException) {
                            logger.log(System.Logger.Level.INFO, "Exception is expected UnsupportedOperationException");
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Exception is incorrect expected UnsupportedOperationException, received " + exception.getCause());
                            pass = false;
                        }
                    }
                }
                catch (UnsupportedOperationException e) {
                    logger.log(System.Logger.Level.INFO, "Caught expected UnsupportedOperationException");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected UnsupportedOperationException, received " + e);
                    pass = false;
                }
                this.tool.getDefaultProducer().close();
                this.producer = this.tool.getDefaultSession().createProducer((Destination)((Queue)null));
                try {
                    logger.log(System.Logger.Level.INFO, "Send message with invalid destination");
                    this.producer.send((Message)expTextMessage, (CompletionListener)listener);
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 30; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            logger.log(System.Logger.Level.INFO, "Received Exception after polling loop " + (i + 1));
                            break;
                        }
                        logger.log(System.Logger.Level.INFO, "Completed polling loop " + i);
                    }
                    if (exception == null) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Didn't throw and exception");
                    } else {
                        logger.log(System.Logger.Level.INFO, "Check the value in Exception");
                        if (exception instanceof UnsupportedOperationException) {
                            logger.log(System.Logger.Level.INFO, "Exception is expected UnsupportedOperationException");
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Exception is incorrect expected UnsupportedOperationException, received " + exception.getCause());
                            pass = false;
                        }
                    }
                }
                catch (UnsupportedOperationException e) {
                    logger.log(System.Logger.Level.INFO, "Caught expected UnsupportedOperationException");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected UnsupportedOperationException, received " + e);
                    pass = false;
                }
                try {
                    logger.log(System.Logger.Level.INFO, "Send message with invalid destination");
                    this.producer.send((Message)expTextMessage, 1, 4, 0L, (CompletionListener)listener);
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 30; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            logger.log(System.Logger.Level.INFO, "Received Exception after polling loop " + (i + 1));
                            break;
                        }
                        logger.log(System.Logger.Level.INFO, "Completed polling loop " + i);
                    }
                    if (exception == null) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Didn't throw and exception");
                        break block44;
                    }
                    logger.log(System.Logger.Level.INFO, "Check the value in Exception");
                    if (exception instanceof UnsupportedOperationException) {
                        logger.log(System.Logger.Level.INFO, "Exception is expected UnsupportedOperationException");
                        break block44;
                    }
                    logger.log(System.Logger.Level.ERROR, "Exception is incorrect expected UnsupportedOperationException, received " + exception.getCause());
                    pass = false;
                }
                catch (UnsupportedOperationException e) {
                    logger.log(System.Logger.Level.INFO, "Caught expected UnsupportedOperationException");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected UnsupportedOperationException, received " + e);
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
                throw new Exception("queueUnsupportedOperationExceptionTests", e);
            }
            finally {
                try {
                    this.producer.close();
                }
                catch (Exception exception) {}
            }
        }
        if (!pass) {
            throw new Exception("queueUnsupportedOperationExceptionTests failed");
        }
    }

    @Test
    public void queueIllegalArgumentExceptionTests() throws Exception {
        boolean pass;
        block44: {
            pass = true;
            Object tempMsg = null;
            String message = "Where are you!";
            try {
                int i;
                Exception exception;
                logger.log(System.Logger.Level.INFO, "Setup JmsTool for COMMON QUEUE");
                this.tool = new JmsTool(13, this.user, this.password, this.mode);
                this.tool.getDefaultProducer().close();
                this.producer = this.tool.getDefaultSession().createProducer((Destination)((Queue)null));
                this.consumer = this.tool.getDefaultConsumer();
                this.connection = this.tool.getDefaultConnection();
                this.session = this.tool.getDefaultSession();
                this.destination = this.tool.getDefaultDestination();
                this.connection.start();
                this.queueTest = false;
                MyCompletionListener listener = new MyCompletionListener();
                logger.log(System.Logger.Level.INFO, "Creating TextMessage");
                TextMessage expTextMessage = this.session.createTextMessage(message);
                logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueIllegalArgumentExceptionTests");
                try {
                    logger.log(System.Logger.Level.INFO, "Send message with null CompletionListener");
                    this.producer.send(this.destination, (Message)expTextMessage, null);
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 30; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            logger.log(System.Logger.Level.INFO, "Received Exception after polling loop " + (i + 1));
                            break;
                        }
                        logger.log(System.Logger.Level.INFO, "Completed polling loop " + i);
                    }
                    if (exception == null) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Didn't throw and exception");
                    } else {
                        logger.log(System.Logger.Level.INFO, "Check the value in Exception");
                        if (exception instanceof IllegalArgumentException) {
                            logger.log(System.Logger.Level.INFO, "Exception is expected IllegalArgumentException");
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Exception is incorrect expected IllegalArgumentException, received " + exception.getCause());
                            pass = false;
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    logger.log(System.Logger.Level.INFO, "Caught expected IllegalArgumentException");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected IllegalArgumentException, received " + e);
                    pass = false;
                }
                try {
                    logger.log(System.Logger.Level.INFO, "Send message with null CompletionListener");
                    this.producer.send(this.destination, (Message)expTextMessage, 1, 4, 0L, null);
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 30; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            logger.log(System.Logger.Level.INFO, "Received Exception after polling loop " + (i + 1));
                            break;
                        }
                        logger.log(System.Logger.Level.INFO, "Completed polling loop " + i);
                    }
                    if (exception == null) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Didn't throw and exception");
                    } else {
                        logger.log(System.Logger.Level.INFO, "Check the value in Exception");
                        if (exception instanceof IllegalArgumentException) {
                            logger.log(System.Logger.Level.INFO, "Exception is expected IllegalArgumentException");
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Exception is incorrect expected IllegalArgumentException, received " + exception.getCause());
                            pass = false;
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    logger.log(System.Logger.Level.INFO, "Caught expected IllegalArgumentException");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected IllegalArgumentException, received " + e);
                    pass = false;
                }
                this.producer.close();
                this.producer = this.tool.getDefaultSession().createProducer(this.destination);
                try {
                    logger.log(System.Logger.Level.INFO, "Send message with null CompletionListener");
                    this.producer.send((Message)expTextMessage, null);
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 30; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            logger.log(System.Logger.Level.INFO, "Received Exception after polling loop " + (i + 1));
                            break;
                        }
                        logger.log(System.Logger.Level.INFO, "Completed polling loop " + i);
                    }
                    if (exception == null) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Didn't throw and exception");
                    } else {
                        logger.log(System.Logger.Level.INFO, "Check the value in Exception");
                        if (exception instanceof IllegalArgumentException) {
                            logger.log(System.Logger.Level.INFO, "Exception is expected IllegalArgumentException");
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Exception is incorrect expected IllegalArgumentException, received " + exception.getCause());
                            pass = false;
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    logger.log(System.Logger.Level.INFO, "Caught expected IllegalArgumentException");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected IllegalArgumentException, received " + e);
                    pass = false;
                }
                try {
                    logger.log(System.Logger.Level.INFO, "Send message with null CompletionListener");
                    this.producer.send((Message)expTextMessage, 1, 4, 0L, null);
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 30; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            logger.log(System.Logger.Level.INFO, "Received Exception after polling loop " + (i + 1));
                            break;
                        }
                        logger.log(System.Logger.Level.INFO, "Completed polling loop " + i);
                    }
                    if (exception == null) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Didn't throw and exception");
                        break block44;
                    }
                    logger.log(System.Logger.Level.INFO, "Check the value in Exception");
                    if (exception instanceof IllegalArgumentException) {
                        logger.log(System.Logger.Level.INFO, "Exception is expected IllegalArgumentException");
                        break block44;
                    }
                    logger.log(System.Logger.Level.ERROR, "Exception is incorrect expected IllegalArgumentException, received " + exception.getCause());
                    pass = false;
                }
                catch (IllegalArgumentException e) {
                    logger.log(System.Logger.Level.INFO, "Caught expected IllegalArgumentException");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected IllegalArgumentException, received " + e);
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
                throw new Exception("queueIllegalArgumentExceptionTests", e);
            }
            finally {
                try {
                    this.producer.close();
                }
                catch (Exception exception) {}
            }
        }
        if (!pass) {
            throw new Exception("queueIllegalArgumentExceptionTests failed");
        }
    }

    @Test
    public void queueMessageFormatExceptionTests() throws Exception {
        boolean pass;
        block37: {
            pass = true;
            try {
                int i;
                Exception exception;
                this.tool = new JmsTool(13, this.user, this.password, this.mode);
                this.producer = this.tool.getDefaultProducer();
                this.consumer = this.tool.getDefaultConsumer();
                this.connection = this.tool.getDefaultConnection();
                this.session = this.tool.getDefaultSession();
                this.destination = this.tool.getDefaultDestination();
                this.connection.start();
                this.queueTest = true;
                InvalidTextMessageTestImpl invalidTMsg = new InvalidTextMessageTestImpl();
                invalidTMsg.setText("hello");
                MyCompletionListener listener = new MyCompletionListener();
                try {
                    logger.log(System.Logger.Level.INFO, "Calling MessageProducer.send(Message, CompletionListener) -> expect MessageFormatException");
                    this.producer.send((Message)invalidTMsg, (CompletionListener)listener);
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 30; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            logger.log(System.Logger.Level.INFO, "Received Exception after polling loop " + (i + 1));
                            break;
                        }
                        logger.log(System.Logger.Level.INFO, "Completed polling loop " + i);
                    }
                    if (exception == null) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Didn't throw and exception");
                    } else {
                        logger.log(System.Logger.Level.INFO, "Check the value in Exception");
                        if (exception instanceof MessageFormatException) {
                            logger.log(System.Logger.Level.INFO, "Exception is expected MessageFormatException");
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Exception is incorrect expected MessageFormatException, received " + exception.getCause());
                            pass = false;
                        }
                    }
                }
                catch (MessageFormatException e) {
                    logger.log(System.Logger.Level.INFO, "Got MessageFormatException as expected.");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected MessageFormatException, received " + e);
                    pass = false;
                }
                try {
                    logger.log(System.Logger.Level.INFO, "Calling MessageProducer.send(Message, int, int, long, CompletionListener) -> expect MessageFormatException");
                    this.producer.send((Message)invalidTMsg, 2, 3, 0L, (CompletionListener)listener);
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 30; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            logger.log(System.Logger.Level.INFO, "Received Exception after polling loop " + (i + 1));
                            break;
                        }
                        logger.log(System.Logger.Level.INFO, "Completed polling loop " + i);
                    }
                    if (exception == null) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Didn't throw and exception");
                    } else {
                        logger.log(System.Logger.Level.INFO, "Check the value in Exception");
                        if (exception instanceof MessageFormatException) {
                            logger.log(System.Logger.Level.INFO, "Exception is expected MessageFormatException");
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Exception is incorrect expected MessageFormatException, received " + exception.getCause());
                            pass = false;
                        }
                    }
                }
                catch (MessageFormatException e) {
                    logger.log(System.Logger.Level.INFO, "Got MessageFormatException as expected.");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected MessageFormatException, received " + e);
                    pass = false;
                }
                this.tool.getDefaultProducer().close();
                this.producer = this.tool.getDefaultSession().createProducer((Destination)((Queue)null));
                try {
                    logger.log(System.Logger.Level.INFO, "Calling MessageProducer.send(Destination, Message, CompletionListener) -> expect MessageFormatException");
                    this.producer.send(this.destination, (Message)invalidTMsg, (CompletionListener)listener);
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 30; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            logger.log(System.Logger.Level.INFO, "Received Exception after polling loop " + (i + 1));
                            break;
                        }
                        logger.log(System.Logger.Level.INFO, "Completed polling loop " + i);
                    }
                    if (exception == null) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Didn't throw and exception");
                    } else {
                        logger.log(System.Logger.Level.INFO, "Check the value in Exception");
                        if (exception instanceof MessageFormatException) {
                            logger.log(System.Logger.Level.INFO, "Exception is expected MessageFormatException");
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Exception is incorrect expected MessageFormatException, received " + exception.getCause());
                            pass = false;
                        }
                    }
                }
                catch (MessageFormatException e) {
                    logger.log(System.Logger.Level.INFO, "Got MessageFormatException as expected.");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected MessageFormatException, received " + e);
                    pass = false;
                }
                try {
                    logger.log(System.Logger.Level.INFO, "Calling MessageProducer.send(Destination, Message, int, int, long, CompletionListener) -> expect MessageFormatException");
                    this.producer.send(this.destination, (Message)invalidTMsg, 2, 3, 0L, (CompletionListener)listener);
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 30; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            logger.log(System.Logger.Level.INFO, "Received Exception after polling loop " + (i + 1));
                            break;
                        }
                        logger.log(System.Logger.Level.INFO, "Completed polling loop " + i);
                    }
                    if (exception == null) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Didn't throw and exception");
                        break block37;
                    }
                    logger.log(System.Logger.Level.INFO, "Check the value in Exception");
                    if (exception instanceof MessageFormatException) {
                        logger.log(System.Logger.Level.INFO, "Exception is expected MessageFormatException");
                        break block37;
                    }
                    logger.log(System.Logger.Level.ERROR, "Exception is incorrect expected MessageFormatException, received " + exception.getCause());
                    pass = false;
                }
                catch (MessageFormatException e) {
                    logger.log(System.Logger.Level.INFO, "Got MessageFormatException as expected.");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected MessageFormatException, received " + e);
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                throw new Exception("queueMessageFormatExceptionTests", e);
            }
        }
        if (!pass) {
            throw new Exception("queueMessageFormatExceptionTests failed");
        }
    }

    @Test
    public void queueIllegalStateExceptionTests() throws Exception {
        boolean pass;
        block10: {
            pass = true;
            try {
                this.tool = new JmsTool(13, this.user, this.password, this.mode);
                this.tool.getDefaultProducer().close();
                this.producer = this.tool.getDefaultSession().createProducer((Destination)((Queue)null));
                this.connection = this.tool.getDefaultConnection();
                this.session = this.tool.getDefaultSession();
                this.destination = this.tool.getDefaultDestination();
                this.connection.start();
                this.queueTest = true;
                MyCompletionListener listener = new MyCompletionListener(this.producer);
                logger.log(System.Logger.Level.INFO, "Testing MessageProducer.close() from CompletionListener (expect IllegalStateException)");
                try {
                    logger.log(System.Logger.Level.INFO, "Creating TextMessage");
                    TextMessage expTextMessage = this.session.createTextMessage("Call close method");
                    logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
                    expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueIllegalStateExceptionTests");
                    logger.log(System.Logger.Level.INFO, "Send async message specifying CompletionListener to recieve async message");
                    logger.log(System.Logger.Level.INFO, "CompletionListener will call MessageProducer.close() (expect IllegalStateException)");
                    this.producer.send(this.destination, (Message)expTextMessage, (CompletionListener)listener);
                    Object actTextMessage = null;
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                    for (int i = 0; i < 30; ++i) {
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            break;
                        }
                        TestUtil.sleepSec((int)2);
                    }
                    logger.log(System.Logger.Level.INFO, "Check if we got correct exception from MessageProducer.close()");
                    if (listener.gotException()) {
                        if (listener.gotCorrectException()) {
                            logger.log(System.Logger.Level.INFO, "Got correct IllegalStateException");
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected IllegalStateException, received: " + listener.getException());
                            pass = false;
                        }
                        break block10;
                    }
                    logger.log(System.Logger.Level.ERROR, "Expected IllegalStateException, got no exception");
                    pass = false;
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected IllegalStateException, received " + e);
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                throw new Exception("queueIllegalStateExceptionTests", e);
            }
        }
        if (!pass) {
            throw new Exception("queueIllegalStateExceptionTests failed");
        }
    }

    @Test
    public void topicSendRecvCompletionListenerTest1() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.tool.getDefaultProducer().close();
            this.producer = this.tool.getDefaultSession().createProducer((Destination)((Topic)null));
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = false;
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicSendRecvCompletionListenerTest1");
            MyCompletionListener listener = new MyCompletionListener();
            logger.log(System.Logger.Level.INFO, "Calling send(Destination,Message,CompletionListener)");
            this.producer.send(this.destination, (Message)expTextMessage, (CompletionListener)listener);
            logger.log(System.Logger.Level.INFO, "Poll listener waiting for TestMessage to arrive");
            TextMessage actTextMessage = null;
            for (int i = 0; !listener.isComplete() && i < 60; ++i) {
                logger.log(System.Logger.Level.INFO, "Loop " + i + ": sleep 2 seconds waiting for messages to arrive at listener");
                TestUtil.sleepSec((int)2);
            }
            if (listener.isComplete()) {
                actTextMessage = (TextMessage)listener.getMessage();
            }
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("topicSendRecvCompletionListenerTest1", e);
        }
        finally {
            try {
                this.producer.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("topicSendRecvCompletionListenerTest1 failed");
        }
    }

    @Test
    public void topicSendRecvCompletionListenerTest2() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.tool.getDefaultProducer().close();
            this.producer = this.tool.getDefaultSession().createProducer((Destination)((Topic)null));
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = false;
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicSendRecvCompletionListenerTest2");
            MyCompletionListener listener = new MyCompletionListener();
            logger.log(System.Logger.Level.INFO, "Calling send(Destination,Message,int,int,long,CompletionListener)");
            this.producer.send(this.destination, (Message)expTextMessage, 1, 4, 0L, (CompletionListener)listener);
            logger.log(System.Logger.Level.INFO, "Poll listener waiting for TestMessage to arrive");
            TextMessage actTextMessage = null;
            for (int i = 0; !listener.isComplete() && i < 60; ++i) {
                logger.log(System.Logger.Level.INFO, "Loop " + i + ": sleep 2 seconds waiting for messages to arrive at listener");
                TestUtil.sleepSec((int)2);
            }
            if (listener.isComplete()) {
                actTextMessage = (TextMessage)listener.getMessage();
            }
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the values in TextMessage, deliverymode, priority, time to live");
            if (!actTextMessage.getText().equals(expTextMessage.getText()) || actTextMessage.getJMSDeliveryMode() != 1 || actTextMessage.getJMSPriority() != 4 || actTextMessage.getJMSExpiration() != 0L) {
                logger.log(System.Logger.Level.ERROR, "Didn't get the right message.");
                logger.log(System.Logger.Level.ERROR, "text=" + actTextMessage.getText() + ", expected " + expTextMessage.getText());
                logger.log(System.Logger.Level.ERROR, "DeliveryMode=" + actTextMessage.getJMSDeliveryMode() + ", expected " + expTextMessage.getJMSDeliveryMode());
                logger.log(System.Logger.Level.ERROR, "Priority=" + actTextMessage.getJMSPriority() + ", expected " + expTextMessage.getJMSPriority());
                logger.log(System.Logger.Level.ERROR, "TimeToLive=" + actTextMessage.getJMSExpiration() + ", expected " + expTextMessage.getJMSExpiration());
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("topicSendRecvCompletionListenerTest2", e);
        }
        finally {
            try {
                this.producer.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("topicSendRecvCompletionListenerTest2 failed");
        }
    }

    @Test
    public void topicSendRecvCompletionListenerTest3() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = false;
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicSendRecvCompletionListenerTest3");
            MyCompletionListener listener = new MyCompletionListener();
            logger.log(System.Logger.Level.INFO, "Calling send(Message,CompletionListener)");
            this.producer.send((Message)expTextMessage, (CompletionListener)listener);
            logger.log(System.Logger.Level.INFO, "Poll listener waiting for TestMessage to arrive");
            TextMessage actTextMessage = null;
            for (int i = 0; !listener.isComplete() && i < 60; ++i) {
                logger.log(System.Logger.Level.INFO, "Loop " + i + ": sleep 2 seconds waiting for messages to arrive at listener");
                TestUtil.sleepSec((int)2);
            }
            if (listener.isComplete()) {
                actTextMessage = (TextMessage)listener.getMessage();
            }
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("topicSendRecvCompletionListenerTest3", e);
        }
        if (!pass) {
            throw new Exception("topicSendRecvCompletionListenerTest3 failed");
        }
    }

    @Test
    public void topicSendRecvCompletionListenerTest4() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = false;
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicSendRecvCompletionListeneTest4");
            MyCompletionListener listener = new MyCompletionListener();
            logger.log(System.Logger.Level.INFO, "Calling send(Message,int,int,long,CompletionListener)");
            this.producer.send((Message)expTextMessage, 2, 4, 0L, (CompletionListener)listener);
            logger.log(System.Logger.Level.INFO, "Poll listener waiting for TestMessage to arrive");
            TextMessage actTextMessage = null;
            for (int i = 0; !listener.isComplete() && i < 60; ++i) {
                logger.log(System.Logger.Level.INFO, "Loop " + i + ": sleep 2 seconds waiting for messages to arrive at listener");
                TestUtil.sleepSec((int)2);
            }
            if (listener.isComplete()) {
                actTextMessage = (TextMessage)listener.getMessage();
            }
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the values in TextMessage, deliverymode, priority, time to live");
            if (!actTextMessage.getText().equals(expTextMessage.getText()) || actTextMessage.getJMSDeliveryMode() != 2 || actTextMessage.getJMSPriority() != 4 || actTextMessage.getJMSExpiration() != 0L) {
                logger.log(System.Logger.Level.ERROR, "Didn't get the right message.");
                logger.log(System.Logger.Level.ERROR, "text=" + actTextMessage.getText() + ", expected " + expTextMessage.getText());
                logger.log(System.Logger.Level.ERROR, "DeliveryMode=" + actTextMessage.getJMSDeliveryMode() + ", expected " + expTextMessage.getJMSDeliveryMode());
                logger.log(System.Logger.Level.ERROR, "Priority=" + actTextMessage.getJMSPriority() + ", expected " + expTextMessage.getJMSPriority());
                logger.log(System.Logger.Level.ERROR, "TimeToLive=" + actTextMessage.getJMSExpiration() + ", expected " + expTextMessage.getJMSExpiration());
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("topicSendRecvCompletionListenerTest4", e);
        }
        if (!pass) {
            throw new Exception("topicSendRecvCompletionListenerTest4 failed");
        }
    }

    @Test
    public void topicJMSExceptionTests() throws Exception {
        boolean pass;
        block19: {
            pass = true;
            Object tempMsg = null;
            String message = "Where are you!";
            try {
                int i;
                Exception exception;
                logger.log(System.Logger.Level.INFO, "Setup JmsTool for COMMON TOPIC");
                this.tool = new JmsTool(14, this.user, this.password, this.mode);
                this.tool.getDefaultProducer().close();
                this.producer = this.tool.getDefaultSession().createProducer((Destination)((Topic)null));
                this.consumer = this.tool.getDefaultConsumer();
                this.connection = this.tool.getDefaultConnection();
                this.session = this.tool.getDefaultSession();
                this.destination = this.tool.getDefaultDestination();
                this.connection.start();
                this.queueTest = false;
                logger.log(System.Logger.Level.INFO, "Creating TextMessage");
                TextMessage expTextMessage = this.session.createTextMessage(message);
                logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicJMSExceptionTests");
                MyCompletionListener listener = new MyCompletionListener();
                try {
                    logger.log(System.Logger.Level.INFO, "Try and set an invalid mode of -1 on send");
                    this.producer.send(this.destination, (Message)expTextMessage, -1, 4, 0L, (CompletionListener)listener);
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 10; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            logger.log(System.Logger.Level.INFO, "Received Exception after polling loop " + (i + 1));
                            break;
                        }
                        logger.log(System.Logger.Level.INFO, "Completed polling loop " + i);
                    }
                    if (exception == null) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Didn't throw and exception");
                    } else {
                        logger.log(System.Logger.Level.INFO, "Check the value in Exception");
                        if (exception instanceof JMSException) {
                            logger.log(System.Logger.Level.INFO, "Exception is expected JMSException");
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Exception is incorrect expected JMSException, received " + exception.getCause());
                            pass = false;
                        }
                    }
                }
                catch (JMSException e) {
                    logger.log(System.Logger.Level.INFO, "Caught expected JMSException");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected JMSException, received " + e);
                    pass = false;
                }
                try {
                    logger.log(System.Logger.Level.INFO, "Try and set an invalid priority of -1 on send");
                    this.producer.send(this.destination, (Message)expTextMessage, 1, -1, 0L, (CompletionListener)listener);
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 10; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            logger.log(System.Logger.Level.INFO, "Received Exception after polling loop " + (i + 1));
                            break;
                        }
                        logger.log(System.Logger.Level.INFO, "Completed polling loop " + i);
                    }
                    if (exception == null) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Didn't throw and exception");
                        break block19;
                    }
                    logger.log(System.Logger.Level.INFO, "Check the value in Exception");
                    if (exception instanceof JMSException) {
                        logger.log(System.Logger.Level.INFO, "Exception is expected JMSException");
                        break block19;
                    }
                    logger.log(System.Logger.Level.ERROR, "Exception is incorrect expected JMSException, received " + exception.getCause());
                    pass = false;
                }
                catch (JMSException e) {
                    logger.log(System.Logger.Level.INFO, "Caught expected JMSException");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected JMSException, received " + e);
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
                throw new Exception("topicJMSExceptionTests", e);
            }
        }
        if (!pass) {
            throw new Exception("topicJMSExceptionTests failed");
        }
    }

    @Test
    public void topicInvalidDestinationExceptionTests() throws Exception {
        boolean pass;
        block28: {
            pass = true;
            Object tempMsg = null;
            String message = "Where are you!";
            try {
                int i;
                Exception exception;
                logger.log(System.Logger.Level.INFO, "Setup JmsTool for COMMON TOPIC");
                this.tool = new JmsTool(14, this.user, this.password, this.mode);
                this.toolForProducer = new JmsTool(14, this.user, this.password, this.mode);
                this.producer = this.toolForProducer.getDefaultProducer();
                this.consumer = this.tool.getDefaultConsumer();
                this.connection = this.tool.getDefaultConnection();
                this.session = this.tool.getDefaultSession();
                this.destination = null;
                this.connection.start();
                this.queueTest = false;
                MyCompletionListener listener = new MyCompletionListener();
                logger.log(System.Logger.Level.INFO, "Creating TextMessage");
                TextMessage expTextMessage = this.session.createTextMessage(message);
                logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueInvalidDestinationExceptionTests");
                try {
                    logger.log(System.Logger.Level.INFO, "Send message with invalid destination");
                    this.producer.send(this.destination, (Message)expTextMessage, (CompletionListener)listener);
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 10; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            logger.log(System.Logger.Level.INFO, "Received Exception after polling loop " + (i + 1));
                            break;
                        }
                        logger.log(System.Logger.Level.INFO, "Completed polling loop " + i);
                    }
                    if (exception == null) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Didn't throw and exception");
                    } else {
                        logger.log(System.Logger.Level.INFO, "Check the value in Exception");
                        if (exception instanceof InvalidDestinationException) {
                            logger.log(System.Logger.Level.INFO, "Exception is expected InvalidDestinationException");
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Exception is incorrect expected InvalidDestinationException, received " + exception.getCause());
                            pass = false;
                        }
                    }
                }
                catch (InvalidDestinationException e) {
                    logger.log(System.Logger.Level.INFO, "Caught expected InvalidDestinationException");
                }
                catch (UnsupportedOperationException e) {
                    logger.log(System.Logger.Level.INFO, "Caught expected UnsupportedOperationException");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationException, received " + e);
                    pass = false;
                }
                try {
                    logger.log(System.Logger.Level.INFO, "Send message with invalid destination");
                    this.producer.send(this.destination, (Message)expTextMessage, 1, 4, 0L, (CompletionListener)listener);
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 10; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            logger.log(System.Logger.Level.INFO, "Received Exception after polling loop " + (i + 1));
                            break;
                        }
                        logger.log(System.Logger.Level.INFO, "Completed polling loop " + i);
                    }
                    if (exception == null) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Didn't throw and exception");
                        break block28;
                    }
                    logger.log(System.Logger.Level.INFO, "Check the value in Exception");
                    if (exception instanceof InvalidDestinationException) {
                        logger.log(System.Logger.Level.INFO, "Exception is expected InvalidDestinationException");
                        break block28;
                    }
                    logger.log(System.Logger.Level.ERROR, "Exception is incorrect expected InvalidDestinationException, received " + exception.getCause());
                    pass = false;
                }
                catch (InvalidDestinationException e) {
                    logger.log(System.Logger.Level.INFO, "Caught expected InvalidDestinationException");
                }
                catch (UnsupportedOperationException e) {
                    logger.log(System.Logger.Level.INFO, "Caught expected UnsupportedOperationException");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationException, received " + e);
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
                throw new Exception("queueInvalidDestinationExceptionTests", e);
            }
            finally {
                try {
                    this.producer.close();
                }
                catch (Exception exception) {}
            }
        }
        if (!pass) {
            throw new Exception("topicInvalidDestinationExceptionTests failed");
        }
    }

    @Test
    public void topicUnsupportedOperationExceptionTests() throws Exception {
        boolean pass;
        block44: {
            pass = true;
            Object tempMsg = null;
            String message = "Where are you!";
            try {
                int i;
                Exception exception;
                logger.log(System.Logger.Level.INFO, "Setup JmsTool for COMMON TOPIC");
                this.tool = new JmsTool(14, this.user, this.password, this.mode);
                this.producer = this.tool.getDefaultProducer();
                this.consumer = this.tool.getDefaultConsumer();
                this.connection = this.tool.getDefaultConnection();
                this.session = this.tool.getDefaultSession();
                this.destination = this.tool.getDefaultDestination();
                this.connection.start();
                this.queueTest = false;
                MyCompletionListener listener = new MyCompletionListener();
                logger.log(System.Logger.Level.INFO, "Creating TextMessage");
                TextMessage expTextMessage = this.session.createTextMessage(message);
                logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicUnsupportedOperationExceptionTests");
                try {
                    logger.log(System.Logger.Level.INFO, "Send message with invalid destination");
                    this.producer.send(this.destination, (Message)expTextMessage, (CompletionListener)listener);
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 10; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            logger.log(System.Logger.Level.INFO, "Received Exception after polling loop " + (i + 1));
                            break;
                        }
                        logger.log(System.Logger.Level.INFO, "Completed polling loop " + i);
                    }
                    if (exception == null) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Didn't throw and exception");
                    } else {
                        logger.log(System.Logger.Level.INFO, "Check the value in Exception");
                        if (exception instanceof UnsupportedOperationException) {
                            logger.log(System.Logger.Level.INFO, "Exception is expected UnsupportedOperationException");
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Exception is incorrect expected UnsupportedOperationException, received " + exception.getCause());
                            pass = false;
                        }
                    }
                }
                catch (UnsupportedOperationException e) {
                    logger.log(System.Logger.Level.INFO, "Caught expected UnsupportedOperationException");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected UnsupportedOperationException, received " + e);
                    pass = false;
                }
                try {
                    logger.log(System.Logger.Level.INFO, "Send message with invalid destination");
                    this.producer.send(this.destination, (Message)expTextMessage, 1, 4, 0L, (CompletionListener)listener);
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 10; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            logger.log(System.Logger.Level.INFO, "Received Exception after polling loop " + (i + 1));
                            break;
                        }
                        logger.log(System.Logger.Level.INFO, "Completed polling loop " + i);
                    }
                    if (exception == null) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Didn't throw and exception");
                    } else {
                        logger.log(System.Logger.Level.INFO, "Check the value in Exception");
                        if (exception instanceof UnsupportedOperationException) {
                            logger.log(System.Logger.Level.INFO, "Exception is expected UnsupportedOperationException");
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Exception is incorrect expected UnsupportedOperationException, received " + exception.getCause());
                            pass = false;
                        }
                    }
                }
                catch (UnsupportedOperationException e) {
                    logger.log(System.Logger.Level.INFO, "Caught expected UnsupportedOperationException");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected UnsupportedOperationException, received " + e);
                    pass = false;
                }
                this.tool.getDefaultProducer().close();
                this.producer = this.tool.getDefaultSession().createProducer((Destination)((Topic)null));
                try {
                    logger.log(System.Logger.Level.INFO, "Send message with invalid destination");
                    this.producer.send((Message)expTextMessage, (CompletionListener)listener);
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 10; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            logger.log(System.Logger.Level.INFO, "Received Exception after polling loop " + (i + 1));
                            break;
                        }
                        logger.log(System.Logger.Level.INFO, "Completed polling loop " + i);
                    }
                    if (exception == null) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Didn't throw and exception");
                    } else {
                        logger.log(System.Logger.Level.INFO, "Check the value in Exception");
                        if (exception instanceof UnsupportedOperationException) {
                            logger.log(System.Logger.Level.INFO, "Exception is expected UnsupportedOperationException");
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Exception is incorrect expected UnsupportedOperationException, received " + exception.getCause());
                            pass = false;
                        }
                    }
                }
                catch (UnsupportedOperationException e) {
                    logger.log(System.Logger.Level.INFO, "Caught expected UnsupportedOperationException");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected UnsupportedOperationException, received " + e);
                    pass = false;
                }
                try {
                    logger.log(System.Logger.Level.INFO, "Send message with invalid destination");
                    this.producer.send((Message)expTextMessage, 1, 4, 0L, (CompletionListener)listener);
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 10; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            logger.log(System.Logger.Level.INFO, "Received Exception after polling loop " + (i + 1));
                            break;
                        }
                        logger.log(System.Logger.Level.INFO, "Completed polling loop " + i);
                    }
                    if (exception == null) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Didn't throw and exception");
                        break block44;
                    }
                    logger.log(System.Logger.Level.INFO, "Check the value in Exception");
                    if (exception instanceof UnsupportedOperationException) {
                        logger.log(System.Logger.Level.INFO, "Exception is expected UnsupportedOperationException");
                        break block44;
                    }
                    logger.log(System.Logger.Level.ERROR, "Exception is incorrect expected UnsupportedOperationException, received " + exception.getCause());
                    pass = false;
                }
                catch (UnsupportedOperationException e) {
                    logger.log(System.Logger.Level.INFO, "Caught expected UnsupportedOperationException");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected UnsupportedOperationException, received " + e);
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
                throw new Exception("queueUnsupportedOperationExceptionTests", e);
            }
            finally {
                try {
                    this.producer.close();
                }
                catch (Exception exception) {}
            }
        }
        if (!pass) {
            throw new Exception("topicUnsupportedOperationExceptionTests failed");
        }
    }

    @Test
    public void topicIllegalArgumentExceptionTests() throws Exception {
        boolean pass;
        block44: {
            pass = true;
            Object tempMsg = null;
            String message = "Where are you!";
            try {
                int i;
                Exception exception;
                logger.log(System.Logger.Level.INFO, "Setup JmsTool for COMMON TOPIC");
                this.tool = new JmsTool(14, this.user, this.password, this.mode);
                this.tool.getDefaultProducer().close();
                this.producer = this.tool.getDefaultSession().createProducer((Destination)((Topic)null));
                this.consumer = this.tool.getDefaultConsumer();
                this.connection = this.tool.getDefaultConnection();
                this.session = this.tool.getDefaultSession();
                this.destination = this.tool.getDefaultDestination();
                this.connection.start();
                this.queueTest = false;
                MyCompletionListener listener = new MyCompletionListener();
                logger.log(System.Logger.Level.INFO, "Creating TextMessage");
                TextMessage expTextMessage = this.session.createTextMessage(message);
                logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicIllegalArgumentExceptionTests");
                try {
                    logger.log(System.Logger.Level.INFO, "Send message with null CompletionListener");
                    this.producer.send(this.destination, (Message)expTextMessage, null);
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 10; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            logger.log(System.Logger.Level.INFO, "Received Exception after polling loop " + (i + 1));
                            break;
                        }
                        logger.log(System.Logger.Level.INFO, "Completed polling loop " + i);
                    }
                    if (exception == null) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Didn't throw and exception");
                    } else {
                        logger.log(System.Logger.Level.INFO, "Check the value in Exception");
                        if (exception instanceof IllegalArgumentException) {
                            logger.log(System.Logger.Level.INFO, "Exception is expected IllegalArgumentException");
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Exception is incorrect expected IllegalArgumentException, received " + exception.getCause());
                            pass = false;
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    logger.log(System.Logger.Level.INFO, "Caught expected IllegalArgumentException");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected IllegalArgumentException, received " + e);
                    pass = false;
                }
                try {
                    logger.log(System.Logger.Level.INFO, "Send message with null CompletionListener");
                    this.producer.send(this.destination, (Message)expTextMessage, 1, 4, 0L, null);
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 10; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            logger.log(System.Logger.Level.INFO, "Received Exception after polling loop " + (i + 1));
                            break;
                        }
                        logger.log(System.Logger.Level.INFO, "Completed polling loop " + i);
                    }
                    if (exception == null) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Didn't throw and exception");
                    } else {
                        logger.log(System.Logger.Level.INFO, "Check the value in Exception");
                        if (exception instanceof IllegalArgumentException) {
                            logger.log(System.Logger.Level.INFO, "Exception is expected IllegalArgumentException");
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Exception is incorrect expected IllegalArgumentException, received " + exception.getCause());
                            pass = false;
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    logger.log(System.Logger.Level.INFO, "Caught expected IllegalArgumentException");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected IllegalArgumentException, received " + e);
                    pass = false;
                }
                this.producer.close();
                this.producer = this.tool.getDefaultSession().createProducer(this.destination);
                try {
                    logger.log(System.Logger.Level.INFO, "Send message with null CompletionListener");
                    this.producer.send((Message)expTextMessage, null);
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 10; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            logger.log(System.Logger.Level.INFO, "Received Exception after polling loop " + (i + 1));
                            break;
                        }
                        logger.log(System.Logger.Level.INFO, "Completed polling loop " + i);
                    }
                    if (exception == null) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Didn't throw and exception");
                    } else {
                        logger.log(System.Logger.Level.INFO, "Check the value in Exception");
                        if (exception instanceof IllegalArgumentException) {
                            logger.log(System.Logger.Level.INFO, "Exception is expected IllegalArgumentException");
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Exception is incorrect expected IllegalArgumentException, received " + exception.getCause());
                            pass = false;
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    logger.log(System.Logger.Level.INFO, "Caught expected IllegalArgumentException");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected IllegalArgumentException, received " + e);
                    pass = false;
                }
                try {
                    logger.log(System.Logger.Level.INFO, "Send message with null CompletionListener");
                    this.producer.send((Message)expTextMessage, 1, 4, 0L, null);
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 10; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            logger.log(System.Logger.Level.INFO, "Received Exception after polling loop " + (i + 1));
                            break;
                        }
                        logger.log(System.Logger.Level.INFO, "Completed polling loop " + i);
                    }
                    if (exception == null) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Didn't throw and exception");
                        break block44;
                    }
                    logger.log(System.Logger.Level.INFO, "Check the value in Exception");
                    if (exception instanceof IllegalArgumentException) {
                        logger.log(System.Logger.Level.INFO, "Exception is expected IllegalArgumentException");
                        break block44;
                    }
                    logger.log(System.Logger.Level.ERROR, "Exception is incorrect expected IllegalArgumentException, received " + exception.getCause());
                    pass = false;
                }
                catch (IllegalArgumentException e) {
                    logger.log(System.Logger.Level.INFO, "Caught expected IllegalArgumentException");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected IllegalArgumentException, received " + e);
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
                throw new Exception("queueIllegalArgumentExceptionTests", e);
            }
            finally {
                try {
                    this.producer.close();
                }
                catch (Exception exception) {}
            }
        }
        if (!pass) {
            throw new Exception("topicIllegalArgumentExceptionTests failed");
        }
    }

    @Test
    public void topicMessageFormatExceptionTests() throws Exception {
        boolean pass;
        block33: {
            pass = true;
            try {
                Exception exception;
                this.tool = new JmsTool(14, this.user, this.password, this.mode);
                this.producer = this.tool.getDefaultProducer();
                this.consumer = this.tool.getDefaultConsumer();
                this.connection = this.tool.getDefaultConnection();
                this.session = this.tool.getDefaultSession();
                this.destination = this.tool.getDefaultDestination();
                this.connection.start();
                this.queueTest = false;
                InvalidTextMessageTestImpl invalidTMsg = new InvalidTextMessageTestImpl();
                invalidTMsg.setText("hello");
                MyCompletionListener listener = new MyCompletionListener();
                try {
                    logger.log(System.Logger.Level.INFO, "Calling MessageProducer.send(Message, CompletionListener) -> expect MessageFormatException");
                    this.producer.send((Message)invalidTMsg, (CompletionListener)listener);
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                    TestUtil.sleepSec((int)5);
                    exception = null;
                    if (listener.isComplete()) {
                        listener.setComplete(false);
                        exception = listener.getException();
                    }
                    if (exception == null) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Didn't throw and exception");
                    } else {
                        logger.log(System.Logger.Level.INFO, "Check the value in Exception");
                        if (exception instanceof MessageFormatException) {
                            logger.log(System.Logger.Level.INFO, "Exception is expected MessageFormatException");
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Exception is incorrect expected MessageFormatException, received " + exception.getCause());
                            pass = false;
                        }
                    }
                }
                catch (MessageFormatException e) {
                    logger.log(System.Logger.Level.INFO, "Got MessageFormatException as expected.");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected MessageFormatException, received " + e);
                    pass = false;
                }
                try {
                    logger.log(System.Logger.Level.INFO, "Calling MessageProducer.send(Message, int, int, long, CompletionListener) -> expect MessageFormatException");
                    this.producer.send((Message)invalidTMsg, 2, 3, 0L, (CompletionListener)listener);
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                    TestUtil.sleepSec((int)5);
                    exception = null;
                    if (listener.isComplete()) {
                        listener.setComplete(false);
                        exception = listener.getException();
                    }
                    if (exception == null) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Didn't throw and exception");
                    } else {
                        logger.log(System.Logger.Level.INFO, "Check the value in Exception");
                        if (exception instanceof MessageFormatException) {
                            logger.log(System.Logger.Level.INFO, "Exception is expected MessageFormatException");
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Exception is incorrect expected MessageFormatException, received " + exception.getCause());
                            pass = false;
                        }
                    }
                }
                catch (MessageFormatException e) {
                    logger.log(System.Logger.Level.INFO, "Got MessageFormatException as expected.");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected MessageFormatException, received " + e);
                    pass = false;
                }
                this.tool.getDefaultProducer().close();
                this.producer = this.tool.getDefaultSession().createProducer((Destination)((Queue)null));
                try {
                    logger.log(System.Logger.Level.INFO, "Calling MessageProducer.send(Destination, Message, CompletionListener) -> expect MessageFormatException");
                    this.producer.send(this.destination, (Message)invalidTMsg, (CompletionListener)listener);
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                    TestUtil.sleepSec((int)5);
                    exception = null;
                    if (listener.isComplete()) {
                        listener.setComplete(false);
                        exception = listener.getException();
                    }
                    if (exception == null) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Didn't throw and exception");
                    } else {
                        logger.log(System.Logger.Level.INFO, "Check the value in Exception");
                        if (exception instanceof MessageFormatException) {
                            logger.log(System.Logger.Level.INFO, "Exception is expected MessageFormatException");
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Exception is incorrect expected MessageFormatException, received " + exception.getCause());
                            pass = false;
                        }
                    }
                }
                catch (MessageFormatException e) {
                    logger.log(System.Logger.Level.INFO, "Got MessageFormatException as expected.");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected MessageFormatException, received " + e);
                    pass = false;
                }
                try {
                    logger.log(System.Logger.Level.INFO, "Calling MessageProducer.send(Destination, Message, int, int, long, CompletionListener) -> expect MessageFormatException");
                    this.producer.send(this.destination, (Message)invalidTMsg, 2, 3, 0L, (CompletionListener)listener);
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                    TestUtil.sleepSec((int)5);
                    exception = null;
                    if (listener.isComplete()) {
                        listener.setComplete(false);
                        exception = listener.getException();
                    }
                    if (exception == null) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Didn't throw and exception");
                        break block33;
                    }
                    logger.log(System.Logger.Level.INFO, "Check the value in Exception");
                    if (exception instanceof MessageFormatException) {
                        logger.log(System.Logger.Level.INFO, "Exception is expected MessageFormatException");
                        break block33;
                    }
                    logger.log(System.Logger.Level.ERROR, "Exception is incorrect expected MessageFormatException, received " + exception.getCause());
                    pass = false;
                }
                catch (MessageFormatException e) {
                    logger.log(System.Logger.Level.INFO, "Got MessageFormatException as expected.");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected MessageFormatException, received " + e);
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                throw new Exception("topicMessageFormatExceptionTests", e);
            }
        }
        if (!pass) {
            throw new Exception("topicMessageFormatExceptionTests failed");
        }
    }

    @Test
    public void topicIllegalStateExceptionTests() throws Exception {
        boolean pass;
        block10: {
            pass = true;
            try {
                this.tool = new JmsTool(14, this.user, this.password, this.mode);
                this.tool.getDefaultProducer().close();
                this.producer = this.tool.getDefaultSession().createProducer((Destination)((Topic)null));
                this.connection = this.tool.getDefaultConnection();
                this.session = this.tool.getDefaultSession();
                this.destination = this.tool.getDefaultDestination();
                this.connection.start();
                this.queueTest = false;
                MyCompletionListener listener = new MyCompletionListener(this.producer);
                logger.log(System.Logger.Level.INFO, "Testing MessageProducer.close() from CompletionListener (expect IllegalStateException)");
                try {
                    logger.log(System.Logger.Level.INFO, "Creating TextMessage");
                    TextMessage expTextMessage = this.session.createTextMessage("Call close method");
                    logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
                    expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicIllegalStateExceptionTests");
                    logger.log(System.Logger.Level.INFO, "Send async message specifying CompletionListener to recieve async message");
                    logger.log(System.Logger.Level.INFO, "CompletionListener will call MessageProducer.close() (expect IllegalStateException)");
                    this.producer.send(this.destination, (Message)expTextMessage, (CompletionListener)listener);
                    Object actTextMessage = null;
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive message or exception");
                    for (int i = 0; i < 10; ++i) {
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            break;
                        }
                        TestUtil.sleepSec((int)2);
                    }
                    logger.log(System.Logger.Level.INFO, "Check if we got correct exception from MessageProducer.close()");
                    if (listener.gotException()) {
                        if (listener.gotCorrectException()) {
                            logger.log(System.Logger.Level.INFO, "Got correct IllegalStateException");
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected IllegalStateException, received: " + listener.getException());
                            pass = false;
                        }
                        break block10;
                    }
                    logger.log(System.Logger.Level.ERROR, "Expected IllegalStateException, got no exception");
                    pass = false;
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected IllegalStateException, received " + e);
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                throw new Exception("topicIllegalStateExceptionTests", e);
            }
        }
        if (!pass) {
            throw new Exception("topicIllegalStateExceptionTests failed");
        }
    }
}

