/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core20.appclient.messageconsumertests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import com.sun.ts.tests.jms.common.TextMessageTestImpl;
import com.sun.ts.tests.jms.core20.appclient.messageconsumertests.MyMessageListener;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClientIT {
    private static final String testName = "com.sun.ts.tests.jms.core20.appclient.messageconsumertests.ClientIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(ClientIT.class.getName());
    private transient JmsTool tool = null;
    private transient JmsTool toolForProducer = null;
    transient MessageProducer producer = null;
    transient MessageConsumer consumer = null;
    transient Connection connection = null;
    transient Session session = null;
    transient Destination destination = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    private static final int numMessages = 3;
    private static final int iterations = 5;
    boolean queueTest = false;

    private void checkExceptionPass(boolean passed) throws Exception {
        if (!passed) {
            logger.log(System.Logger.Level.INFO, "Didn't get expected exception");
            throw new Exception("Didn't get expected exception");
        }
    }

    @BeforeEach
    public void setup() throws Exception {
        try {
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null ");
            }
            if (this.password == null) {
                throw new Exception("'password' is null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' is null");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.INFO, "Closing default Connection");
            this.tool.getDefaultConnection().close();
            if (this.queueTest) {
                logger.log(System.Logger.Level.INFO, "Flush any messages left on Queue");
                this.tool.flushDestination();
            }
            this.tool.closeAllResources();
            if (this.toolForProducer != null) {
                this.toolForProducer.getDefaultConnection().close();
                if (this.queueTest) {
                    logger.log(System.Logger.Level.INFO, "Flush any messages left on Queue");
                    this.toolForProducer.flushDestination();
                }
                this.toolForProducer.closeAllResources();
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("cleanup failed!", e);
        }
    }

    @Test
    public void queueSendRecvMessageListenerTest() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            logger.log(System.Logger.Level.INFO, "Setup JmsTool for COMMON QUEUE");
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.toolForProducer = new JmsTool(13, this.user, this.password, this.mode);
            logger.log(System.Logger.Level.INFO, "Initialize variables after JmsTool setup");
            this.producer = this.toolForProducer.getDefaultProducer();
            this.consumer = this.tool.getDefaultConsumer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = true;
            logger.log(System.Logger.Level.INFO, "Create message listener MyMessageListener");
            MyMessageListener listener = new MyMessageListener();
            logger.log(System.Logger.Level.INFO, "Set message listener MyMessageListener on this MessageConsumer");
            this.consumer.setMessageListener((MessageListener)listener);
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            TextMessageTestImpl expTextMessage = new TextMessageTestImpl();
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setText(message);
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueSendRecvMessageListenerTest");
            logger.log(System.Logger.Level.INFO, "Calling MessageProducer.send(Message)");
            this.producer.send((Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "Poll listener waiting for TestMessage to arrive");
            TextMessage actTextMessage = null;
            for (int i = 0; !listener.isComplete() && i < 60; ++i) {
                logger.log(System.Logger.Level.INFO, "Loop " + i + ": sleep 2 seconds waiting for messages to arrive at listener");
                TestUtil.sleepSec((int)2);
            }
            if (listener.isComplete()) {
                actTextMessage = (TextMessage)listener.getMessage();
            }
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage (actTextMessage=NULL)");
            }
            logger.log(System.Logger.Level.INFO, "Check value of message returned");
            if (!actTextMessage.getText().equals(expTextMessage.getText())) {
                logger.log(System.Logger.Level.ERROR, "Received [" + actTextMessage.getText() + "] expected [" + expTextMessage.getText() + "]");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Retreive MessageListener by calling MessageConsumer.getMessageListener()");
            MessageListener messageListener = this.consumer.getMessageListener();
            if (messageListener == null) {
                logger.log(System.Logger.Level.ERROR, "getMessageListener() returned NULL");
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("queueSendRecvMessageListenerTest", e);
        }
        finally {
            try {
                this.producer.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("queueSendRecvMessageListenerTest failed");
        }
    }

    @Test
    public void topicSendRecvMessageListenerTest() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            logger.log(System.Logger.Level.INFO, "Setup JmsTool for COMMON TOPIC");
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.toolForProducer = new JmsTool(14, this.user, this.password, this.mode);
            logger.log(System.Logger.Level.INFO, "Initialize variables after JmsTool setup");
            this.producer = this.toolForProducer.getDefaultProducer();
            this.consumer = this.tool.getDefaultConsumer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = false;
            logger.log(System.Logger.Level.INFO, "Create message listener MyMessageListener");
            MyMessageListener listener = new MyMessageListener();
            logger.log(System.Logger.Level.INFO, "Set message listener MyMessageListener on this MessageConsumer");
            this.consumer.setMessageListener((MessageListener)listener);
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            TextMessageTestImpl expTextMessage = new TextMessageTestImpl();
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setText(message);
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicSendRecvMessageListenerTest");
            logger.log(System.Logger.Level.INFO, "Calling MessageProducer.send(Message)");
            this.producer.send((Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "Poll listener waiting for TestMessage to arrive");
            TextMessage actTextMessage = null;
            for (int i = 0; !listener.isComplete() && i < 60; ++i) {
                logger.log(System.Logger.Level.INFO, "Loop " + i + ": sleep 2 seconds waiting for messages to arrive at listener");
                TestUtil.sleepSec((int)2);
            }
            if (listener.isComplete()) {
                actTextMessage = (TextMessage)listener.getMessage();
            }
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage (actTextMessage=NULL)");
            }
            logger.log(System.Logger.Level.INFO, "Check value of message returned");
            if (!actTextMessage.getText().equals(expTextMessage.getText())) {
                logger.log(System.Logger.Level.ERROR, "Received [" + actTextMessage.getText() + "] expected [" + expTextMessage.getText() + "]");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Retreive MessageListener by calling MessageConsumer.getMessageListener()");
            MessageListener messageListener = this.consumer.getMessageListener();
            if (messageListener == null) {
                logger.log(System.Logger.Level.ERROR, "getMessageListener() returned NULL");
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("topicSendRecvMessageListenerTest", e);
        }
        finally {
            try {
                this.producer.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("topicSendRecvMessageListenerTest failed");
        }
    }
}

