/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.queueMsgProperties;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageNotWriteableException;
import jakarta.jms.TextMessage;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class QueuePropertyTestsIT {
    private static final String testName = "com.sun.ts.tests.jms.core.queueMsgProperties.QueuePropertyTestsIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(QueuePropertyTestsIT.class.getName());
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList queues = null;
    ArrayList connections = null;

    private void checkExceptionPass(boolean passed) throws Exception {
        if (!passed) {
            logger.log(System.Logger.Level.INFO, "Didn't get expected exception");
            throw new Exception("Didn't catch expected exception");
        }
    }

    @BeforeEach
    public void setup() throws Exception {
        try {
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null");
            }
            if (this.password == null) {
                throw new Exception("'password' is null");
            }
            if (this.mode == null) {
                throw new Exception("'mode' is null");
            }
            this.queues = new ArrayList(2);
            this.connections = new ArrayList(3);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            if (this.tool != null) {
                logger.log(System.Logger.Level.INFO, "Cleanup: Closing Queue Connections");
                this.tool.doClientQueueTestCleanup(this.connections, this.queues);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            logger.log(System.Logger.Level.ERROR, "An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    @Test
    public void msgPropertiesQTest() throws Exception {
        boolean pass = true;
        boolean bool = true;
        byte bValue = 127;
        short nShort = 10;
        int nInt = 5;
        long nLong = 333L;
        float nFloat = 1.0f;
        double nDouble = 100.0;
        String testString = "test";
        Enumeration propertyNames = null;
        Object jmsxDefined = null;
        int numPropertyNames = 18;
        String testMessageBody = "Testing...";
        try {
            short aShort;
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText(testMessageBody);
            messageSent.setBooleanProperty("TESTBOOLEAN", bool);
            messageSent.setByteProperty("TESTBYTE", bValue);
            messageSent.setShortProperty("TESTSHORT", nShort);
            messageSent.setIntProperty("TESTINT", nInt);
            messageSent.setFloatProperty("TESTFLOAT", nFloat);
            messageSent.setDoubleProperty("TESTDOUBLE", nDouble);
            messageSent.setStringProperty("TESTSTRING", "test");
            messageSent.setLongProperty("TESTLONG", nLong);
            messageSent.setObjectProperty("OBJTESTBOOLEAN", (Object)bool);
            messageSent.setObjectProperty("OBJTESTBYTE", (Object)bValue);
            messageSent.setObjectProperty("OBJTESTSHORT", (Object)nShort);
            messageSent.setObjectProperty("OBJTESTINT", (Object)nInt);
            messageSent.setObjectProperty("OBJTESTFLOAT", (Object)Float.valueOf(nFloat));
            messageSent.setObjectProperty("OBJTESTDOUBLE", (Object)nDouble);
            messageSent.setObjectProperty("OBJTESTSTRING", (Object)"test");
            messageSent.setObjectProperty("OBJTESTLONG", (Object)nLong);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgPropertiesQTest");
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            try {
                messageSent.setObjectProperty("OBJTESTLONG", new Object());
                logger.log(System.Logger.Level.INFO, "Error: expected MessageFormatException from invalid ");
                logger.log(System.Logger.Level.INFO, "call to setObjectProperty did not occur!");
                pass = false;
            }
            catch (MessageFormatException fe) {
                logger.log(System.Logger.Level.TRACE, "Pass: ");
                logger.log(System.Logger.Level.TRACE, "      MessageFormatException as expected from invalid setObjectProperty call");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "from call to setObjectProperty!");
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                pass = false;
            }
            int i = 0;
            propertyNames = messageReceived.getPropertyNames();
            do {
                String tmp = (String)propertyNames.nextElement();
                logger.log(System.Logger.Level.TRACE, "+++++++   Property Name is: " + tmp);
                if (tmp.indexOf("JMS") != 0) {
                    ++i;
                    continue;
                }
                if (!tmp.equals("JMSXDeliveryCount")) continue;
                ++i;
            } while (propertyNames.hasMoreElements());
            if (i == numPropertyNames) {
                logger.log(System.Logger.Level.TRACE, "Pass: # of properties is " + numPropertyNames + " as expected");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: expected " + numPropertyNames + " property names, but returned " + i);
                pass = false;
            }
            try {
                messageReceived.setBooleanProperty("TESTBOOLEAN", bool);
                logger.log(System.Logger.Level.INFO, "Error: exception should have occurred for setBooleanProperty");
                pass = false;
            }
            catch (MessageNotWriteableException aBool) {
                logger.log(System.Logger.Level.TRACE, "Pass: exception as expected for setBooleanProperty ");
            }
            try {
                messageReceived.setByteProperty("TESTBYTE", bValue);
                logger.log(System.Logger.Level.INFO, "Error: exception should have occurred for setByteProperty");
                pass = false;
            }
            catch (MessageNotWriteableException aBool) {
                logger.log(System.Logger.Level.TRACE, "Pass: exception as expected for setByteProperty ");
            }
            try {
                messageReceived.setShortProperty("TESTSHORT", nShort);
                pass = false;
                logger.log(System.Logger.Level.INFO, "Error: exception should have occurred for setShortProperty");
            }
            catch (MessageNotWriteableException aBool) {
                logger.log(System.Logger.Level.TRACE, "Pass: exception as expected for setShortProperty ");
            }
            try {
                messageReceived.setIntProperty("TESTINT", nInt);
                logger.log(System.Logger.Level.INFO, "Error: exception should have occurred for setIntProperty");
                pass = false;
            }
            catch (MessageNotWriteableException aBool) {
                logger.log(System.Logger.Level.TRACE, "Pass: exception as expected for setIntProperty ");
            }
            try {
                messageReceived.setFloatProperty("TESTFLOAT", nFloat);
                logger.log(System.Logger.Level.INFO, "Error: exception should have occurred for setFloatProperty");
                pass = false;
            }
            catch (MessageNotWriteableException aBool) {
                logger.log(System.Logger.Level.TRACE, "Pass: exception as expected for setFloatProperty ");
            }
            try {
                messageReceived.setDoubleProperty("TESTDOUBLE", nDouble);
                logger.log(System.Logger.Level.INFO, "Error: exception should have occurred for setDoubleProperty");
                pass = false;
            }
            catch (MessageNotWriteableException aBool) {
                logger.log(System.Logger.Level.TRACE, "Pass: exception as expected for setDoubleProperty ");
            }
            try {
                messageReceived.setStringProperty("TESTSTRING", testString);
                logger.log(System.Logger.Level.INFO, "Error: exception should have occurred for setStringProperty");
                pass = false;
            }
            catch (MessageNotWriteableException aBool) {
                logger.log(System.Logger.Level.TRACE, "Pass: exception as expected for setStringProperty ");
            }
            try {
                messageReceived.setLongProperty("TESTLONG", nLong);
                logger.log(System.Logger.Level.INFO, "Error: exception should have occurred for setLongProperty");
                pass = false;
            }
            catch (MessageNotWriteableException aBool) {
                logger.log(System.Logger.Level.TRACE, "Pass: exception as expected for setLongProperty ");
            }
            try {
                messageReceived.setObjectProperty("OBJTESTBOOLEAN", (Object)bool);
                logger.log(System.Logger.Level.INFO, "Error: exception should have occurred for setObjectProperty");
                pass = false;
            }
            catch (MessageNotWriteableException aBool) {
                logger.log(System.Logger.Level.TRACE, "Pass: exception as expected for setObjectProperty ");
            }
            if (messageReceived.getBooleanProperty("TESTBOOLEAN") == bool) {
                logger.log(System.Logger.Level.TRACE, "Pass: getBooleanProperty returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: incorrect value returned from getBooleanProperty");
                pass = false;
            }
            if (messageReceived.getByteProperty("TESTBYTE") == bValue) {
                logger.log(System.Logger.Level.TRACE, "Pass: getByteProperty returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: incorrect value returned from getByteProperty");
                pass = false;
            }
            if (messageReceived.getLongProperty("TESTLONG") == nLong) {
                logger.log(System.Logger.Level.TRACE, "Pass: getLongProperty returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: incorrect value returned from getLongProperty");
                pass = false;
            }
            if (messageReceived.getStringProperty("TESTSTRING").equals(testString)) {
                logger.log(System.Logger.Level.TRACE, "Pass: getStringProperty returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: incorrect value returned from getStringProperty");
                pass = false;
            }
            if (messageReceived.getDoubleProperty("TESTDOUBLE") == nDouble) {
                logger.log(System.Logger.Level.TRACE, "Pass: getDoubleProperty returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: incorrect value returned from getDoubleProperty");
                pass = false;
            }
            if (messageReceived.getFloatProperty("TESTFLOAT") == nFloat) {
                logger.log(System.Logger.Level.TRACE, "Pass: getFloatProperty returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: incorrect value returned from getFloatProperty");
                pass = false;
            }
            if (messageReceived.getIntProperty("TESTINT") == nInt) {
                logger.log(System.Logger.Level.TRACE, "Pass: getIntProperty returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: incorrect value returned from getIntProperty");
                pass = false;
            }
            if (messageReceived.getShortProperty("TESTSHORT") == nShort) {
                logger.log(System.Logger.Level.TRACE, "Pass: getShortProperty returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: incorrect value returned from getShortProperty");
                pass = false;
            }
            try {
                boolean b = messageReceived.getBooleanProperty("TESTDUMMY");
                if (b) {
                    logger.log(System.Logger.Level.INFO, "Error: should havereceived false for getBooleanProperty");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
            try {
                byte value = messageReceived.getByteProperty("TESTDUMMY");
                logger.log(System.Logger.Level.INFO, "Error: NumberFormatException should have occurred for getByteProperty");
                pass = false;
            }
            catch (NumberFormatException np) {
                logger.log(System.Logger.Level.TRACE, "Pass: NumberFormatException as expected ");
            }
            try {
                short value = messageReceived.getShortProperty("TESTDUMMY");
                logger.log(System.Logger.Level.INFO, "Error: NumberFormatException should have occurred for getShortProperty");
                pass = false;
            }
            catch (NumberFormatException np) {
                logger.log(System.Logger.Level.TRACE, "Pass: NumberFormatException as expected ");
            }
            try {
                int value = messageReceived.getIntProperty("TESTDUMMY");
                logger.log(System.Logger.Level.INFO, "Error: NumberFormatException should have occurred for getIntProperty");
                pass = false;
            }
            catch (NumberFormatException np) {
                logger.log(System.Logger.Level.TRACE, "Pass: NumberFormatException as expected ");
            }
            try {
                long value = messageReceived.getLongProperty("TESTDUMMY");
                logger.log(System.Logger.Level.INFO, "Error: NumberFormatException should have occurred for getLongProperty");
                pass = false;
            }
            catch (NumberFormatException np) {
                logger.log(System.Logger.Level.TRACE, "Pass: NumberFormatException as expected ");
            }
            try {
                float value = messageReceived.getFloatProperty("TESTDUMMY");
                logger.log(System.Logger.Level.INFO, "Error: NullPointerException should have occurred for getFloatProperty");
                pass = false;
            }
            catch (NullPointerException np) {
                logger.log(System.Logger.Level.TRACE, "Pass: NullPointerException as expected ");
            }
            try {
                double value = messageReceived.getDoubleProperty("TESTDUMMY");
                logger.log(System.Logger.Level.INFO, "Error: NullPointerException should have occurred for getDoubleProperty");
                pass = false;
            }
            catch (NullPointerException np) {
                logger.log(System.Logger.Level.TRACE, "Pass: NullPointerException as expected ");
            }
            String value = messageReceived.getStringProperty("TESTDUMMY");
            if (value == null) {
                logger.log(System.Logger.Level.TRACE, "Pass: getStringProperty returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: expected a null return from getStringProperty for invalid property");
                pass = false;
            }
            Boolean aBool = (Boolean)messageReceived.getObjectProperty("TESTDUMMY");
            if (aBool == null) {
                logger.log(System.Logger.Level.TRACE, "Pass: getObjectProperty returned correct value for Boolean");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: expected a null return from getObjectProperty for invalid property");
                pass = false;
            }
            Boolean boolValue = (Boolean)messageReceived.getObjectProperty("OBJTESTBOOLEAN");
            if (boolValue == bool) {
                logger.log(System.Logger.Level.TRACE, "Pass: getObjectProperty returned correct value for Boolean");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: incorrect value returned for Boolean");
                pass = false;
            }
            Byte byteValue = (Byte)messageReceived.getObjectProperty("OBJTESTBYTE");
            if (byteValue == bValue) {
                logger.log(System.Logger.Level.TRACE, "Pass: getObjectProperty returned correct Byte value");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: incorrect value returned from Byte");
                pass = false;
            }
            Long lValue = (Long)messageReceived.getObjectProperty("OBJTESTLONG");
            if (lValue == nLong) {
                logger.log(System.Logger.Level.TRACE, "Pass: getObjectProperty returned correct value for Long");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: getObjectProperty returned incorrect value returned for Long");
                pass = false;
            }
            if (messageReceived.getObjectProperty("OBJTESTSTRING").equals(testString)) {
                logger.log(System.Logger.Level.TRACE, "Pass: getObjectProperty returned correct value for String");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: getObjectProperty returned incorrect value for String");
                pass = false;
            }
            Double dValue = (Double)messageReceived.getObjectProperty("OBJTESTDOUBLE");
            if (dValue == nDouble) {
                logger.log(System.Logger.Level.TRACE, "Pass: getObjectProperty returned correct value for Double");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: getObjectProperty returned incorrect value for Double");
                pass = false;
            }
            Float fValue = (Float)messageReceived.getObjectProperty("OBJTESTFLOAT");
            if (fValue.floatValue() == nFloat) {
                logger.log(System.Logger.Level.TRACE, "Pass: getObjectProperty returned correct value for Float");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: getObjectProperty returned incorrect value for Float");
                pass = false;
            }
            Integer iValue = (Integer)messageReceived.getObjectProperty("OBJTESTINT");
            if (iValue == nInt) {
                logger.log(System.Logger.Level.TRACE, "Pass: getObjectProperty returned correct value for Integer");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: getObjectProperty returned incorrect value for Integer");
                pass = false;
            }
            Short sValue = (Short)messageReceived.getObjectProperty("OBJTESTSHORT");
            if (sValue == nShort) {
                logger.log(System.Logger.Level.TRACE, "Pass: getObjectProperty returned correct value for Short");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: getObjectProperty returned incorrect value for Short");
                pass = false;
            }
            messageReceived.clearProperties();
            Long aLong = (Long)messageReceived.getObjectProperty("OBJTESTLONG");
            if (aLong == null) {
                logger.log(System.Logger.Level.TRACE, "Pass: property was cleared");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: getObjectProperty should have returned null for cleared property");
                pass = false;
            }
            try {
                aShort = messageReceived.getShortProperty("TESTSHORT");
                logger.log(System.Logger.Level.INFO, "Error: NumberFormatException should have occurred for getShortProperty");
                logger.log(System.Logger.Level.INFO, "Properties have been cleared!");
                pass = false;
            }
            catch (NumberFormatException np) {
                logger.log(System.Logger.Level.TRACE, "Pass: NumberFormatException as expected ");
            }
            aLong = (Long)messageReceived.getObjectProperty("OBJTESTLONG");
            if (aLong == null) {
                logger.log(System.Logger.Level.TRACE, "Pass: property was cleared");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: getObjectProperty should have returned null for cleared property");
                pass = false;
            }
            try {
                aShort = messageReceived.getShortProperty("TESTSHORT");
                logger.log(System.Logger.Level.INFO, "Error: NumberFormatException should have occurred for getShortProperty");
                logger.log(System.Logger.Level.INFO, "Properties have been cleared!");
                pass = false;
            }
            catch (NumberFormatException np) {
                logger.log(System.Logger.Level.TRACE, "Pass: NumberFormatException as expected ");
            }
            logger.log(System.Logger.Level.INFO, "Message body is : " + messageReceived.getText());
            if (messageReceived.getText().equals(testMessageBody)) {
                logger.log(System.Logger.Level.TRACE, "Pass: able to read message body after clearProperties");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: unable to read message body after clearProperties");
                pass = false;
            }
            try {
                ConnectionMetaData data = this.tool.getDefaultQueueConnection().getMetaData();
                Enumeration cmd = data.getJMSXPropertyNames();
                if (cmd == null) {
                    logger.log(System.Logger.Level.INFO, "Error: no JMSX property names were returned!");
                    logger.log(System.Logger.Level.INFO, "expected JMSXGroupID, JMSXGroupSeq, JMSXDeliveryCount at a miniumum");
                    pass = false;
                } else {
                    int iCount = 0;
                    do {
                        String propName = (String)cmd.nextElement();
                        logger.log(System.Logger.Level.TRACE, propName);
                        if (!propName.equals("JMSXGroupID") && !propName.equals("JMSXGroupSeq") && !propName.equals("JMSXDeliveryCount")) continue;
                        ++iCount;
                    } while (cmd.hasMoreElements());
                    if (iCount > 1) {
                        logger.log(System.Logger.Level.TRACE, "Pass:");
                    } else {
                        logger.log(System.Logger.Level.INFO, "Error: Expected property names not returned");
                        pass = false;
                    }
                }
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, "attempting to read JMSX property names.");
                logger.log(System.Logger.Level.INFO, "Error: unexpected exception: " + ee.getClass().getName() + " was thrown");
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during property tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgPropertiesQTest failed");
        }
    }

    @Test
    public void msgPropertiesConversionQTest() throws Exception {
        boolean pass = true;
        boolean bool = true;
        byte bValue = 127;
        short nShort = 10;
        int nInt = 5;
        long nLong = 333L;
        float nFloat = 1.0f;
        double nDouble = 100.0;
        String testString = "test";
        String testMessageBody = "Testing...";
        boolean ntest = false;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText(testMessageBody);
            messageSent.setBooleanProperty("TESTBOOLEAN", bool);
            messageSent.setByteProperty("TESTBYTE", bValue);
            messageSent.setShortProperty("TESTSHORT", nShort);
            messageSent.setIntProperty("TESTINT", nInt);
            messageSent.setFloatProperty("TESTFLOAT", nFloat);
            messageSent.setDoubleProperty("TESTDOUBLE", nDouble);
            messageSent.setStringProperty("TESTSTRING", "test");
            messageSent.setLongProperty("TESTLONG", nLong);
            messageSent.setStringProperty("TESTSTRINGTRUE", "true");
            messageSent.setStringProperty("TESTSTRINGFALSE", "false");
            messageSent.setStringProperty("TESTSTRING1", "1");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgPropertiesConversionQTest");
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            String myBool = messageReceived.getStringProperty("TESTBOOLEAN");
            if (Boolean.valueOf(myBool) == bool) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from boolean to string - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from boolean to string failed");
                pass = false;
            }
            try {
                messageReceived.getByteProperty("TESTBOOLEAN");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: boolean to byte ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- boolean to byte");
                pass = false;
            }
            try {
                messageReceived.getShortProperty("TESTBOOLEAN");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: boolean to short ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- boolean to short");
                pass = false;
            }
            try {
                messageReceived.getIntProperty("TESTBOOLEAN");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: boolean to int ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception --boolean to int ");
                pass = false;
            }
            try {
                messageReceived.getLongProperty("TESTBOOLEAN");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: boolean to long ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- boolean to long");
                pass = false;
            }
            try {
                messageReceived.getFloatProperty("TESTBOOLEAN");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: boolean to float ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- boolean to float");
                pass = false;
            }
            try {
                messageReceived.getDoubleProperty("TESTBOOLEAN");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: boolean to double ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- boolean to double");
                pass = false;
            }
            String myByte = messageReceived.getStringProperty("TESTBYTE");
            if (Byte.valueOf(myByte) == bValue) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from byte to string - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from byte to string failed");
                pass = false;
            }
            if (messageReceived.getShortProperty("TESTBYTE") == bValue) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from byte to short - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from byte to short failed");
                pass = false;
            }
            if (messageReceived.getIntProperty("TESTBYTE") == bValue) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from byte to int - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from byte to int failed");
                pass = false;
            }
            if (messageReceived.getLongProperty("TESTBYTE") == (long)bValue) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from byte to long - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from byte to long failed");
                pass = false;
            }
            try {
                messageReceived.getBooleanProperty("TESTBYTE");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: byte to boolean ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- byte to boolean");
                pass = false;
            }
            try {
                messageReceived.getFloatProperty("TESTBYTE");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: byte to float ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception --byte to float ");
                pass = false;
            }
            try {
                messageReceived.getDoubleProperty("TESTBYTE");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: byte to double ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- byte to double");
                pass = false;
            }
            String myshort = messageReceived.getStringProperty("TESTSHORT");
            if (Short.valueOf(myshort) == nShort) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from short to string - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from short to string failed");
                pass = false;
            }
            if (messageReceived.getIntProperty("TESTSHORT") == nShort) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from short to int - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from short to int failed");
                pass = false;
            }
            if (messageReceived.getLongProperty("TESTSHORT") == (long)nShort) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from short to long - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from short to long failed");
                pass = false;
            }
            try {
                messageReceived.getBooleanProperty("TESTSHORT");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: short to boolean ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- short to boolean");
                pass = false;
            }
            try {
                messageReceived.getByteProperty("TESTSHORT");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: short to byte ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- short to byte");
                pass = false;
            }
            try {
                messageReceived.getFloatProperty("TESTSHORT");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: short to float ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- short to float");
                pass = false;
            }
            try {
                messageReceived.getDoubleProperty("TESTSHORT");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: short to double ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- short to double");
                pass = false;
            }
            if (Integer.valueOf(messageReceived.getStringProperty("TESTINT")) == nInt) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from int to string - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from int to string failed");
                pass = false;
            }
            if (messageReceived.getLongProperty("TESTINT") == (long)nInt) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from int to long - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from int to long failed");
                pass = false;
            }
            try {
                messageReceived.getBooleanProperty("TESTINT");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: int to boolean ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- int to boolean");
                pass = false;
            }
            try {
                messageReceived.getByteProperty("TESTINT");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: int to byte ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception --  int to byte");
                pass = false;
            }
            try {
                messageReceived.getShortProperty("TESTINT");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: int to short ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected -- int to short ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception ");
                pass = false;
            }
            try {
                messageReceived.getFloatProperty("TESTINT");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: int to float ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- int to float");
                pass = false;
            }
            try {
                messageReceived.getDoubleProperty("TESTINT");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: int to double ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- int to double");
                pass = false;
            }
            if (Long.valueOf(messageReceived.getStringProperty("TESTLONG")) == nLong) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from long to string - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from long to string failed");
                pass = false;
            }
            try {
                messageReceived.getBooleanProperty("TESTLONG");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: long to boolean ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- long to boolean");
                pass = false;
            }
            try {
                messageReceived.getByteProperty("TESTLONG");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: long to byte ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- long to byte");
                pass = false;
            }
            try {
                messageReceived.getShortProperty("TESTLONG");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: long to short ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- long to short ");
                pass = false;
            }
            try {
                messageReceived.getIntProperty("TESTLONG");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: long to int ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- long to int");
                pass = false;
            }
            try {
                messageReceived.getFloatProperty("TESTLONG");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: long to float ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- long to float");
                pass = false;
            }
            try {
                messageReceived.getDoubleProperty("TESTLONG");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: long to double ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- long to double");
                pass = false;
            }
            if (Float.valueOf(messageReceived.getStringProperty("TESTFLOAT")).floatValue() == nFloat) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from float to string - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from float to string failed");
                pass = false;
            }
            if (messageReceived.getDoubleProperty("TESTFLOAT") == (double)nFloat) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from long to double - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from long to double failed");
                pass = false;
            }
            try {
                messageReceived.getBooleanProperty("TESTFLOAT");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: float to boolean ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- float to boolean ");
                pass = false;
            }
            try {
                messageReceived.getByteProperty("TESTFLOAT");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: float to byte ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- float to byte");
                pass = false;
            }
            try {
                messageReceived.getShortProperty("TESTFLOAT");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: float to short ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception - float to short ");
                pass = false;
            }
            try {
                messageReceived.getIntProperty("TESTFLOAT");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: float to int ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception --- float to int");
                pass = false;
            }
            try {
                messageReceived.getLongProperty("TESTFLOAT");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: float to long ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception --  float to long");
                pass = false;
            }
            if (Double.valueOf(messageReceived.getStringProperty("TESTDOUBLE")) == nDouble) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from double to string - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from double to string failed");
                pass = false;
            }
            try {
                messageReceived.getBooleanProperty("TESTDOUBLE");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: double to boolean ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- double to boolean ");
                pass = false;
            }
            try {
                messageReceived.getByteProperty("TESTDOUBLE");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: double to byte ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- double to byte ");
                pass = false;
            }
            try {
                messageReceived.getShortProperty("TESTDOUBLE");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: double to short ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- double to short");
                pass = false;
            }
            try {
                messageReceived.getIntProperty("TESTDOUBLE");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: double to int ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception --- double to int ");
                pass = false;
            }
            try {
                messageReceived.getLongProperty("TESTDOUBLE");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: double to long ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- double to long");
                pass = false;
            }
            try {
                messageReceived.getFloatProperty("TESTDOUBLE");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: double to float ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- double to float");
                pass = false;
            }
            if (messageReceived.getBooleanProperty("TESTSTRINGTRUE")) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from string to boolean - expect true - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from string to boolean - expect true  - failed");
                pass = false;
            }
            if (!messageReceived.getBooleanProperty("TESTSTRINGFALSE")) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from string to boolean expect false - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from string to boolean expect false - failed");
                pass = false;
            }
            if (messageReceived.getByteProperty("TESTSTRING1") == 1) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from string to byte - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from string to byte failed");
                pass = false;
            }
            if (messageReceived.getShortProperty("TESTSTRING1") == 1) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from string to short - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from string to short failed");
                pass = false;
            }
            if (messageReceived.getIntProperty("TESTSTRING1") == 1) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from string to int - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from string to int failed");
                pass = false;
            }
            if (messageReceived.getLongProperty("TESTSTRING1") == 1L) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from string to long - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from string to long failed");
                pass = false;
            }
            if (messageReceived.getFloatProperty("TESTSTRING1") == 1.0f) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from string to float - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from string to float failed");
                pass = false;
            }
            if (messageReceived.getDoubleProperty("TESTSTRING1") == 1.0) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from string to double - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from string to double failed");
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during property conversion tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgPropertiesConversionQTest failed");
        }
    }

    @Test
    public void msgPropertyExistTest() throws Exception {
        boolean pass = true;
        boolean bool = true;
        byte bValue = 127;
        short nShort = 10;
        int nInt = 5;
        long nLong = 333L;
        float nFloat = 1.0f;
        double nDouble = 100.0;
        String testString = "test";
        Enumeration propertyNames = null;
        String testMessageBody = "Testing msgPropertyExistTest";
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText(testMessageBody);
            messageSent.setBooleanProperty("TESTBOOLEAN", bool);
            messageSent.setByteProperty("TESTBYTE", bValue);
            messageSent.setShortProperty("TESTSHORT", nShort);
            messageSent.setIntProperty("TESTINT", nInt);
            messageSent.setFloatProperty("TESTFLOAT", nFloat);
            messageSent.setDoubleProperty("TESTDOUBLE", nDouble);
            messageSent.setStringProperty("TESTSTRING", "test");
            messageSent.setLongProperty("TESTLONG", nLong);
            messageSent.setObjectProperty("OBJTESTBOOLEAN", (Object)bool);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            int i = 0;
            propertyNames = messageReceived.getPropertyNames();
            do {
                String tmp;
                if ((tmp = (String)propertyNames.nextElement()).indexOf("JMS") != 0) {
                    ++i;
                    if (tmp.equals("TESTBOOLEAN") || tmp.equals("TESTBYTE") || tmp.equals("TESTINT") || tmp.equals("TESTSHORT") || tmp.equals("TESTFLOAT") || tmp.equals("TESTDOUBLE") || tmp.equals("TESTSTRING") || tmp.equals("TESTLONG") || tmp.equals("OBJTESTBOOLEAN")) {
                        logger.log(System.Logger.Level.TRACE, "+++++++Appclication Property set by client is: " + tmp);
                        if (!messageReceived.propertyExists(tmp)) {
                            pass = messageReceived.propertyExists(tmp);
                            logger.log(System.Logger.Level.ERROR, "Positive propertyExists test failed for " + tmp);
                            continue;
                        }
                        if (!messageReceived.propertyExists(tmp + "1")) continue;
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Negative propertyExists test failed for " + tmp + "1");
                        continue;
                    }
                    logger.log(System.Logger.Level.ERROR, "+++++++Appclication Property not set by client: " + tmp);
                    pass = false;
                    continue;
                }
                logger.log(System.Logger.Level.TRACE, "+++++++   JMSProperty Name is: " + tmp);
            } while (propertyNames.hasMoreElements());
            if (!pass) {
                throw new Exception("Error: failures occurred during propertyExists tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgPropertyExistTest failed");
        }
    }
}

